/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.languageconfiguration.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.tm4e.languageconfiguration.ILanguageConfigurationDefinition;
import org.eclipse.tm4e.languageconfiguration.internal.AbstractLanguageConfigurationRegistryManager;
import org.eclipse.tm4e.languageconfiguration.internal.LanguageConfigurationDefinition;
import org.eclipse.tm4e.languageconfiguration.internal.preferences.PreferenceHelper;
import org.eclipse.tm4e.languageconfiguration.internal.supports.CharacterPair;
import org.eclipse.tm4e.languageconfiguration.internal.supports.CharacterPairSupport;
import org.eclipse.tm4e.languageconfiguration.internal.supports.CommentSupport;
import org.eclipse.tm4e.languageconfiguration.internal.supports.EnterAction;
import org.eclipse.tm4e.languageconfiguration.internal.supports.EnterActionAndIndent;
import org.eclipse.tm4e.languageconfiguration.internal.supports.OnEnterSupport;
import org.eclipse.tm4e.languageconfiguration.internal.utils.TextUtils;
import org.osgi.service.prefs.BackingStoreException;

public class LanguageConfigurationRegistryManager
extends AbstractLanguageConfigurationRegistryManager {
    private static final String EXTENSION_LANGUAGE_CONFIGURATIONS = "languageConfigurations";
    private static final String LANGUAGE_CONFIGURATION_ELT = "languageConfiguration";
    private static LanguageConfigurationRegistryManager INSTANCE;

    public static LanguageConfigurationRegistryManager getInstance() {
        if (INSTANCE != null) {
            return INSTANCE;
        }
        INSTANCE = LanguageConfigurationRegistryManager.createInstance();
        return INSTANCE;
    }

    private static synchronized LanguageConfigurationRegistryManager createInstance() {
        if (INSTANCE != null) {
            return INSTANCE;
        }
        LanguageConfigurationRegistryManager manager = new LanguageConfigurationRegistryManager();
        manager.load();
        return manager;
    }

    private LanguageConfigurationDefinition getDefinition(IContentType contentType) {
        LanguageConfigurationDefinition bestFit = null;
        ILanguageConfigurationDefinition[] iLanguageConfigurationDefinitionArray = this.getDefinitions();
        int n = iLanguageConfigurationDefinitionArray.length;
        int n2 = 0;
        while (n2 < n) {
            LanguageConfigurationDefinition definition;
            ILanguageConfigurationDefinition iDefinition = iLanguageConfigurationDefinitionArray[n2];
            if (iDefinition instanceof LanguageConfigurationDefinition && contentType.isKindOf((definition = (LanguageConfigurationDefinition)iDefinition).getContentType()) && (bestFit == null || definition.getContentType().isKindOf(bestFit.getContentType()))) {
                bestFit = definition;
            }
            ++n2;
        }
        return bestFit;
    }

    public CharacterPair getAutoClosePair(String text, Integer offset, String newCharacter, IContentType contentType) {
        LanguageConfigurationDefinition definition = this.getDefinition(contentType);
        if (definition == null || !definition.isBracketAutoClosingEnabled().booleanValue()) {
            return null;
        }
        CharacterPairSupport characterPairSupport = this._getCharacterPairSupport(contentType);
        return characterPairSupport == null ? null : characterPairSupport.getAutoClosePair(text, offset, newCharacter);
    }

    public boolean shouldSurroundingPairs(IDocument document, int offset, IContentType contentType) {
        LanguageConfigurationDefinition definition = this.getDefinition(contentType);
        if (definition == null || !definition.isMatchingPairsEnabled().booleanValue()) {
            return false;
        }
        CharacterPairSupport characterPairSupport = this._getCharacterPairSupport(contentType);
        return characterPairSupport != null;
    }

    public boolean shouldEnterAction(IDocument document, int offset, IContentType contentType) {
        LanguageConfigurationDefinition definition = this.getDefinition(contentType);
        if (definition == null || !definition.isOnEnterEnabled().booleanValue()) {
            return false;
        }
        OnEnterSupport onEnterSupport = this._getOnEnterSupport(contentType);
        return onEnterSupport != null;
    }

    public boolean shouldComment(IContentType contentType) {
        LanguageConfigurationDefinition definition = this.getDefinition(contentType);
        if (definition == null || !definition.isOnEnterEnabled().booleanValue()) {
            return false;
        }
        CommentSupport commentSupport = this.getCommentSupport(contentType);
        return commentSupport != null;
    }

    public List<CharacterPair> getAutoClosingPairs(IContentType contentType) {
        CharacterPairSupport characterPairSupport = this._getCharacterPairSupport(contentType);
        if (characterPairSupport == null) {
            return Collections.emptyList();
        }
        return characterPairSupport.getAutoClosingPairs();
    }

    public List<CharacterPair> getSurroundingPairs(IContentType contentType) {
        CharacterPairSupport characterPairSupport = this._getCharacterPairSupport(contentType);
        if (characterPairSupport == null) {
            return Collections.emptyList();
        }
        return characterPairSupport.getSurroundingPairs();
    }

    public EnterActionAndIndent getEnterAction(IDocument document, int offset, IContentType contentType) {
        EnterAction enterResult;
        String indentation;
        block10: {
            indentation = TextUtils.getLinePrefixingWhitespaceAtPosition(document, offset);
            OnEnterSupport onEnterSupport = this._getOnEnterSupport(contentType);
            if (onEnterSupport == null) {
                return null;
            }
            try {
                IRegion lineInfo = document.getLineInformationOfOffset(offset);
                String beforeEnterText = document.get(lineInfo.getOffset(), offset - lineInfo.getOffset());
                String afterEnterText = null;
                afterEnterText = document.get(offset, lineInfo.getLength() - (offset - lineInfo.getOffset()));
                String oneLineAboveText = "";
                enterResult = null;
                try {
                    enterResult = onEnterSupport.onEnter(oneLineAboveText, beforeEnterText, afterEnterText);
                }
                catch (Exception exception) {}
                if (enterResult != null) break block10;
                return null;
            }
            catch (BadLocationException badLocationException) {
                return null;
            }
        }
        if (enterResult.getAppendText() == null) {
            if (enterResult.getIndentAction() == EnterAction.IndentAction.Indent || enterResult.getIndentAction() == EnterAction.IndentAction.IndentOutdent) {
                enterResult.setAppendText("\t");
            } else {
                enterResult.setAppendText("");
            }
        }
        if (enterResult.getRemoveText() != null) {
            indentation = indentation.substring(0, indentation.length() - enterResult.getRemoveText());
        }
        return new EnterActionAndIndent(enterResult, indentation);
    }

    public CommentSupport getCommentSupport(IContentType contentType) {
        LanguageConfigurationDefinition value = this.getDefinition(contentType);
        if (value == null) {
            return null;
        }
        return value.getCommentSupport();
    }

    private OnEnterSupport _getOnEnterSupport(IContentType contentType) {
        LanguageConfigurationDefinition value = this.getDefinition(contentType);
        if (value == null) {
            return null;
        }
        return value.getOnEnter();
    }

    private CharacterPairSupport _getCharacterPairSupport(IContentType contentType) {
        LanguageConfigurationDefinition value = this.getDefinition(contentType);
        if (value == null) {
            return null;
        }
        return value.getCharacterPair();
    }

    private void load() {
        this.loadFromExtensionPoints();
        this.loadFromPreferences();
    }

    private void loadFromExtensionPoints() {
        IConfigurationElement[] cf;
        IConfigurationElement[] iConfigurationElementArray = cf = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.tm4e.languageconfiguration", EXTENSION_LANGUAGE_CONFIGURATIONS);
        int n = cf.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement ce = iConfigurationElementArray[n2];
            String name = ce.getName();
            if (LANGUAGE_CONFIGURATION_ELT.equals(name)) {
                LanguageConfigurationDefinition delegate = new LanguageConfigurationDefinition(ce);
                this.registerLanguageConfigurationDefinition(delegate);
            }
            ++n2;
        }
    }

    private void loadFromPreferences() {
        IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode("org.eclipse.tm4e.languageconfiguration");
        String json = prefs.get("org.eclipse.tm4e.languageConfigurations", null);
        if (json != null) {
            ILanguageConfigurationDefinition[] definitions;
            ILanguageConfigurationDefinition[] iLanguageConfigurationDefinitionArray = definitions = PreferenceHelper.loadLanguageConfigurationDefinitions(json);
            int n = definitions.length;
            int n2 = 0;
            while (n2 < n) {
                ILanguageConfigurationDefinition definition = iLanguageConfigurationDefinitionArray[n2];
                this.registerLanguageConfigurationDefinition(definition);
                ++n2;
            }
        }
    }

    @Override
    public void save() throws BackingStoreException {
        ArrayList<ILanguageConfigurationDefinition> definitions = new ArrayList<ILanguageConfigurationDefinition>();
        this.userDefinitions.values().forEach(definition -> {
            boolean bl = definitions.add((ILanguageConfigurationDefinition)definition);
        });
        this.pluginDefinitions.values().forEach(definition -> {
            if (!(definition.isBracketAutoClosingEnabled().booleanValue() && definition.isMatchingPairsEnabled().booleanValue() && definition.isOnEnterEnabled().booleanValue())) {
                definitions.add((ILanguageConfigurationDefinition)definition);
            }
        });
        String json = PreferenceHelper.toJson(definitions);
        IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode("org.eclipse.tm4e.languageconfiguration");
        prefs.put("org.eclipse.tm4e.languageConfigurations", json);
        prefs.flush();
    }
}

