/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.tools.internal.views.common;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.sirius.business.api.modelingproject.ModelingProject;
import org.eclipse.sirius.business.api.query.URIQuery;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.viewpoint.DAnalysisSessionEObject;

public final class FileSessionFinder {
    private FileSessionFinder() {
    }

    public static List<Session> getSelectedSessions(Collection<?> listObject) {
        ArrayList<Session> selectedSessions = new ArrayList<Session>();
        if (listObject == null) {
            return selectedSessions;
        }
        for (Object selected : listObject) {
            Collection<Session> fileSessions;
            if (selected instanceof Session) {
                selectedSessions.add((Session)selected);
                continue;
            }
            if (!(selected instanceof IFile) || (fileSessions = FileSessionFinder.getSessionFromFile((IFile)selected, false, true)) == null || fileSessions.isEmpty()) continue;
            selectedSessions.addAll(fileSessions);
        }
        return selectedSessions;
    }

    public static List<Session> getRelatedSessions(Collection<IFile> files) {
        return FileSessionFinder.getRelatedSessions(files, true, true);
    }

    public static List<Session> getRelatedSessions(Collection<IFile> files, boolean lookFromSemanticAndControlled, boolean getOnlyMainSessionForNoModelingProject) {
        ArrayList<Session> selectedSessions = new ArrayList<Session>();
        if (files == null) {
            return selectedSessions;
        }
        for (IFile file : files) {
            Collection<Session> fileSessions;
            if (file == null || (fileSessions = FileSessionFinder.getSessionFromFile(file, lookFromSemanticAndControlled, getOnlyMainSessionForNoModelingProject)) == null || fileSessions.isEmpty()) continue;
            selectedSessions.addAll(fileSessions);
        }
        return selectedSessions;
    }

    private static Collection<Session> getSessionFromFile(IFile file, boolean lookFromSemanticAndControlled, boolean getOnlyMainSessionForNoModelingProject) {
        LinkedHashSet<Session> sessions = new LinkedHashSet<Session>();
        boolean lookForTransientSession = !"aird".equals(file.getFileExtension());
        URI fileURI = FileSessionFinder.getFileUri(file);
        for (Session session : SessionManager.INSTANCE.getSessions()) {
            if (!FileSessionFinder.checkedSession(session, file, fileURI, lookForTransientSession, lookFromSemanticAndControlled, getOnlyMainSessionForNoModelingProject)) continue;
            sessions.add(session);
        }
        return sessions;
    }

    private static boolean checkedSession(Session session, IFile file, URI fileURI, boolean lookForTransientSession, boolean lookFromSemantic, boolean getOnlyMainSessionForNoModelingProject) {
        boolean foundSession = false;
        Resource sessionResource = session.getSessionResource();
        if (session.isOpen() && sessionResource != null) {
            if (lookFromSemantic || lookForTransientSession && new URIQuery(sessionResource.getURI()).isInMemoryURI()) {
                Iterable resourceToCheck = session.getSemanticResources();
                if (session instanceof DAnalysisSessionEObject && lookFromSemantic) {
                    resourceToCheck = Iterables.concat((Iterable)session.getSemanticResources(), (Iterable)((DAnalysisSessionEObject)session).getControlledResources());
                }
                foundSession = FileSessionFinder.checkSession(fileURI, resourceToCheck);
            } else {
                foundSession = sessionResource.getURI().equals(fileURI);
                if (!foundSession && (!getOnlyMainSessionForNoModelingProject || getOnlyMainSessionForNoModelingProject && ModelingProject.hasModelingProjectNature((IProject)file.getProject()))) {
                    foundSession = FileSessionFinder.checkSession(fileURI, session.getAllSessionResources());
                }
            }
        }
        return foundSession;
    }

    private static boolean checkSession(URI fileURI, Iterable<Resource> resourceToCheck) {
        boolean foundSession = false;
        for (Resource res : resourceToCheck) {
            if (!res.getURI().equals(fileURI)) continue;
            foundSession = true;
            break;
        }
        return foundSession;
    }

    private static URI getFileUri(IFile file) {
        return URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true);
    }
}

