/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling.el.internal;

import org.eclipse.sapphire.LocalizableText;
import org.eclipse.sapphire.Property;
import org.eclipse.sapphire.PropertyContentEvent;
import org.eclipse.sapphire.PropertyEvent;
import org.eclipse.sapphire.Text;
import org.eclipse.sapphire.Transient;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.modeling.el.FunctionException;
import org.eclipse.sapphire.modeling.el.internal.PropertyFunction;

public final class ContentFunction
extends PropertyFunction<Property> {
    @Text(value="Function Content cannot be applied to a {0} object.")
    private static LocalizableText unsupportedTypeMessage;

    static {
        LocalizableText.init(ContentFunction.class);
    }

    @Override
    public String name() {
        return "Content";
    }

    @Override
    protected Object evaluate(Property property) {
        if (property instanceof Value) {
            return ((Value)property).content();
        }
        if (property instanceof Transient) {
            return ((Transient)property).content();
        }
        String msg = unsupportedTypeMessage.format(property.getClass().getName());
        throw new FunctionException(msg);
    }

    @Override
    protected boolean relevant(PropertyEvent event) {
        return event instanceof PropertyContentEvent;
    }
}

