/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.modeling;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.eclipse.sapphire.FileUtil;
import org.eclipse.sapphire.modeling.ByteArrayResourceStore;
import org.eclipse.sapphire.modeling.ResourceStoreException;
import org.eclipse.sapphire.modeling.ValidateEditException;

public class FileResourceStore
extends ByteArrayResourceStore {
    private final File file;

    public FileResourceStore(File file) throws ResourceStoreException {
        this.file = file;
        if (this.file.exists()) {
            try {
                Throwable throwable = null;
                Object var3_5 = null;
                try (FileInputStream in = new FileInputStream(this.file);){
                    this.setContents(in);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                throw new ResourceStoreException(e);
            }
        }
    }

    public File getFile() {
        return this.file;
    }

    @Override
    public void save() throws ResourceStoreException {
        this.validateSave();
        try {
            FileUtil.mkdirs(this.file.getParentFile());
        }
        catch (IOException e) {
            throw new ResourceStoreException(e);
        }
        try {
            Throwable e = null;
            Object var2_5 = null;
            try (FileOutputStream out = new FileOutputStream(this.file);){
                ((OutputStream)out).write(this.getContents());
                out.flush();
            }
            catch (Throwable throwable) {
                if (e == null) {
                    e = throwable;
                } else if (e != throwable) {
                    e.addSuppressed(throwable);
                }
                throw e;
            }
        }
        catch (IOException e) {
            throw new ResourceStoreException(e);
        }
    }

    @Override
    public void validateSave() {
        if (this.file.exists() && !this.file.canWrite()) {
            throw new ValidateEditException();
        }
    }

    @Override
    public <A> A adapt(Class<A> adapterType) {
        A result = null;
        result = adapterType == File.class ? (A)adapterType.cast(this.file) : (A)super.adapt(adapterType);
        return result;
    }
}

