/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.internal;

import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ElementProperty;
import org.eclipse.sapphire.Event;
import org.eclipse.sapphire.ImpliedElementProperty;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.LoggingService;
import org.eclipse.sapphire.PropertyDef;
import org.eclipse.sapphire.RequiredConstraintService;
import org.eclipse.sapphire.Sapphire;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.modeling.annotations.Required;
import org.eclipse.sapphire.modeling.el.FailSafeFunction;
import org.eclipse.sapphire.modeling.el.Function;
import org.eclipse.sapphire.modeling.el.FunctionResult;
import org.eclipse.sapphire.modeling.el.Literal;
import org.eclipse.sapphire.modeling.el.ModelElementFunctionContext;
import org.eclipse.sapphire.modeling.el.parser.ExpressionLanguageParser;
import org.eclipse.sapphire.services.ServiceCondition;
import org.eclipse.sapphire.services.ServiceContext;

public final class DeclarativeRequiredConstraintService
extends RequiredConstraintService {
    private FunctionResult functionResult;

    @Override
    protected void initRequiredConstraintService() {
        Function function;
        Required annotation = this.context(PropertyDef.class).getAnnotation(Required.class);
        if (annotation == null) {
            function = Literal.FALSE;
        } else {
            String expr = annotation.value().trim();
            if (expr.length() == 0) {
                function = Literal.TRUE;
            } else {
                try {
                    function = ExpressionLanguageParser.parse(expr);
                    function = FailSafeFunction.create(function, Boolean.class, false);
                }
                catch (Exception e) {
                    Sapphire.service(LoggingService.class).log(e);
                    function = Literal.FALSE;
                }
            }
        }
        ModelElementFunctionContext context = new ModelElementFunctionContext(this.context(Element.class));
        this.functionResult = function.evaluate(context);
        Listener listener = new Listener(){

            @Override
            public void handle(Event event) {
                DeclarativeRequiredConstraintService.this.refresh();
            }
        };
        this.functionResult.attach(listener);
    }

    @Override
    protected Boolean compute() {
        return (Boolean)this.functionResult.value();
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.functionResult != null) {
            try {
                this.functionResult.dispose();
            }
            catch (Exception e) {
                Sapphire.service(LoggingService.class).log(e);
            }
        }
    }

    public static final class Condition
    extends ServiceCondition {
        @Override
        public boolean applicable(ServiceContext context) {
            PropertyDef property = context.find(PropertyDef.class);
            return property instanceof ValueProperty || property instanceof ElementProperty && !(property instanceof ImpliedElementProperty);
        }
    }
}

