/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.eclipse.sapphire.Text;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.internal.ValueSnapshot;
import org.eclipse.sapphire.services.ValueLabelService;

public final class LocalizableText {
    private static final String EXTENSION = ".properties";
    private static String[] suffixes;
    private final String text;

    public static void init(Class<?> clazz) {
        LocalizableText.init(clazz, null);
    }

    public static void init(final Class<?> clazz, String resource) {
        String resourceBaseName;
        if (clazz == null) {
            throw new IllegalArgumentException();
        }
        String string = resourceBaseName = resource == null ? clazz.getName() : resource;
        if (System.getSecurityManager() == null) {
            LocalizableText.load(clazz, resourceBaseName);
        } else {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    LocalizableText.load(clazz, resourceBaseName);
                    return null;
                }
            });
        }
    }

    private static void load(Class<?> clazz, String resource) {
        HashMap<String, Field> fields = new HashMap<String, Field>();
        Field[] fieldArray = clazz.getDeclaredFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            if ((field.getModifiers() & 8) != 0 && field.getType() == LocalizableText.class) {
                field.setAccessible(true);
                fields.put(field.getName(), field);
            }
            ++n2;
        }
        ClassLoader loader = clazz.getClassLoader();
        if (loader == null) {
            loader = ClassLoader.getSystemClassLoader();
        }
        if (suffixes == null) {
            String nl = Locale.getDefault().toString();
            ArrayList<String> result = new ArrayList<String>(4);
            while (true) {
                result.add(String.valueOf('_') + nl + EXTENSION);
                int lastSeparator = nl.lastIndexOf(95);
                if (lastSeparator == -1) break;
                nl = nl.substring(0, lastSeparator);
            }
            result.add(EXTENSION);
            suffixes = result.toArray(new String[result.size()]);
        }
        String root = resource.replace('.', '/');
        String[] stringArray = suffixes;
        int n3 = suffixes.length;
        int n4 = 0;
        while (n4 < n3) {
            String suffix = stringArray[n4];
            String variant = String.valueOf(root) + suffix;
            InputStream input = loader.getResourceAsStream(variant);
            if (input != null) {
                Properties properties = null;
                try {
                    Throwable throwable = null;
                    Iterator<Map.Entry<Object, Object>> iterator = null;
                    try (InputStream in = input;){
                        properties = new Properties();
                        properties.load(new InputStreamReader(input, "UTF-8"));
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (IOException e) {
                    System.err.println("Error loading " + variant);
                    e.printStackTrace();
                }
                if (properties != null) {
                    for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                        String key = (String)entry.getKey();
                        Field field = (Field)fields.get(key);
                        if (field == null) {
                            String msg = "Unused message: " + key + " in: " + resource;
                            System.err.println(msg);
                            continue;
                        }
                        try {
                            if (field.get(null) != null) continue;
                            field.set(null, new LocalizableText(new String(((String)entry.getValue()).toCharArray())));
                        }
                        catch (Exception e) {
                            System.err.println("Exception setting field " + field.getName());
                            e.printStackTrace();
                        }
                    }
                }
            }
            ++n4;
        }
        for (Field field : fields.values()) {
            try {
                if (field.get(null) != null) continue;
                Text annotation = field.getAnnotation(Text.class);
                String value = annotation != null ? annotation.value() : "Missing message: " + field.getName() + " in: " + resource;
                field.set(null, new LocalizableText(value));
            }
            catch (Exception e) {
                System.err.println("Exception setting field " + field.getName());
                e.printStackTrace();
            }
        }
    }

    private LocalizableText(String text) {
        this.text = text;
    }

    public String text() {
        return this.text;
    }

    public String format(Object ... bindings) {
        Object[] objects;
        if (bindings == null || bindings.length == 0) {
            return this.text;
        }
        boolean foundValueInBindings = false;
        Object[] objectArray = bindings;
        int n = bindings.length;
        int n2 = 0;
        while (n2 < n) {
            Object binding = objectArray[n2];
            if (binding instanceof Value || binding instanceof ValueSnapshot) {
                foundValueInBindings = true;
                break;
            }
            ++n2;
        }
        if (foundValueInBindings) {
            objects = new Object[bindings.length];
            int i = 0;
            while (i < bindings.length) {
                Object binding = bindings[i];
                if (binding instanceof Value) {
                    Value value = (Value)binding;
                    objects[i] = LocalizableText.format(value.definition(), value.text());
                } else if (binding instanceof ValueSnapshot) {
                    ValueSnapshot snapshot = (ValueSnapshot)binding;
                    objects[i] = LocalizableText.format(snapshot.property(), snapshot.text());
                } else {
                    objects[i] = binding;
                }
                ++i;
            }
        } else {
            objects = bindings;
        }
        return MessageFormat.format(this.text, objects);
    }

    private static String format(ValueProperty property, String text) {
        String formatted = property.service(ValueLabelService.class).provide(text);
        if (!(property.isOfType(Byte.class) || property.isOfType(Short.class) || property.isOfType(Integer.class) || property.isOfType(Long.class) || property.isOfType(Float.class) || property.isOfType(Double.class) || property.isOfType(BigInteger.class) || property.isOfType(BigDecimal.class) || property.isOfType(Boolean.class))) {
            formatted = "\"" + formatted + "\"";
        }
        return formatted;
    }

    public String toString() {
        return this.text;
    }
}

