/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.junit.internal.configuration;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.reddeer.junit.requirement.configuration.RequirementConfiguration;

public class RequirementConfigurationSet {
    public static final String EMPTY_SET_ID = "no-configuration";
    private Set<RequirementConfiguration> set;

    public RequirementConfigurationSet() {
        this.set = new HashSet<RequirementConfiguration>();
    }

    public RequirementConfigurationSet(Set<RequirementConfiguration> set) {
        this.set = set;
    }

    public void setConfigurations(Set<RequirementConfiguration> set) {
        this.set = set;
    }

    public void addConfiguration(RequirementConfiguration configuration) {
        this.set.add(configuration);
    }

    public Set<RequirementConfiguration> getConfigurationSet() {
        return this.set;
    }

    public String getId() {
        StringBuilder sb = new StringBuilder();
        Iterator<RequirementConfiguration> iterator = this.set.iterator();
        while (iterator.hasNext()) {
            RequirementConfiguration configuration = iterator.next();
            sb.append(configuration.getId());
            if (!iterator.hasNext()) continue;
            sb.append("_");
        }
        if (sb.length() > 0) {
            return sb.toString();
        }
        return EMPTY_SET_ID;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.set == null ? 0 : this.set.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RequirementConfigurationSet other = (RequirementConfigurationSet)obj;
        return !(this.set == null ? other.set != null : !this.set.equals(other.set));
    }
}

