/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.AbstractPartialPartition;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.MappingPartitioner;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.utilities.ReachabilityForest;
import org.eclipse.qvtd.pivot.qvtschedule.Edge;
import org.eclipse.qvtd.pivot.qvtschedule.MappingRegion;
import org.eclipse.qvtd.pivot.qvtschedule.NavigableEdge;
import org.eclipse.qvtd.pivot.qvtschedule.Node;
import org.eclipse.qvtd.pivot.qvtschedule.Region;
import org.eclipse.qvtd.pivot.qvtschedule.Role;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.QVTscheduleUtil;

class ActivatorPartition
extends AbstractPartialPartition {
    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public ActivatorPartition(@NonNull MappingPartitioner partitioner, @NonNull ReachabilityForest reachabilityForest) {
        super(partitioner, reachabilityForest, "\u00abactivator\u00bb");
        @NonNull Iterable headNodes = QVTscheduleUtil.getHeadNodes((Region)this.region);
        for (Node traceNode : partitioner.getTraceNodes()) {
            this.addNode(traceNode, Role.SPECULATION);
        }
        for (Node headNode : headNodes) {
            if (headNode.isDependency()) continue;
            this.addNode(headNode);
        }
        this.resolveEdges();
    }

    protected void addReachableOldAcyclicNodes(@NonNull Node node) {
        if (!this.hasNode(node) && (node.isHead() || node.isOld() && !this.partitioner.isCyclic(node))) {
            this.addNode(node, QVTscheduleUtil.getNodeRole((Node)node));
            for (NavigableEdge edge : node.getNavigableEdges()) {
                if (!edge.isOld()) continue;
                this.addReachableOldAcyclicNodes(edge.getEdgeTarget());
            }
        }
    }

    @Override
    public @NonNull MappingRegion createMicroMappingRegion(int partitionNumber) {
        return this.createMicroMappingRegion("\u00abactivator\u00bb", "_p" + partitionNumber);
    }

    @Override
    protected @Nullable Iterable<@NonNull Node> getPreferredHeadNodes() {
        return null;
    }

    @Override
    protected boolean isAvailable(@NonNull Edge edge) {
        return edge.isConstant() || edge.isLoaded();
    }

    @Override
    protected boolean isAvailable(@NonNull Node node) {
        return node.isConstant() || node.isLoaded();
    }

    @Override
    protected @Nullable Role resolveEdgeRole(@NonNull Role sourceNodeRole, @NonNull Edge edge, @NonNull Role targetNodeRole) {
        Role edgeRole = QVTscheduleUtil.getEdgeRole((Edge)edge);
        if (edgeRole == Role.REALIZED) assert (!this.partitioner.hasRealizedEdge(edge));
        return edgeRole;
    }
}

