/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvtr2qvts;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.CallExp;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.CompleteClass;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.NamedElement;
import org.eclipse.ocl.pivot.OCLExpression;
import org.eclipse.ocl.pivot.Operation;
import org.eclipse.ocl.pivot.OperationCallExp;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.TypedElement;
import org.eclipse.ocl.pivot.Variable;
import org.eclipse.ocl.pivot.VariableDeclaration;
import org.eclipse.ocl.pivot.VariableExp;
import org.eclipse.ocl.pivot.ids.OperationId;
import org.eclipse.ocl.pivot.util.Visitable;
import org.eclipse.ocl.pivot.util.Visitor;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.Nameable;
import org.eclipse.ocl.pivot.utilities.PivotUtil;
import org.eclipse.ocl.pivot.utilities.TreeIterable;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.ExpressionSynthesizer;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.RegionHelper;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.RuleAnalysis;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.RuleHeadAnalysis;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.TransformationAnalysis;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.UtilityAnalysis;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.trace.Element2MiddleProperty;
import org.eclipse.qvtd.compiler.internal.qvtc2qvtu.QVTuConfiguration;
import org.eclipse.qvtd.compiler.internal.qvtr2qvts.InvocationAnalysis;
import org.eclipse.qvtd.compiler.internal.qvtr2qvts.QVTrelationNameGenerator;
import org.eclipse.qvtd.compiler.internal.qvtr2qvts.QVTrelationScheduleManager;
import org.eclipse.qvtd.compiler.internal.qvtr2qvts.RelationalTransformationAnalysis;
import org.eclipse.qvtd.compiler.internal.qvtr2qvts.trace.DispatchClass2TraceProperty;
import org.eclipse.qvtd.compiler.internal.qvtr2qvts.trace.Relation2ResultProperty;
import org.eclipse.qvtd.compiler.internal.qvtr2qvts.trace.RelationAnalysis2DispatchClass;
import org.eclipse.qvtd.compiler.internal.qvtr2qvts.trace.RelationAnalysis2MiddleType;
import org.eclipse.qvtd.compiler.internal.qvtr2qvts.trace.RelationAnalysis2TraceClass;
import org.eclipse.qvtd.compiler.internal.qvtr2qvts.trace.RelationAnalysis2TraceGroup;
import org.eclipse.qvtd.compiler.internal.qvtr2qvts.trace.RelationalTransformationAnalysis2TracePackage;
import org.eclipse.qvtd.compiler.internal.qvtr2qvts.trace.VariableDeclaration2TraceProperty;
import org.eclipse.qvtd.pivot.qvtbase.Domain;
import org.eclipse.qvtd.pivot.qvtbase.Pattern;
import org.eclipse.qvtd.pivot.qvtbase.Predicate;
import org.eclipse.qvtd.pivot.qvtbase.Rule;
import org.eclipse.qvtd.pivot.qvtbase.TypedModel;
import org.eclipse.qvtd.pivot.qvtrelation.DomainPattern;
import org.eclipse.qvtd.pivot.qvtrelation.Key;
import org.eclipse.qvtd.pivot.qvtrelation.Relation;
import org.eclipse.qvtd.pivot.qvtrelation.RelationCallExp;
import org.eclipse.qvtd.pivot.qvtrelation.RelationDomain;
import org.eclipse.qvtd.pivot.qvtrelation.SharedVariable;
import org.eclipse.qvtd.pivot.qvtrelation.TemplateVariable;
import org.eclipse.qvtd.pivot.qvtrelation.utilities.QVTrelationUtil;
import org.eclipse.qvtd.pivot.qvtschedule.BooleanLiteralNode;
import org.eclipse.qvtd.pivot.qvtschedule.ClassDatum;
import org.eclipse.qvtd.pivot.qvtschedule.DispatchRegion;
import org.eclipse.qvtd.pivot.qvtschedule.KeyedValueNode;
import org.eclipse.qvtd.pivot.qvtschedule.MappingRegion;
import org.eclipse.qvtd.pivot.qvtschedule.NavigableEdge;
import org.eclipse.qvtd.pivot.qvtschedule.Node;
import org.eclipse.qvtd.pivot.qvtschedule.OperationCallNode;
import org.eclipse.qvtd.pivot.qvtschedule.PropertyDatum;
import org.eclipse.qvtd.pivot.qvtschedule.QVTscheduleFactory;
import org.eclipse.qvtd.pivot.qvtschedule.Region;
import org.eclipse.qvtd.pivot.qvtschedule.RuleRegion;
import org.eclipse.qvtd.pivot.qvtschedule.VariableNode;
import org.eclipse.qvtd.pivot.qvtschedule.VerdictRegion;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.DomainUsage;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.QVTscheduleUtil;
import org.eclipse.qvtd.pivot.qvttemplate.CollectionTemplateExp;
import org.eclipse.qvtd.pivot.qvttemplate.ObjectTemplateExp;
import org.eclipse.qvtd.pivot.qvttemplate.PropertyTemplateItem;
import org.eclipse.qvtd.pivot.qvttemplate.TemplateExp;

public class RelationAnalysis
extends RuleAnalysis {
    private final @Nullable Dispatch dispatch;
    private final @Nullable Verdict verdict;
    private @NonNull Map<@NonNull VariableDeclaration, @NonNull List<@NonNull OCLExpression>> variable2expressions = new HashMap<VariableDeclaration, List<OCLExpression>>();
    private @Nullable List<@NonNull InvocationAnalysis> incomingWhenInvocationAnalyses = null;
    private @Nullable List<@NonNull InvocationAnalysis> incomingWhereInvocationAnalyses = null;
    private @Nullable List<@NonNull InvocationAnalysis> outgoingWhenInvocationAnalyses = null;
    private @Nullable List<@NonNull InvocationAnalysis> outgoingWhereInvocationAnalyses = null;
    private @Nullable RelationAnalysis baseRelationAnalysis = null;
    private @Nullable Set<@NonNull VariableDeclaration> realizedOutputVariables = null;
    private @Nullable Set<@NonNull VariableDeclaration> keyedOutputVariables = null;
    private @Nullable Map<@NonNull TemplateVariable, @NonNull TemplateExp> variable2templateExp = null;
    private @Nullable Set<@NonNull VariableDeclaration> whenedOutputVariables = null;

    public RelationAnalysis(@NonNull TransformationAnalysis transformationAnalysis, @NonNull QVTuConfiguration qvtuConfiguration, @NonNull RuleRegion ruleRegion) {
        super(transformationAnalysis, ruleRegion);
        this.dispatch = this.createDispatch(qvtuConfiguration);
        this.verdict = this.createVerdict(qvtuConfiguration);
    }

    protected void addExpression(@NonNull VariableDeclaration variable, @NonNull OCLExpression expression) {
        List<@NonNull OCLExpression> initializers = this.variable2expressions.get(variable);
        if (initializers == null) {
            initializers = new ArrayList<OCLExpression>();
            this.variable2expressions.put(variable, initializers);
        }
        if (!initializers.contains(expression)) {
            initializers.add(expression);
        }
    }

    private void addIncomingInvocationAnalysis(@NonNull InvocationAnalysis invocationAnalysis) {
        boolean isWhen = invocationAnalysis.isWhen();
        if (isWhen) {
            List<@NonNull InvocationAnalysis> incomingWhenInvocationAnalyses2 = this.incomingWhenInvocationAnalyses;
            if (incomingWhenInvocationAnalyses2 == null) {
                this.incomingWhenInvocationAnalyses = incomingWhenInvocationAnalyses2 = new ArrayList<InvocationAnalysis>();
            }
            incomingWhenInvocationAnalyses2.add(invocationAnalysis);
        } else {
            List<@NonNull InvocationAnalysis> incomingWhereInvocationAnalyses2 = this.incomingWhereInvocationAnalyses;
            if (incomingWhereInvocationAnalyses2 == null) {
                this.incomingWhereInvocationAnalyses = incomingWhereInvocationAnalyses2 = new ArrayList<InvocationAnalysis>();
            }
            incomingWhereInvocationAnalyses2.add(invocationAnalysis);
        }
    }

    private void addOutgoingInvocationAnalysis(@NonNull InvocationAnalysis invocationAnalysis) {
        boolean isWhen = invocationAnalysis.isWhen();
        if (isWhen) {
            List<@NonNull InvocationAnalysis> outgoingWhenInvocationAnalyses2 = this.outgoingWhenInvocationAnalyses;
            if (outgoingWhenInvocationAnalyses2 == null) {
                this.outgoingWhenInvocationAnalyses = outgoingWhenInvocationAnalyses2 = new ArrayList<InvocationAnalysis>();
            }
            outgoingWhenInvocationAnalyses2.add(invocationAnalysis);
        } else {
            List<@NonNull InvocationAnalysis> outgoingWhereInvocationAnalyses2 = this.outgoingWhereInvocationAnalyses;
            if (outgoingWhereInvocationAnalyses2 == null) {
                this.outgoingWhereInvocationAnalyses = outgoingWhereInvocationAnalyses2 = new ArrayList<InvocationAnalysis>();
            }
            outgoingWhereInvocationAnalyses2.add(invocationAnalysis);
        }
    }

    protected void analyzeContainments() {
        for (Node node : ((RuleRegion)this.region).getNewNodes()) {
            boolean isContained = false;
            for (NavigableEdge edge : node.getNavigableEdges()) {
                Property property = edge.getProperty();
                Property opposite = property.getOpposite();
                if (opposite == null || !opposite.isIsComposite() || edge.getEdgeTarget().isNullLiteral()) continue;
                isContained = true;
                break;
            }
            if (!isContained) continue;
            node.setContained(true);
        }
    }

    protected @NonNull Set<@NonNull VariableDeclaration> analyzeKeyedOutputVariables(@NonNull RelationDomain relationDomain) {
        RelationalTransformationAnalysis transformationAnalysis2 = this.getTransformationAnalysis();
        Set<@NonNull VariableDeclaration> whenedOutputVariables = this.getWhenedOutputVariables();
        HashSet<@NonNull VariableDeclaration> keyedOutputVariables = new HashSet<VariableDeclaration>();
        for (DomainPattern domainPattern : QVTrelationUtil.getOwnedPatterns((RelationDomain)relationDomain)) {
            TemplateExp templateExpression = QVTrelationUtil.getOwnedTemplateExpression((DomainPattern)domainPattern);
            for (EObject eObject : new TreeIterable((EObject)templateExpression, true)) {
                Key key;
                TemplateExp templateExp;
                TemplateVariable templateVariable;
                if (!(eObject instanceof TemplateExp) || whenedOutputVariables.contains(templateVariable = (TemplateVariable)QVTrelationUtil.getBindsTo((TemplateExp)(templateExp = (TemplateExp)eObject))) || (key = transformationAnalysis2.getKeyForType(QVTrelationUtil.getType((TypedElement)templateVariable))) == null) continue;
                keyedOutputVariables.add((VariableDeclaration)templateVariable);
            }
        }
        return keyedOutputVariables;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Override
    public void analyzeMappingRegion() {
        @NonNull ArrayList preferredHeadNodes = Lists.newArrayList((Iterable)QVTscheduleUtil.getHeadNodes((Region)this.region));
        Iterable<@NonNull Node> headNodes = RuleHeadAnalysis.computeRuleHeadNodes(this.scheduleManager, (MappingRegion)this.region, preferredHeadNodes);
        @NonNull List headNodesList = QVTscheduleUtil.Internal.getHeadNodesList((Region)this.region);
        headNodesList.clear();
        Iterables.addAll((Collection)headNodesList, headNodes);
        UtilityAnalysis.assignUtilities(this.scheduleManager, (RuleRegion)this.region);
    }

    protected @NonNull Set<@NonNull VariableDeclaration> analyzeRealizedOutputVariables(@NonNull RelationDomain relationDomain) {
        HashSet<@NonNull VariableDeclaration> realizedOutputVariables = new HashSet<VariableDeclaration>();
        for (DomainPattern domainPattern : QVTrelationUtil.getOwnedPatterns((RelationDomain)relationDomain)) {
            TemplateExp templateExpression = QVTrelationUtil.getOwnedTemplateExpression((DomainPattern)domainPattern);
            for (EObject eObject : new TreeIterable((EObject)templateExpression, true)) {
                if (!(eObject instanceof TemplateExp)) continue;
                TemplateExp templateExp = (TemplateExp)eObject;
                TemplateVariable templateVariable = (TemplateVariable)QVTrelationUtil.getBindsTo((TemplateExp)templateExp);
                realizedOutputVariables.add((VariableDeclaration)templateVariable);
            }
        }
        return realizedOutputVariables;
    }

    @Override
    public void analyzeSourceModel() {
        Relation relation = this.getRule();
        this.baseRelationAnalysis = this.getScheduleManager().getRuleAnalysis((Rule)QVTrelationUtil.getBaseRelation((Relation)relation));
        this.variable2templateExp = this.analyzeVariable2TemplateExp();
        this.whenedOutputVariables = this.analyzeWhenedOutputVariables();
        for (RelationDomain relationDomain : QVTrelationUtil.getOwnedDomains((Relation)relation)) {
            DomainUsage domainUsage = this.scheduleManager.getDomainUsage((Element)relationDomain);
            if (!domainUsage.isOutput()) continue;
            assert (this.keyedOutputVariables == null);
            this.keyedOutputVariables = this.analyzeKeyedOutputVariables(relationDomain);
            assert (this.realizedOutputVariables == null);
            this.realizedOutputVariables = this.analyzeRealizedOutputVariables(relationDomain);
        }
    }

    protected @NonNull Map<@NonNull TemplateVariable, @NonNull TemplateExp> analyzeVariable2TemplateExp() {
        Relation relation = this.getRule();
        HashMap<@NonNull TemplateVariable, @NonNull TemplateExp> variable2templateExp = new HashMap<TemplateVariable, TemplateExp>();
        for (RelationDomain relationDomain : QVTrelationUtil.getOwnedDomains((Relation)relation)) {
            for (DomainPattern domainPattern : QVTrelationUtil.getOwnedPatterns((RelationDomain)relationDomain)) {
                for (EObject eObject : new TreeIterable((EObject)domainPattern, true)) {
                    if (!(eObject instanceof TemplateExp)) continue;
                    TemplateExp templateExp = (TemplateExp)eObject;
                    TemplateVariable templateVariable = (TemplateVariable)QVTrelationUtil.getBindsTo((TemplateExp)templateExp);
                    TemplateExp oldTemplateExp = variable2templateExp.put(templateVariable, templateExp);
                    assert (oldTemplateExp == null);
                }
            }
        }
        return variable2templateExp;
    }

    protected @NonNull Set<@NonNull VariableDeclaration> analyzeWhenedOutputVariables() {
        Relation relation = this.getRule();
        HashSet<@NonNull VariableDeclaration> whenedOutputVariables = new HashSet<VariableDeclaration>();
        Pattern whenPattern = relation.getWhen();
        if (whenPattern != null) {
            for (Predicate whenPredicate : QVTrelationUtil.getOwnedPredicates((Pattern)whenPattern)) {
                for (EObject eObject : new TreeIterable((EObject)QVTrelationUtil.getOwnedConditionExpression((Predicate)whenPredicate), true)) {
                    VariableExp variableExp;
                    EObject eContainer;
                    if (!(eObject instanceof VariableExp) || !((eContainer = (variableExp = (VariableExp)eObject).eContainer()) instanceof RelationCallExp)) continue;
                    RelationCallExp invocation = (RelationCallExp)eContainer;
                    int argumentIndex = invocation.getArgument().indexOf((Object)variableExp);
                    assert (argumentIndex >= 0);
                    RelationDomain domain = QVTrelationUtil.getRelationCallExpArgumentDomain((RelationCallExp)invocation, (int)argumentIndex);
                    DomainUsage domainUsage = this.scheduleManager.getDomainUsage((Element)domain);
                    if (!domainUsage.isOutput()) continue;
                    whenedOutputVariables.add((VariableDeclaration)QVTrelationUtil.getReferredVariable((VariableExp)variableExp));
                }
            }
        }
        return whenedOutputVariables;
    }

    public @Nullable Iterable<@NonNull InvocationAnalysis> basicGetIncomingWhenInvocationAnalyses() {
        return this.incomingWhenInvocationAnalyses;
    }

    public @Nullable Iterable<@NonNull InvocationAnalysis> basicGetIncomingWhereInvocationAnalyses() {
        return this.incomingWhereInvocationAnalyses;
    }

    public @Nullable Iterable<@NonNull InvocationAnalysis> basicGetOutgoingWhenInvocationAnalyses() {
        return this.outgoingWhenInvocationAnalyses;
    }

    public @Nullable Iterable<@NonNull InvocationAnalysis> basicGetOutgoingWhereInvocationAnalyses() {
        return this.outgoingWhereInvocationAnalyses;
    }

    protected @Nullable TemplateExp basicGetTemplateExp(@NonNull VariableDeclaration variable) {
        return (TemplateExp)((Map)ClassUtil.nonNullState(this.variable2templateExp)).get(variable);
    }

    protected @Nullable Dispatch createDispatch(@NonNull QVTuConfiguration qvtuConfiguration) {
        Relation relation = this.getRule();
        if (!QVTrelationUtil.hasOverrides((Relation)relation)) {
            return null;
        }
        if (QVTrelationUtil.getBaseRelation((Relation)relation) != relation) {
            return null;
        }
        DispatchRegion dispatchRegion = QVTscheduleFactory.eINSTANCE.createDispatchRegion();
        dispatchRegion.setOwningScheduleModel(this.scheduleManager.getScheduleModel());
        dispatchRegion.setReferredRule((Rule)relation);
        dispatchRegion.setReferredRuleRegion((RuleRegion)this.getRegion());
        dispatchRegion.setName(this.getNameGenerator().createMappingName(relation, "dispatch", qvtuConfiguration));
        return new Dispatch((RuleRegion)dispatchRegion);
    }

    public @NonNull InvocationAnalysis createInvocationAnalysis(@NonNull RelationAnalysis invokedRelationAnalysis, @NonNull RelationCallExp relationCallExp, boolean isWhen) {
        InvocationAnalysis invocationAnalysis = new InvocationAnalysis(this, invokedRelationAnalysis, relationCallExp, isWhen);
        this.addOutgoingInvocationAnalysis(invocationAnalysis);
        invokedRelationAnalysis.addIncomingInvocationAnalysis(invocationAnalysis);
        RelationAnalysis invokedBaseRelationAnalysis = invokedRelationAnalysis.getBaseRelationAnalysis();
        invokedBaseRelationAnalysis.addIncomingInvocationAnalysis(invocationAnalysis);
        return invocationAnalysis;
    }

    protected @Nullable Verdict createVerdict(@NonNull QVTuConfiguration qvtuConfiguration) {
        Relation relation = this.getRule();
        if (!QVTrelationUtil.hasOverrides((Relation)relation)) {
            return null;
        }
        if (QVTrelationUtil.getBaseRelation((Relation)relation) != relation) {
            return null;
        }
        VerdictRegion verdictRegion = QVTscheduleFactory.eINSTANCE.createVerdictRegion();
        verdictRegion.setOwningScheduleModel(this.scheduleManager.getScheduleModel());
        verdictRegion.setReferredRule((Rule)relation);
        verdictRegion.setReferredRuleRegion((RuleRegion)this.getRegion());
        verdictRegion.setName(this.getNameGenerator().createMappingName(relation, "verdict", qvtuConfiguration));
        return new Verdict((RuleRegion)verdictRegion);
    }

    @Override
    public void gatherRuleRegions(@NonNull List<@NonNull RuleRegion> ruleRegions) {
        if (!this.getRule().isIsAbstract()) {
            super.gatherRuleRegions(ruleRegions);
        }
        if (this.dispatch != null) {
            this.dispatch.gatherRuleRegions(ruleRegions);
        }
        if (this.verdict != null) {
            this.verdict.gatherRuleRegions(ruleRegions);
        }
    }

    public @NonNull RelationAnalysis getBaseRelationAnalysis() {
        return (RelationAnalysis)((Object)ClassUtil.nonNullState((Object)((Object)this.baseRelationAnalysis)));
    }

    protected @NonNull Set<@NonNull VariableDeclaration> getKeyedOutputVariables() {
        return (Set)ClassUtil.nonNullState(this.keyedOutputVariables);
    }

    @Override
    public @NonNull QVTrelationNameGenerator getNameGenerator() {
        return (QVTrelationNameGenerator)super.getNameGenerator();
    }

    protected @NonNull Set<@NonNull VariableDeclaration> getRealizedOutputVariables() {
        return (Set)ClassUtil.nonNullState(this.realizedOutputVariables);
    }

    @Override
    public @NonNull Node getReferenceNode(@NonNull VariableDeclaration variableDeclaration) {
        Node node = ((RuleRegion)this.region).getNode((TypedElement)variableDeclaration);
        if (node == null) {
            if (variableDeclaration instanceof SharedVariable) {
                node = this.getReferenceNodeForSharedVariable((SharedVariable)variableDeclaration, null);
            }
            if (node == null) {
                node = this.createOldNode(variableDeclaration);
            }
        }
        assert (node != null) : "No variable2simpleNode entry for " + variableDeclaration;
        assert (node == ((RuleRegion)this.region).getNode((TypedElement)variableDeclaration));
        return node;
    }

    private @Nullable Node getReferenceNodeForSharedVariable(@NonNull SharedVariable variable, @Nullable OCLExpression predicatedInit) {
        ClassDatum variableClassDatum;
        CompleteClass variableCompleteClass;
        CompleteClass initCompleteClass;
        String name;
        OCLExpression bestInitExpression = variable.getOwnedInit();
        if (bestInitExpression == null) {
            if (predicatedInit != null) {
                bestInitExpression = predicatedInit;
            } else {
                return null;
            }
        }
        if ("atlHelper".equals(name = variable.getName())) {
            ((Object)((Object)this)).getClass();
        }
        ExpressionSynthesizer expressionSynthesizer2 = this.expressionSynthesizer;
        if (variable.isIsRequired()) {
            expressionSynthesizer2 = this.expressionSynthesizer.getRequiredExpressionSynthesizer();
        }
        Node bestInitNode = (Node)bestInitExpression.accept((Visitor)expressionSynthesizer2);
        assert (bestInitNode != null);
        if (variable.isIsRequired()) {
            assert (bestInitNode.isRequired());
            assert (bestInitNode.isMatched());
        }
        if (!(initCompleteClass = bestInitNode.getCompleteClass()).conformsTo(variableCompleteClass = QVTscheduleUtil.getCompleteClass((ClassDatum)(variableClassDatum = this.scheduleManager.getClassDatum((TypedElement)variable))))) {
            VariableNode castNode = this.createOldNode((VariableDeclaration)variable);
            Property castProperty = this.scheduleManager.getCastProperty(PivotUtil.getType((TypedElement)variable));
            expressionSynthesizer2.createCastEdge(bestInitNode, castProperty, (Node)castNode);
            bestInitNode = castNode;
        }
        bestInitNode.setOriginatingVariable((VariableDeclaration)variable);
        ((RuleRegion)this.region).addVariableNode((VariableDeclaration)variable, bestInitNode);
        return bestInitNode;
    }

    public @NonNull Relation getRule() {
        return (Relation)super.getRule();
    }

    @Override
    public @NonNull RelationAnalysis2TraceGroup getRuleAnalysis2TraceGroup() {
        return (RelationAnalysis2TraceGroup)super.getRuleAnalysis2TraceGroup();
    }

    @Override
    public @NonNull QVTrelationScheduleManager getScheduleManager() {
        return (QVTrelationScheduleManager)this.scheduleManager;
    }

    public @NonNull TypedModel getTraceTypedModel() {
        return this.scheduleManager.getTraceTypedModel();
    }

    @Override
    public @NonNull RelationalTransformationAnalysis getTransformationAnalysis() {
        return (RelationalTransformationAnalysis)this.transformationAnalysis;
    }

    @Override
    public @NonNull RelationalTransformationAnalysis2TracePackage getTransformationAnalysis2TracePackage() {
        return (RelationalTransformationAnalysis2TracePackage)super.getTransformationAnalysis2TracePackage();
    }

    protected @NonNull Set<@NonNull VariableDeclaration> getWhenedOutputVariables() {
        return (Set)ClassUtil.nonNullState(this.whenedOutputVariables);
    }

    public boolean hasIncomingWhenInvocationAnalyses() {
        return this.getBaseRelationAnalysis().basicGetIncomingWhenInvocationAnalyses() != null;
    }

    public boolean hasIncomingWhereInvocationAnalyses() {
        return this.getBaseRelationAnalysis().basicGetIncomingWhereInvocationAnalyses() != null;
    }

    public boolean isKeyedRealization(@NonNull VariableDeclaration variableDeclaration) {
        return this.getKeyedOutputVariables().contains(variableDeclaration);
    }

    @Override
    public boolean isPropertyAssignment(@NonNull Node sourceNode, @NonNull Property source2targetProperty) {
        return false;
    }

    public void synthesizeCollectionTemplate(@NonNull CollectionTemplateExp collectionTemplateExp) {
        boolean isOutput = this.scheduleManager.getDomainUsage((Element)collectionTemplateExp).isOutput();
        if (isOutput) {
            this.synthesizeOutputCollectionTemplate(collectionTemplateExp);
        } else if (!this.synthesizeSingleInputCollectionTemplate(collectionTemplateExp)) {
            this.synthesizeMultipleInputCollectionTemplate(collectionTemplateExp);
        }
    }

    protected @NonNull Node synthesizeDispatchNode(@NonNull Node traceNode) {
        Relation relation = this.getRule();
        RelationAnalysis2DispatchClass relationAnalysis2dispatchClass = this.getBaseRelationAnalysis().getRuleAnalysis2TraceGroup().getRuleAnalysis2DispatchClass();
        ClassDatum classDatum = this.scheduleManager.getClassDatum(this.getTraceTypedModel(), relationAnalysis2dispatchClass.getMiddleClass());
        Node dispatchNode = this.createPredicatedNode("dispatcher", classDatum, true);
        dispatchNode.setUtility(Node.Utility.DISPATCH);
        Property doProperty = relationAnalysis2dispatchClass.getDispatchClass2TraceProperty(relation).getTraceProperty();
        this.createNavigationEdge(dispatchNode, doProperty, traceNode, false);
        Property resultProperty = relationAnalysis2dispatchClass.getResultProperty();
        this.createRealizedNavigationEdge(dispatchNode, resultProperty, traceNode, false);
        Property globalSuccessProperty = relationAnalysis2dispatchClass.getGlobalSuccessProperty();
        this.createRealizedSuccess(dispatchNode, globalSuccessProperty, true);
        Node headNode = traceNode.isPredicated() ? traceNode : dispatchNode;
        ((RuleRegion)this.region).getHeadNodes().clear();
        ((RuleRegion)this.region).getHeadNodes().add((Object)headNode);
        headNode.setHead();
        return dispatchNode;
    }

    protected boolean synthesizeEqualsPredicate(@NonNull OCLExpression predicateExpression) {
        OCLExpression valueExp;
        Variable variable;
        if (!(predicateExpression instanceof OperationCallExp)) {
            return false;
        }
        OperationCallExp operationCallExp = (OperationCallExp)predicateExpression;
        Operation operation = QVTrelationUtil.getReferredOperation((CallExp)operationCallExp);
        OperationId oclAnyEqualsId = this.scheduleManager.getStandardLibraryHelper().getOclAnyEqualsId();
        if (!PivotUtil.isSameOperation((OperationId)operation.getOperationId(), (OperationId)oclAnyEqualsId)) {
            return false;
        }
        OCLExpression leftExpression = QVTrelationUtil.getOwnedSource((CallExp)operationCallExp);
        OCLExpression rightExpression = QVTrelationUtil.getOwnedArgument((OperationCallExp)operationCallExp, (int)0);
        if (leftExpression instanceof VariableExp) {
            variable = QVTrelationUtil.getReferredVariable((VariableExp)((VariableExp)leftExpression));
            valueExp = rightExpression;
        } else if (rightExpression instanceof VariableExp) {
            variable = QVTrelationUtil.getReferredVariable((VariableExp)((VariableExp)rightExpression));
            valueExp = leftExpression;
        } else {
            return false;
        }
        Node variableNode = ((RuleRegion)this.region).getNode((TypedElement)variable);
        if (variableNode == null) {
            if (variable instanceof SharedVariable) {
                variableNode = this.getReferenceNodeForSharedVariable((SharedVariable)variable, valueExp);
            }
            if (variableNode != null) {
                return true;
            }
        }
        variableNode = (Node)variable.accept((Visitor)this.expressionSynthesizer);
        Node expressionNode = (Node)valueExp.accept((Visitor)this.expressionSynthesizer);
        assert (variableNode != null && expressionNode != null);
        this.createEqualsEdge(expressionNode, variableNode);
        return true;
    }

    protected void synthesizeIncomingNonTopInvocation(@NonNull Node traceNode) {
        Relation relation = this.getRule();
        if (!relation.isIsTopLevel()) {
            if (QVTrelationUtil.hasOverrides((Relation)relation)) {
                Relation baseRelation = QVTrelationUtil.getBaseRelation((Relation)relation);
                RelationAnalysis baseRelationAnalysis = this.getBaseRelationAnalysis();
                RelationAnalysis2TraceGroup baseRelationAnalysis2traceGroup = baseRelationAnalysis.getRuleAnalysis2TraceGroup();
                RelationAnalysis2MiddleType baseRelationAnalysis2invocationInterface = baseRelationAnalysis2traceGroup.getRuleAnalysis2InvocationInterface();
                Class baseInvocationClass = baseRelationAnalysis2invocationInterface.getMiddleClass();
                ClassDatum classDatum = this.scheduleManager.getClassDatum(this.scheduleManager.getTraceTypedModel(), baseInvocationClass);
                Node invocationNode = this.createPredicatedNode("dispatcher", classDatum, true);
                invocationNode.setUtility(Node.Utility.DISPATCH);
                ((RuleRegion)this.region).getHeadNodes().add((Object)invocationNode);
                invocationNode.setHead();
                Relation2ResultProperty relation2resultProperty = baseRelationAnalysis2invocationInterface.basicGetRelation2ResultProperty();
                if (relation2resultProperty != null) {
                    Property resultProperty = relation2resultProperty.getTraceProperty();
                    this.createRealizedNavigationEdge(invocationNode, resultProperty, traceNode, false);
                }
                for (VariableDeclaration rootVariable : QVTrelationUtil.getRootVariables((Relation)relation)) {
                    Node rootNode = ((RuleRegion)this.region).getNode((TypedElement)rootVariable);
                    assert (rootNode != null);
                    Variable baseRootVariable = QVTrelationUtil.getOverriddenVariable((Relation)baseRelation, (VariableDeclaration)rootVariable);
                    Property traceProperty = baseRelationAnalysis2invocationInterface.getTraceProperty((VariableDeclaration)baseRootVariable);
                    this.createNavigationEdge(invocationNode, traceProperty, rootNode, false);
                }
            } else {
                ((RuleRegion)this.region).getHeadNodes().add((Object)traceNode);
            }
        }
    }

    protected void synthesizeInterfaceAssignments(@NonNull RelationAnalysis2TraceGroup relationAnalysis2traceGroup, @NonNull Node traceNode) {
    }

    public OCLExpression synthesizeKeyTemplate(@NonNull VariableDeclaration templateVariable, @NonNull Map<@NonNull Property, @NonNull Node> property2node) {
        Node keyNode = ((RuleRegion)this.region).getNode((TypedElement)templateVariable);
        assert (keyNode != null);
        ClassDatum classDatum = ((KeyedValueNode)keyNode).getClassDatumValue();
        assert (classDatum != null);
        for (Property property : property2node.keySet()) {
            Node node = property2node.get(property);
            assert (node != null);
            PropertyDatum propertyDatum = this.scheduleManager.getPropertyDatum(classDatum, property);
            this.createKeyPartEdge(node, propertyDatum, keyNode);
        }
        return null;
    }

    public @NonNull Node synthesizeKeyTemplatePart(@NonNull PropertyTemplateItem propertyTemplateItem) {
        OCLExpression targetExpression = QVTrelationUtil.getOwnedValue((PropertyTemplateItem)propertyTemplateItem);
        Node partNode = (Node)targetExpression.accept((Visitor)this.expressionSynthesizer);
        assert (partNode != null);
        return partNode;
    }

    protected void synthesizeMultipleInputCollectionTemplate(@NonNull CollectionTemplateExp collectionTemplateExp) {
        Node residueNode = (Node)collectionTemplateExp.accept((Visitor)this.expressionSynthesizer);
        assert (residueNode != null);
        Operation collectionExcludingOperation = this.scheduleManager.getStandardLibraryHelper().getCollectionExcludingOperation();
        Node memberNode = null;
        for (OCLExpression member : QVTrelationUtil.getOwnedMembers((CollectionTemplateExp)collectionTemplateExp)) {
            if (memberNode != null) {
                Node selfNode = residueNode;
                assert (selfNode != null);
                residueNode = this.createOperationCallNode(RelationAnalysis.isUnconditional((TypedElement)member), null, collectionExcludingOperation, (TypedElement)collectionTemplateExp, residueNode, memberNode);
                this.createOperationSelfEdge(selfNode, QVTrelationUtil.getType((TypedElement)collectionExcludingOperation), residueNode);
                this.createOperationParameterEdge(memberNode, QVTrelationUtil.getOwnedParameter((Operation)collectionExcludingOperation, (int)0), -1, residueNode);
            }
            memberNode = (Node)member.accept((Visitor)this.expressionSynthesizer);
            assert (memberNode != null);
            this.createPredicateEdge(residueNode, "\u00abincludes\u00bb", memberNode);
        }
        Variable rest = collectionTemplateExp.getRest();
        if (rest != null && !rest.isIsImplicit()) {
            if (memberNode != null) {
                Node selfNode = residueNode;
                assert (selfNode != null);
                residueNode = this.createOperationCallNode(RelationAnalysis.isUnconditional((TypedElement)rest), null, collectionExcludingOperation, (TypedElement)collectionTemplateExp, residueNode, memberNode);
                this.createOperationSelfEdge(selfNode, QVTrelationUtil.getType((TypedElement)collectionExcludingOperation), residueNode);
                this.createOperationParameterEdge(memberNode, QVTrelationUtil.getOwnedParameter((Operation)collectionExcludingOperation, (int)0), -1, residueNode);
            }
            Node restNode = (Node)rest.accept((Visitor)this.expressionSynthesizer);
            assert (restNode != null);
            this.createEqualsEdge(residueNode, restNode);
        }
        if (rest == null) {
            Operation collectionIsEmptyOperation = this.scheduleManager.getStandardLibraryHelper().getCollectionIsEmptyOperation();
            OperationCallNode isEmptyNode = this.createOperationCallNode(RelationAnalysis.isUnconditional((TypedElement)collectionTemplateExp), null, collectionIsEmptyOperation, (TypedElement)collectionTemplateExp, residueNode);
            this.createPredicatedStepNode((Node)isEmptyNode, false);
        }
    }

    public @NonNull OCLExpression synthesizeObjectTemplatePart(@NonNull PropertyTemplateItem propertyTemplateItem) {
        ObjectTemplateExp sourceObjectTemplateExp = QVTrelationUtil.getOwningObjectTemplateExp((PropertyTemplateItem)propertyTemplateItem);
        Variable sourceVariable = QVTrelationUtil.getBindsTo((TemplateExp)sourceObjectTemplateExp);
        Node sourceNode = ((RuleRegion)this.region).getNode((TypedElement)sourceVariable);
        assert (sourceNode != null);
        Property source2targetProperty = QVTrelationUtil.getReferredProperty((PropertyTemplateItem)propertyTemplateItem);
        OCLExpression targetExpression = QVTrelationUtil.getOwnedValue((PropertyTemplateItem)propertyTemplateItem);
        if (targetExpression instanceof CollectionTemplateExp) {
            Variable targetVariable = QVTrelationUtil.getBindsTo((TemplateExp)((CollectionTemplateExp)targetExpression));
            Node targetNode = ((RuleRegion)this.region).getNode((TypedElement)targetVariable);
            if (targetNode != null) {
                if (this.scheduleManager.getDomainUsage((Element)sourceVariable).isOutput()) {
                    this.createRealizedNavigationEdge(sourceNode, source2targetProperty, targetNode, null);
                } else {
                    this.createNavigationEdge(sourceNode, source2targetProperty, targetNode, null);
                }
            }
        } else {
            Node targetNode = this.expressionSynthesizer.synthesize((Visitable)targetExpression);
            if (this.scheduleManager.getDomainUsage((Element)sourceVariable).isOutput()) {
                this.createRealizedNavigationEdge(sourceNode, source2targetProperty, targetNode, null);
            } else {
                this.createNavigationEdge(sourceNode, source2targetProperty, targetNode, null);
            }
        }
        return targetExpression;
    }

    protected void synthesizeOutgoingWhenInvocations(@NonNull Node traceNode) {
        List<@NonNull InvocationAnalysis> outgoingWhenInvocationAnalyses2 = this.outgoingWhenInvocationAnalyses;
        if (outgoingWhenInvocationAnalyses2 != null) {
            for (InvocationAnalysis invocationAnalysis : outgoingWhenInvocationAnalyses2) {
                invocationAnalysis.synthesizeInvocationNodes(traceNode);
            }
        }
    }

    protected void synthesizeOutgoingWhereInvocations(@NonNull Node traceNode) {
        List<@NonNull InvocationAnalysis> outgoingWhereInvocationAnalyses2 = this.outgoingWhereInvocationAnalyses;
        if (outgoingWhereInvocationAnalyses2 != null) {
            for (InvocationAnalysis invocationAnalysis : outgoingWhereInvocationAnalyses2) {
                invocationAnalysis.synthesizeInvocationNodes(traceNode);
            }
        }
    }

    protected void synthesizeOutputCollectionTemplate(@NonNull CollectionTemplateExp collectionTemplateExp) {
        EObject eContainer = collectionTemplateExp.eContainer();
        if (eContainer instanceof PropertyTemplateItem) {
            PropertyTemplateItem propertyTemplateItem = (PropertyTemplateItem)eContainer;
            Property source2target = QVTrelationUtil.getReferredProperty((PropertyTemplateItem)propertyTemplateItem);
            ObjectTemplateExp objectTemplateExp = QVTrelationUtil.getOwningObjectTemplateExp((PropertyTemplateItem)propertyTemplateItem);
            Node sourceNode = (Node)objectTemplateExp.accept((Visitor)this.expressionSynthesizer);
            assert (sourceNode != null);
            for (OCLExpression member : QVTrelationUtil.getOwnedMembers((CollectionTemplateExp)collectionTemplateExp)) {
                Node memberNode = (Node)member.accept((Visitor)this.expressionSynthesizer);
                assert (memberNode != null);
                this.createRealizedNavigationEdge(sourceNode, source2target, memberNode, true);
            }
        } else {
            Node collectionNode = (Node)collectionTemplateExp.accept((Visitor)this.expressionSynthesizer);
            assert (collectionNode != null);
            for (OCLExpression member : QVTrelationUtil.getOwnedMembers((CollectionTemplateExp)collectionTemplateExp)) {
                Node memberNode = (Node)member.accept((Visitor)this.expressionSynthesizer);
                assert (memberNode != null);
                this.createRealizedIncludesEdge(collectionNode, memberNode);
            }
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    protected void synthesizeOverridingGuards(Node traceNode) {
        Relation relation = this.getRule();
        QVTrelationScheduleManager scheduleManager2 = this.getScheduleManager();
        TypedModel traceTypedModel = scheduleManager2.getTraceTypedModel();
        @NonNull Iterable overridingRelations = QVTrelationUtil.getOverrides((Relation)relation);
        if (!Iterables.isEmpty((Iterable)overridingRelations)) {
            for (Relation overridingRelation : overridingRelations) {
                RelationAnalysis overridingRelationAnalysis = scheduleManager2.getRuleAnalysis((Rule)overridingRelation);
                RelationAnalysis overriddenRelationAnalysis = overridingRelationAnalysis.getBaseRelationAnalysis();
                boolean isWhere = overriddenRelationAnalysis.hasIncomingWhereInvocationAnalyses();
                RelationAnalysis2TraceGroup overridingRelationAnalysis2TraceGroup = overridingRelationAnalysis.getRuleAnalysis2TraceGroup();
                RelationAnalysis2MiddleType overridingRelationAnalysis2TraceInterface = overridingRelationAnalysis2TraceGroup.getRuleAnalysis2TraceInterface();
                RelationAnalysis2TraceClass overridingRelationAnalysis2TraceClass = overridingRelationAnalysis2TraceGroup.getRuleAnalysis2TraceClass();
                ClassDatum overridingClassDatum = scheduleManager2.getClassDatum(traceTypedModel, overridingRelationAnalysis2TraceInterface.getMiddleClass());
                Node guardNode = this.createPredicatedNode("not_" + overridingRelation.getName(), overridingClassDatum, true);
                Property globalSuccessProperty = overridingRelationAnalysis2TraceClass.getGlobalSuccessProperty();
                this.createPredicatedSuccess(guardNode, globalSuccessProperty, false);
                for (VariableDeclaration rootVariable : QVTrelationUtil.getRootVariables((Relation)relation)) {
                    if (!isWhere && !scheduleManager2.getDomainUsage((Element)rootVariable).isInput()) continue;
                    Node rootVariableNode = this.getReferenceNode(rootVariable);
                    Variable overridingRootVariable = QVTrelationUtil.getOverriddenVariable((Relation)overridingRelation, (VariableDeclaration)rootVariable);
                    Property invocationProperty = overridingRelationAnalysis2TraceInterface.getTraceProperty((VariableDeclaration)overridingRootVariable);
                    this.createNavigationEdge(guardNode, invocationProperty, rootVariableNode, null);
                }
            }
        }
    }

    protected void synthesizePredicate(@NonNull OCLExpression predicateExpression) {
        if (this.synthesizeEqualsPredicate(predicateExpression)) {
            return;
        }
        Node resultNode = (Node)predicateExpression.accept((Visitor)this.expressionSynthesizer);
        if (resultNode != null) {
            BooleanLiteralNode trueNode = this.createBooleanLiteralNode(true);
            this.createPredicateEdge(resultNode, null, (Node)trueNode);
        }
    }

    protected boolean synthesizeSingleInputCollectionTemplate(@NonNull CollectionTemplateExp collectionTemplateExp) {
        Variable rest = collectionTemplateExp.getRest();
        if (rest == null || !rest.isIsImplicit()) {
            return false;
        }
        EList members = collectionTemplateExp.getMember();
        if (members.size() > 1) {
            return false;
        }
        EObject eContainer = collectionTemplateExp.eContainer();
        if (!(eContainer instanceof PropertyTemplateItem)) {
            return false;
        }
        PropertyTemplateItem propertyTemplateItem = (PropertyTemplateItem)eContainer;
        Property source2target = QVTrelationUtil.getReferredProperty((PropertyTemplateItem)propertyTemplateItem);
        ObjectTemplateExp objectTemplateExp = QVTrelationUtil.getOwningObjectTemplateExp((PropertyTemplateItem)propertyTemplateItem);
        Node sourceNode = (Node)objectTemplateExp.accept((Visitor)this.expressionSynthesizer);
        assert (sourceNode != null);
        Node memberNode = (Node)((OCLExpression)members.get(0)).accept((Visitor)this.expressionSynthesizer);
        assert (memberNode != null);
        this.createNavigationEdge(sourceNode, source2target, memberNode, true);
        return true;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    protected void synthesizeTraceEdges(@NonNull Node traceNode, @Nullable Node dispatchNode) {
        Relation relation = this.getRule();
        if (dispatchNode != null) {
            RelationAnalysis2DispatchClass ruleAnalysis2dispatchClass = this.getBaseRelationAnalysis().getRuleAnalysis2TraceGroup().getRuleAnalysis2DispatchClass();
            Relation baseRelation = this.getBaseRelationAnalysis().getRule();
            for (RelationDomain relationDomain : QVTrelationUtil.getOwnedDomains((Relation)relation)) {
                Boolean isInput = this.getScheduleManager().isInput((Domain)relationDomain) || !relation.isIsTopLevel();
                for (VariableDeclaration rootVariable : QVTrelationUtil.getRootVariables((RelationDomain)relationDomain)) {
                    Variable baseRootVariable = QVTrelationUtil.getOverriddenVariable((Relation)baseRelation, (VariableDeclaration)rootVariable);
                    VariableDeclaration2TraceProperty overriddenVariableDeclaration2traceProperty = ruleAnalysis2dispatchClass.getVariableDeclaration2TraceProperty((VariableDeclaration)baseRootVariable);
                    Property traceProperty = overriddenVariableDeclaration2traceProperty.getTraceProperty();
                    Node targetNode = ((RuleRegion)this.region).getNode((TypedElement)rootVariable);
                    assert (targetNode != null);
                    if (isInput.booleanValue()) {
                        this.createNavigationEdge(dispatchNode, traceProperty, targetNode, null);
                        continue;
                    }
                    this.createRealizedNavigationEdge(dispatchNode, traceProperty, targetNode, null);
                }
            }
            boolean hasPredicatedTrace = traceNode.isPredicated();
            assert (hasPredicatedTrace);
            @NonNull List rootVariables = QVTrelationUtil.getRootVariables((Relation)relation);
            RelationAnalysis2TraceClass ruleAnalysis2traceClass = this.getRuleAnalysis2TraceGroup().getRuleAnalysis2TraceClass();
            for (VariableDeclaration2TraceProperty variableDeclaration2traceProperty : ruleAnalysis2traceClass.getVariableDeclaration2TraceProperties()) {
                Property traceProperty = variableDeclaration2traceProperty.getTraceProperty();
                VariableDeclaration tracedVariable = variableDeclaration2traceProperty.getOverridingVariable();
                Node targetNode = ((RuleRegion)this.region).getNode((TypedElement)tracedVariable);
                assert (targetNode != null);
                if (rootVariables.contains(tracedVariable)) continue;
                this.createRealizedNavigationEdge(traceNode, traceProperty, targetNode, null);
            }
        } else {
            boolean hasPredicatedTrace = traceNode.isPredicated();
            @NonNull List rootVariables = QVTrelationUtil.getRootVariables((Relation)relation);
            RelationAnalysis2TraceClass ruleAnalysis2traceClass = this.getRuleAnalysis2TraceGroup().getRuleAnalysis2TraceClass();
            for (VariableDeclaration2TraceProperty variableDeclaration2traceProperty : ruleAnalysis2traceClass.getVariableDeclaration2TraceProperties()) {
                Property traceProperty = variableDeclaration2traceProperty.getTraceProperty();
                VariableDeclaration tracedVariable = variableDeclaration2traceProperty.getOverridingVariable();
                Node targetNode = ((RuleRegion)this.region).getNode((TypedElement)tracedVariable);
                assert (targetNode != null);
                if (hasPredicatedTrace && rootVariables.contains(tracedVariable)) {
                    this.createNavigationEdge(traceNode, traceProperty, targetNode, null);
                    continue;
                }
                this.createRealizedNavigationEdge(traceNode, traceProperty, targetNode, null);
            }
        }
    }

    public void synthesizeTraceElements(@NonNull RelationAnalysis2TraceGroup relationAnalysis2traceGroup) {
        Relation relation;
        if (this.dispatch != null) {
            this.dispatch.synthesizeElements();
        }
        if (this.verdict != null) {
            this.verdict.synthesizeElements();
        }
        if (!(relation = this.getRule()).isIsAbstract()) {
            RelationAnalysis2TraceClass ruleAnalysis2traceClass = relationAnalysis2traceGroup.getRuleAnalysis2TraceClass();
            Variable traceVariable = QVTrelationUtil.getTraceVariable((Relation)relation);
            traceVariable.setType((Type)ruleAnalysis2traceClass.getMiddleClass());
            Node traceNode = this.synthesizeTraceNode();
            Node dispatchNode = QVTrelationUtil.hasOverrides((Relation)relation) ? this.synthesizeDispatchNode(traceNode) : null;
            this.synthesizeTraceEdges(traceNode, dispatchNode);
            this.synthesizeOutgoingWhenInvocations(traceNode);
            this.synthesizeOutgoingWhereInvocations(traceNode);
            this.synthesizeOverridingGuards(traceNode);
            this.synthesizeTraceGlobalSuccessAssignment(relationAnalysis2traceGroup, traceNode);
            this.synthesizeInterfaceAssignments(relationAnalysis2traceGroup, traceNode);
        }
    }

    protected void synthesizeTraceGlobalSuccessAssignment(@NonNull RelationAnalysis2TraceGroup relationAnalysis2traceGroup, @NonNull Node traceNode) {
        RelationAnalysis2TraceClass relationAnalysis2TraceClass = relationAnalysis2traceGroup.getRuleAnalysis2TraceClass();
        Element2MiddleProperty relation2globalSuccessProperty = relationAnalysis2TraceClass.basicGetRelation2GlobalSuccessProperty();
        if (relation2globalSuccessProperty != null) {
            this.createRealizedSuccess(traceNode, relation2globalSuccessProperty.getTraceProperty(), null);
        }
    }

    protected @NonNull Node synthesizeTraceNode() {
        VariableNode traceNode;
        Relation relation = this.getRule();
        Variable traceVariable = QVTrelationUtil.getTraceVariable((Relation)relation);
        boolean hasOverrides = QVTrelationUtil.hasOverrides((Relation)relation);
        if (hasOverrides) {
            traceNode = this.createOldNode((VariableDeclaration)traceVariable);
        } else if (!relation.isIsTopLevel()) {
            traceNode = this.createOldNode((VariableDeclaration)traceVariable);
            ((RuleRegion)this.region).getHeadNodes().clear();
            ((RuleRegion)this.region).getHeadNodes().add((Object)traceNode);
            traceNode.setHead();
        } else {
            boolean hasPredicatedTrace = this.incomingWhereInvocationAnalyses != null && !hasOverrides;
            VariableNode variableNode = traceNode = hasPredicatedTrace ? this.createOldNode((VariableDeclaration)traceVariable) : this.createRealizedStepNode((VariableDeclaration)traceVariable);
            if (!this.getRule().isIsTopLevel()) {
                ((RuleRegion)this.region).getHeadNodes().clear();
            }
        }
        traceNode.setUtility(Node.Utility.TRACE);
        return traceNode;
    }

    public void synthesizeVariableDeclaration(@NonNull VariableDeclaration variableDeclaration) {
        TemplateExp templateExp = this.basicGetTemplateExp(variableDeclaration);
        if (variableDeclaration instanceof Variable && ((Variable)variableDeclaration).isIsImplicit() && templateExp == null) {
            return;
        }
        if (QVTrelationUtil.isTraceClassVariable((VariableDeclaration)variableDeclaration)) {
            return;
        }
        if (this.getKeyedOutputVariables().contains(variableDeclaration)) {
            boolean isUnconditional = true;
            this.createKeyedNode(isUnconditional, QVTrelationUtil.getName((NamedElement)variableDeclaration), variableDeclaration);
            return;
        }
        if (this.getWhenedOutputVariables().contains(variableDeclaration)) {
            this.createOldNode(variableDeclaration);
        } else if (this.hasIncomingWhereInvocationAnalyses() && Iterables.contains((Iterable)QVTrelationUtil.getRootVariables((Relation)this.getRule()), (Object)variableDeclaration)) {
            this.createOldNode(variableDeclaration);
        } else if (this.getRealizedOutputVariables().contains(variableDeclaration)) {
            this.createRealizedStepNode(variableDeclaration);
        } else if (variableDeclaration instanceof TemplateVariable) {
            assert (templateExp != null);
            if (templateExp instanceof CollectionTemplateExp) {
                return;
            }
            this.createOldNode(variableDeclaration);
        } else if (variableDeclaration instanceof SharedVariable) {
            SharedVariable sharedVariable = (SharedVariable)variableDeclaration;
            sharedVariable.getOwnedInit();
        } else {
            this.createOldNode(variableDeclaration);
        }
    }

    protected class Dispatch
    extends RegionHelper<RuleRegion> {
        public Dispatch(RuleRegion ruleRegion) {
            super(RelationAnalysis.this.getScheduleManager(), ruleRegion);
        }

        public void gatherRuleRegions(@NonNull List<@NonNull RuleRegion> ruleRegions) {
            ruleRegions.add((RuleRegion)this.region);
        }

        protected void synthesizeDispatchHierarchy(@NonNull Node traceNode, @NonNull RelationAnalysis2DispatchClass relationAnalysis2dispatchClass, @NonNull Relation relation) {
            if (!relation.isIsAbstract()) {
                QVTrelationScheduleManager scheduleManager = (QVTrelationScheduleManager)this.getScheduleManager();
                RelationAnalysis2TraceClass relationAnalysis2TraceClass = scheduleManager.getRuleAnalysis((Rule)relation).getRuleAnalysis2TraceGroup().getRuleAnalysis2TraceClass();
                ClassDatum dispatchedClassDatum = scheduleManager.getClassDatum(RelationAnalysis.this.getTraceTypedModel(), relationAnalysis2TraceClass.getMiddleClass());
                VariableNode dispatchedNode = this.createRealizedNode(Dispatch.getName((Nameable)relation), dispatchedClassDatum, true);
                DispatchClass2TraceProperty dispatchClass2traceProperty = relationAnalysis2dispatchClass.getDispatchClass2TraceProperty(relation);
                this.createRealizedNavigationEdge(traceNode, dispatchClass2traceProperty.getTraceProperty(), (Node)dispatchedNode, false);
            }
            for (Relation overridingRelation : QVTrelationUtil.getOverrides((Relation)relation)) {
                this.synthesizeDispatchHierarchy(traceNode, relationAnalysis2dispatchClass, overridingRelation);
            }
        }

        public void synthesizeElements() {
            RelationAnalysis2DispatchClass relationAnalysis2dispatchClass = RelationAnalysis.this.getRuleAnalysis2TraceGroup().getRuleAnalysis2DispatchClass();
            Node traceNode = this.synthesizeTraceNode(relationAnalysis2dispatchClass);
            this.synthesizeTraceEdges(traceNode);
            this.synthesizeDispatchHierarchy(traceNode, relationAnalysis2dispatchClass, RelationAnalysis.this.getRule());
            UtilityAnalysis.assignUtilities(this.scheduleManager, (RuleRegion)this.region);
        }

        protected void synthesizeTraceEdges(@NonNull Node traceNode) {
            Relation relation = RelationAnalysis.this.getRule();
            boolean isTopLevel = relation.isIsTopLevel();
            RelationAnalysis2TraceGroup ruleAnalysis2TraceGroup = RelationAnalysis.this.getRuleAnalysis2TraceGroup();
            RelationAnalysis2DispatchClass ruleAnalysis2dispatchClass = ruleAnalysis2TraceGroup.getRuleAnalysis2DispatchClass();
            for (RelationDomain relationDomain : QVTrelationUtil.getOwnedDomains((Relation)relation)) {
                if (!this.scheduleManager.isInput((Domain)relationDomain)) continue;
                for (VariableDeclaration variable : QVTrelationUtil.getRootVariables((RelationDomain)relationDomain)) {
                    VariableDeclaration2TraceProperty variableDeclaration2traceClassProperty = ruleAnalysis2dispatchClass.getVariableDeclaration2TraceProperty(variable);
                    Property traceClassProperty = variableDeclaration2traceClassProperty.getTraceProperty();
                    VariableNode targetNode = this.createOldNode(variable);
                    this.createNavigationEdge(traceNode, traceClassProperty, (Node)targetNode, null);
                    if (!isTopLevel) continue;
                    ((RuleRegion)this.region).getHeadNodes().add((Object)targetNode);
                    targetNode.setHead();
                }
            }
        }

        protected @NonNull Node synthesizeTraceNode(@NonNull RelationAnalysis2DispatchClass relationAnalysis2dispatchClass) {
            Relation relation = RelationAnalysis.this.getRule();
            TypedModel traceTypedModel = RelationAnalysis.this.getTraceTypedModel();
            ClassDatum dispatchedClassDatum = this.scheduleManager.getClassDatum(traceTypedModel, relationAnalysis2dispatchClass.getMiddleClass());
            if (relation.isIsTopLevel()) {
                VariableNode realizedDispatchNode = this.createRealizedNode("dispatcher", dispatchedClassDatum, true);
                realizedDispatchNode.setUtility(Node.Utility.TRACE);
                return realizedDispatchNode;
            }
            Node predicatedDispatchNode = this.createPredicatedNode("dispatcher", dispatchedClassDatum, true);
            predicatedDispatchNode.setUtility(Node.Utility.TRACE);
            ((RuleRegion)this.region).getHeadNodes().add((Object)predicatedDispatchNode);
            predicatedDispatchNode.setHead();
            return predicatedDispatchNode;
        }
    }

    protected class Verdict
    extends RegionHelper<RuleRegion> {
        public Verdict(RuleRegion ruleRegion) {
            super(RelationAnalysis.this.getScheduleManager(), ruleRegion);
        }

        public void gatherRuleRegions(@NonNull List<@NonNull RuleRegion> ruleRegions) {
            ruleRegions.add((RuleRegion)this.getRegion());
        }

        protected void synthesizeDispatchHierarchy(@NonNull Node traceNode, @NonNull RelationAnalysis2DispatchClass relationAnalysis2dispatchClass, @NonNull Relation relation) {
            if (relation.isIsAbstract()) {
                for (Relation overridingRelation : QVTrelationUtil.getOverrides((Relation)relation)) {
                    this.synthesizeDispatchHierarchy(traceNode, relationAnalysis2dispatchClass, overridingRelation);
                }
            } else {
                QVTrelationScheduleManager scheduleManager = (QVTrelationScheduleManager)this.getScheduleManager();
                RelationAnalysis2TraceClass relationAnalysis2TraceClass = scheduleManager.getRuleAnalysis((Rule)relation).getRuleAnalysis2TraceGroup().getRuleAnalysis2TraceClass();
                RelationAnalysis2MiddleType relationAnalysis2TraceInterface = RelationAnalysis.this.getBaseRelationAnalysis().getRuleAnalysis2TraceGroup().getRuleAnalysis2TraceInterface();
                ClassDatum dispatchedClassDatum = scheduleManager.getClassDatum(RelationAnalysis.this.getTraceTypedModel(), relationAnalysis2TraceClass.getMiddleClass());
                Node dispatchedNode = this.createPredicatedNode(Verdict.getName((Nameable)relation), dispatchedClassDatum, true);
                DispatchClass2TraceProperty dispatchClass2traceProperty = relationAnalysis2dispatchClass.getDispatchClass2TraceProperty(relation);
                this.createNavigationEdge(traceNode, dispatchClass2traceProperty.getTraceProperty(), dispatchedNode, false);
                Property successProperty = relationAnalysis2TraceInterface.getGlobalSuccessProperty();
                this.createPredicatedSuccess(dispatchedNode, successProperty, false);
            }
        }

        public void synthesizeElements() {
            RelationAnalysis2DispatchClass relationAnalysis2dispatchClass = RelationAnalysis.this.getRuleAnalysis2TraceGroup().getRuleAnalysis2DispatchClass();
            Node traceNode = this.synthesizeTraceNode(relationAnalysis2dispatchClass);
            this.synthesizeDispatchHierarchy(traceNode, relationAnalysis2dispatchClass, RelationAnalysis.this.getRule());
            UtilityAnalysis.assignUtilities(this.scheduleManager, (RuleRegion)this.region);
        }

        protected @NonNull Node synthesizeTraceNode(@NonNull RelationAnalysis2DispatchClass relationAnalysis2dispatchClass) {
            Relation relation = RelationAnalysis.this.getRule();
            QVTrelationScheduleManager scheduleManager = (QVTrelationScheduleManager)this.getScheduleManager();
            TypedModel traceTypedModel = scheduleManager.getTraceTypedModel();
            ClassDatum dispatchedClassDatum = scheduleManager.getClassDatum(traceTypedModel, relationAnalysis2dispatchClass.getMiddleClass());
            Node traceNode = this.createPredicatedNode(Verdict.getName((Nameable)relation), dispatchedClassDatum, true);
            ((RuleRegion)this.region).getHeadNodes().add((Object)traceNode);
            traceNode.setHead();
            Property successProperty = relationAnalysis2dispatchClass.getGlobalSuccessProperty();
            this.createRealizedSuccess(traceNode, successProperty, false);
            return traceNode;
        }
    }
}

