/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.internal.etfw.feedback.perfsuite.xml;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.ptp.internal.etfw.feedback.perfsuite.util.PS_Debug;
import org.xml.sax.Attributes;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

class PS_MetricDefinitionParser
extends DefaultHandler {
    private StringBuilder res;
    private Map<String, List<String>> metricDefinitionMap;
    private Map<String, Map<String, String>> metricDescriptionMap;
    private String language;
    private boolean needsResourceFileGeneration = false;
    private String tmpValue = "";
    private String eventName;
    private List<String> expressionList;
    private Map<String, Properties> messageMap;
    private static final String LANGATT = "lang";
    private static final String DEFAULT_LANG = "en_US";
    private String RESOURCE_FILE_PREFIX;

    PS_MetricDefinitionParser(String filename) throws FileNotFoundException {
        this.init(filename);
    }

    PS_MetricDefinitionParser(String filename, boolean needsResGen) throws FileNotFoundException {
        this.needsResourceFileGeneration = needsResGen;
        this.init(filename);
    }

    void init(String filename) throws FileNotFoundException {
        this.metricDefinitionMap = new LinkedHashMap<String, List<String>>();
        this.metricDescriptionMap = new LinkedHashMap<String, Map<String, String>>();
        this.messageMap = new TreeMap<String, Properties>();
        this.RESOURCE_FILE_PREFIX = this.strip(filename);
        XMLReader xr = this.getXMLReader();
        xr.setContentHandler(this);
        FileReader r = new FileReader(filename);
        try {
            xr.parse(new InputSource(r));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (SAXException e) {
            throw new RuntimeException(e);
        }
    }

    private String strip(String filename) {
        int lastSeparatorIndex = filename.lastIndexOf(File.separator);
        int firstDotIndex = filename.indexOf(".", lastSeparatorIndex);
        if (-1 == firstDotIndex) {
            return filename.substring(lastSeparatorIndex + 1);
        }
        return filename.substring(lastSeparatorIndex + 1, firstDotIndex);
    }

    Map<String, List<String>> getDefinitionMap() {
        return this.metricDefinitionMap;
    }

    Map<String, Map<String, String>> getMetricDescriptionMap() {
        return this.metricDescriptionMap;
    }

    public String toString() {
        StringBuilder resultString = new StringBuilder();
        resultString.append("Expressions:\n");
        resultString.append(this.getExpressionString());
        resultString.append("\nDescriptions:\n");
        for (Map.Entry<String, Map<String, String>> entry : this.metricDescriptionMap.entrySet()) {
            resultString.append(entry.getKey() + ": " + entry.getValue() + "\n");
        }
        return resultString.toString();
    }

    private String getExpressionString() {
        StringBuilder resultString = new StringBuilder();
        for (Map.Entry<String, List<String>> entry : this.metricDefinitionMap.entrySet()) {
            resultString.append(entry.getKey());
            resultString.append(":");
            List<String> expressionL = entry.getValue();
            for (String tmps : expressionL) {
                resultString.append(" ").append(tmps);
            }
            resultString.append("\n");
        }
        return resultString.toString();
    }

    String getResourceFileBaseName() {
        return this.RESOURCE_FILE_PREFIX;
    }

    private void generatePropertiesFiles() {
        String filename = null;
        try {
            for (Map.Entry<String, Properties> entry : this.messageMap.entrySet()) {
                Properties properties = entry.getValue();
                filename = String.valueOf(this.RESOURCE_FILE_PREFIX) + "_" + entry.getKey() + ".properties";
                properties.store(new FileOutputStream(filename), null);
            }
            filename = String.valueOf(this.RESOURCE_FILE_PREFIX) + ".properties";
            this.messageMap.get(DEFAULT_LANG).store(new FileOutputStream(filename), null);
        }
        catch (IOException e) {
            System.err.println("error in writing properties to file \"" + filename + "\", error message: " + e.getMessage());
            throw new RuntimeException(e);
        }
    }

    private XMLReader getXMLReader() {
        XMLReader xr;
        SAXParserFactory spf = SAXParserFactory.newInstance();
        spf.setNamespaceAware(true);
        try {
            SAXParser saxParser = spf.newSAXParser();
            xr = saxParser.getXMLReader();
        }
        catch (SAXException e) {
            throw new RuntimeException(e);
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
        xr.setErrorHandler(new MyErrorHandler(System.err));
        return xr;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) {
        if (qName.equals("metric")) {
            this.expressionList = new ArrayList<String>();
        } else if (qName.equals("description")) {
            this.language = attributes.getValue(LANGATT);
            if (this.language == null) {
                this.language = DEFAULT_LANG;
            }
        }
        this.tmpValue = "";
    }

    @Override
    public void endElement(String uri, String localName, String qName) {
        this.tmpValue = this.tmpValue.trim();
        if (qName.equals("name")) {
            this.eventName = new String(this.tmpValue);
        } else if (qName.equals("ci") || qName.equals("cn")) {
            this.expressionList.add(this.tmpValue);
        } else if (qName.equals("plus")) {
            this.expressionList.add("+");
        } else if (qName.equals("minus")) {
            this.expressionList.add("-");
        } else if (qName.equals("times")) {
            this.expressionList.add("*");
        } else if (qName.equals("divide")) {
            this.expressionList.add("/");
        } else if (qName.equals("abs")) {
            this.expressionList.add("||");
        } else if (qName.equals("metric")) {
            if (this.metricDefinitionMap.put(this.eventName, this.expressionList) != null) {
                PS_Debug.print(2, "Two metric definitions with the same name '" + this.eventName + "' appeared.");
            }
        } else if (qName.equals("description")) {
            Map<String, String> map = this.metricDescriptionMap.get(this.eventName);
            if (map == null) {
                map = new TreeMap<String, String>();
            }
            map.put(this.language, this.tmpValue);
            this.metricDescriptionMap.put(this.eventName, map);
            Properties properties = this.messageMap.get(this.language);
            if (properties == null) {
                properties = new Properties();
            }
            properties.setProperty(this.eventName, this.tmpValue);
            this.messageMap.put(this.language, properties);
        } else if (qName.equals("psmetrics") && this.needsResourceFileGeneration) {
            this.generatePropertiesFiles();
        }
        this.tmpValue = "";
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        String tmpString = new String(ch, start, length);
        if (tmpString.length() != 0) {
            this.tmpValue = this.tmpValue.length() == 0 ? tmpString : this.tmpValue.concat(tmpString);
        }
    }

    private static class MyErrorHandler
    implements ErrorHandler {
        private PrintStream out;

        MyErrorHandler(PrintStream out) {
            this.out = out;
        }

        private String getParseExceptionInfo(SAXParseException spe) {
            String systemId = spe.getSystemId();
            if (systemId == null) {
                systemId = "null";
            }
            String info = "Public ID: " + spe.getPublicId() + ", System ID: " + spe.getSystemId() + ", Line number: " + spe.getLineNumber() + ", Column number: " + spe.getColumnNumber() + ", Message: " + spe.getMessage();
            return info;
        }

        @Override
        public void warning(SAXParseException spe) throws SAXException {
            String message = "Warning: " + this.getParseExceptionInfo(spe);
            throw new SAXException(message);
        }

        @Override
        public void error(SAXParseException spe) throws SAXException {
            String message = "Error: " + this.getParseExceptionInfo(spe);
            throw new SAXException(message);
        }

        @Override
        public void fatalError(SAXParseException spe) throws SAXException {
            String message = "Fatal Error: " + this.getParseExceptionInfo(spe);
            throw new SAXException(message);
        }
    }
}

