/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.phpunit.ui.wizards;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.internal.core.ModelManager;
import org.eclipse.jface.dialogs.DialogSettings;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.formatter.IContentFormatter;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.php.internal.ui.PHPUiPlugin;
import org.eclipse.php.internal.ui.util.ExceptionHandler;
import org.eclipse.php.internal.ui.wizards.PHPFileCreationWizard;
import org.eclipse.php.phpunit.PHPUnitMessages;
import org.eclipse.php.phpunit.PHPUnitPlugin;
import org.eclipse.php.phpunit.model.PHPUnitSearchEngine;
import org.eclipse.php.phpunit.ui.wizards.PHPUnitWizardPage;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyDelegatingOperation;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;

public abstract class PHPUnitWizard
extends PHPFileCreationWizard {
    protected static final String DIALOG_SETTINGS_KEY = "PHPUnitWizards";
    private IStructuredSelection fSelection;
    private IWorkbench fWorkbench;
    protected PHPUnitWizardPage page;

    public PHPUnitWizard() {
        this.initDialogSettings();
    }

    protected boolean finishPage(IRunnableWithProgress runnable) {
        WorkspaceModifyDelegatingOperation op = new WorkspaceModifyDelegatingOperation(runnable);
        try {
            PlatformUI.getWorkbench().getProgressService().runInUI((IRunnableContext)this.getContainer(), (IRunnableWithProgress)op, (ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
        }
        catch (InvocationTargetException e) {
            Shell shell = this.getShell();
            String title = PHPUnitMessages.PHPUnitWizard_Title;
            String message = PHPUnitMessages.PHPUnitWizard_Error;
            ExceptionHandler.handle((InvocationTargetException)e, (Shell)shell, (String)title, (String)message);
            return false;
        }
        catch (InterruptedException e) {
            return false;
        }
        return true;
    }

    abstract String generateFile();

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.fWorkbench = workbench;
        this.fSelection = selection;
    }

    protected void initDialogSettings() {
        IDialogSettings pluginSettings = PHPUnitPlugin.getDefault().getDialogSettings();
        IDialogSettings wizardSettings = pluginSettings.getSection(DIALOG_SETTINGS_KEY);
        if (wizardSettings == null) {
            wizardSettings = new DialogSettings(DIALOG_SETTINGS_KEY);
            pluginSettings.addSection(wizardSettings);
        }
        this.setDialogSettings(wizardSettings);
    }

    public boolean performFinish() {
        IRunnableWithProgress op = monitor -> {
            IProject project = this.page.getTestContainer().getProject();
            IScriptProject scriptProject = DLTKCore.create((IProject)project);
            PHPUnitSearchEngine fSearchEngine = new PHPUnitSearchEngine(scriptProject);
            if (!fSearchEngine.hasTestCaseClass()) {
                ModelManager.getModelManager().getIndexManager().waitUntilReady();
            }
            Display.getDefault().syncExec(() -> this.page.superClassChanged());
            String generatedFile = this.generateFile();
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            IFile file = root.getFile(this.page.getTestContainer().getFullPath().append(this.page.getFileName()));
            try {
                try {
                    new PHPFileCreationWizard.FileCreator(){

                        protected void normalizeFile(IFile file) {
                            super.normalizeFile(file);
                            IContentFormatter formatter = PHPUiPlugin.getDefault().getActiveFormatter();
                            try {
                                IStructuredModel structuredModel = null;
                                structuredModel = StructuredModelManager.getModelManager().getModelForEdit(file);
                                if (structuredModel == null) {
                                    return;
                                }
                                try {
                                    IStructuredDocument structuredDocument = structuredModel.getStructuredDocument();
                                    Region region = new Region(0, structuredDocument.getLength());
                                    formatter.format((IDocument)structuredDocument, (IRegion)region);
                                    structuredModel.save();
                                }
                                finally {
                                    if (structuredModel != null) {
                                        structuredModel.releaseFromEdit();
                                    }
                                }
                            }
                            catch (IOException e) {
                                PHPUnitPlugin.log(e);
                            }
                            catch (CoreException e) {
                                PHPUnitPlugin.log(e);
                            }
                        }
                    }.createFile((Wizard)this, file, monitor, generatedFile);
                }
                catch (CoreException e) {
                    throw new InvocationTargetException(e);
                }
            }
            finally {
                monitor.done();
            }
        };
        try {
            this.getContainer().run(true, false, op);
        }
        catch (InterruptedException e) {
            return false;
        }
        catch (InvocationTargetException e) {
            Throwable realException = e.getTargetException();
            MessageDialog.openError((Shell)this.getShell(), (String)PHPUnitMessages.PHPUnitWizard_Error_Title, (String)realException.getMessage());
            return false;
        }
        return true;
    }

    protected void selectAndReveal(IResource newResource) {
        BasicNewResourceWizard.selectAndReveal((IResource)newResource, (IWorkbenchWindow)this.fWorkbench.getActiveWorkbenchWindow());
    }

    public IStructuredSelection getSelection() {
        return this.fSelection;
    }
}

