/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core;

import com.ibm.icu.text.MessageFormat;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.php.internal.core.util.SyncObject;
import org.eclipse.php.internal.debug.core.Logger;
import org.eclipse.php.internal.debug.core.PHPDebugCoreMessages;
import org.eclipse.php.internal.debug.core.PHPDebugPlugin;
import org.eclipse.php.internal.debug.core.debugger.DebuggerSettingsKind;
import org.eclipse.php.internal.debug.core.debugger.DebuggerSettingsManager;
import org.eclipse.php.internal.debug.core.debugger.IDebuggerSettings;
import org.eclipse.php.internal.debug.core.zend.debugger.ZendDebuggerSettingsUtil;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;

public final class PHPDebugUtil {
    private PHPDebugUtil() {
    }

    public static void openLaunchURL(String launchURL) throws DebugException {
        PHPDebugUtil.openLaunchURL(launchURL, true);
    }

    public static void openLaunchURL(final String launchURL, boolean doSyncExec) throws DebugException {
        if (PlatformUI.getWorkbench().getDisplay().isDisposed()) {
            try {
                URL url = new URL(launchURL);
                URLConnection con = url.openConnection();
                con.setConnectTimeout(5000);
                con.setReadTimeout(5000);
                InputStream is = con.getInputStream();
                BufferedReader reader = new BufferedReader(new InputStreamReader(is));
                while (reader.readLine() != null) {
                }
                reader.close();
            }
            catch (Throwable t) {
                Logger.logException(MessageFormat.format((String)"Error initializing the connection for debug/launch URL: {0}", (Object[])new Object[]{launchURL}), t);
                String errorMessage = PHPDebugCoreMessages.Debugger_Unexpected_Error_1;
                throw new DebugException((IStatus)new Status(4, PHPDebugPlugin.getID(), 150, errorMessage, t));
            }
            return;
        }
        final SyncObject e = doSyncExec ? new SyncObject() : null;
        Runnable r = new Runnable(){

            @Override
            public void run() {
                block4: {
                    try {
                        URL urlToOpen = new URL(launchURL);
                        StringBuilder browserTitle = new StringBuilder(urlToOpen.getProtocol()).append("://").append(urlToOpen.getHost());
                        if (urlToOpen.getPort() != -1) {
                            browserTitle.append(':').append(urlToOpen.getPort());
                        }
                        browserTitle.append(urlToOpen.getPath());
                        IWorkbenchBrowserSupport browserSupport = PlatformUI.getWorkbench().getBrowserSupport();
                        IWebBrowser browser = browserSupport.createBrowser(14, "PHP Debugger Browser", browserTitle.toString(), browserTitle.toString());
                        if (PHPDebugPlugin.DEBUG) {
                            System.out.println("Opening debug/launch URL in a Web Browser: " + urlToOpen.toString());
                        }
                        browser.openURL(urlToOpen);
                    }
                    catch (Throwable t) {
                        Logger.logException(MessageFormat.format((String)"Error initializing the Web Browser for debug/launch URL: {0}", (Object[])new Object[]{launchURL}), t);
                        String errorMessage = PHPDebugCoreMessages.Debugger_Unexpected_Error_1;
                        if (e == null) break block4;
                        e.set((Object)new DebugException((IStatus)new Status(4, PHPDebugPlugin.getID(), 150, errorMessage, t)));
                    }
                }
            }
        };
        if (doSyncExec) {
            PlatformUI.getWorkbench().getDisplay().syncExec(r);
            DebugException ex = (DebugException)((Object)e.get());
            if (ex != null) {
                throw ex;
            }
        } else {
            PlatformUI.getWorkbench().getDisplay().asyncExec(r);
        }
    }

    public static Set<Integer> getDebugPorts(String debuggerId) {
        HashSet<Integer> ports;
        block7: {
            block6: {
                ports = new HashSet<Integer>();
                if (!debuggerId.equals("org.eclipse.php.debug.core.zendDebugger")) break block6;
                Integer defaultPort = PHPDebugPlugin.getDebugPort(debuggerId);
                ports.add(defaultPort);
                List<IDebuggerSettings> allSettings = DebuggerSettingsManager.INSTANCE.findSettings(debuggerId);
                for (IDebuggerSettings settings : allSettings) {
                    String clientPort = settings.getAttribute("clientPort");
                    try {
                        Integer dedicatedPort = Integer.valueOf(clientPort);
                        ports.add(dedicatedPort);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                break block7;
            }
            if (!debuggerId.equals("org.eclipse.php.debug.core.xdebugDebugger")) break block7;
            Integer defaultPort = PHPDebugPlugin.getDebugPort(debuggerId);
            ports.add(defaultPort);
            for (IDebuggerSettings settings : DebuggerSettingsManager.INSTANCE.findSettings(debuggerId)) {
                String clientPort = settings.getAttribute("clientPort");
                try {
                    Integer dedicatedPort = Integer.valueOf(clientPort);
                    ports.add(dedicatedPort);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return ports;
    }

    public static String getZendAllHosts() {
        LinkedHashSet<String> merged = new LinkedHashSet<String>();
        String defaultHosts = PHPDebugPlugin.getDebugHosts();
        String[] stringArray = PHPDebugUtil.getZendHostsArray(defaultHosts);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String host = stringArray[n2];
            merged.add(host);
            ++n2;
        }
        List<IDebuggerSettings> allSettings = DebuggerSettingsManager.INSTANCE.findSettings("org.eclipse.php.debug.core.zendDebugger");
        for (IDebuggerSettings settings : allSettings) {
            if (settings.getKind() != DebuggerSettingsKind.PHP_SERVER) continue;
            String settingsHosts = ZendDebuggerSettingsUtil.getDebugHosts(settings.getOwnerId());
            String[] stringArray2 = PHPDebugUtil.getZendHostsArray(settingsHosts);
            int n3 = stringArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                String host = stringArray2[n4];
                merged.add(host);
                ++n4;
            }
        }
        String[] mergedArray = merged.toArray(new String[merged.size()]);
        return PHPDebugUtil.getZendHostsString(mergedArray);
    }

    public static String[] getZendHostsArray(String hostsString) {
        if (hostsString.isEmpty()) {
            return new String[0];
        }
        String[] hosts = hostsString.split(",");
        int i = 0;
        while (i < hosts.length) {
            hosts[i] = hosts[i].trim();
            ++i;
        }
        return hosts;
    }

    public static String getZendHostsString(String[] hostsArray) {
        if (hostsArray.length == 1) {
            return hostsArray[0];
        }
        if (hostsArray.length > 1) {
            StringBuilder StringBuilder2 = new StringBuilder();
            StringBuilder2.append(hostsArray[0]);
            int i = 1;
            while (i < hostsArray.length) {
                StringBuilder2.append(", " + hostsArray[i]);
                ++i;
            }
            return StringBuilder2.toString();
        }
        return "";
    }

    public static boolean isSystem5() {
        String system = System.getProperty("os.name").toLowerCase();
        return "os400".equals(system) || "aix".equals(system);
    }
}

