/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.core.compiler.ast.nodes;

import java.util.List;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.expressions.Expression;
import org.eclipse.dltk.utils.CorePrinter;
import org.eclipse.php.internal.core.compiler.ast.visitor.ASTPrintVisitor;

public class Quote
extends Expression {
    public static final int QT_QUOTE = 0;
    public static final int QT_SINGLE = 1;
    public static final int QT_HEREDOC = 2;
    public static final int QT_NOWDOC = 3;
    private final List<? extends Expression> expressions;
    private final int quoteType;

    public Quote(int start, int end, List<? extends Expression> expressions, int type) {
        super(start, end);
        this.expressions = expressions;
        this.quoteType = type;
    }

    public static String getType(int type) {
        switch (type) {
            case 0: {
                return "quote";
            }
            case 1: {
                return "single";
            }
            case 2: {
                return "heredoc";
            }
            case 3: {
                return "nowdoc";
            }
        }
        throw new IllegalArgumentException();
    }

    public void traverse(ASTVisitor visitor) throws Exception {
        boolean visit = visitor.visit((Expression)this);
        if (visit) {
            for (Expression expression : this.expressions) {
                expression.traverse(visitor);
            }
        }
        visitor.endvisit((Expression)this);
    }

    public int getKind() {
        return 47;
    }

    public List<? extends Expression> getExpressions() {
        return this.expressions;
    }

    public int getQuoteType() {
        return this.quoteType;
    }

    public final void printNode(CorePrinter output) {
    }

    public String toString() {
        return ASTPrintVisitor.toXMLString((ASTNode)this);
    }
}

