/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.stereotype.migration;

import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.uml.diagram.common.stereotype.display.helper.StereotypeDisplayUtil;
import org.eclipse.papyrus.uml.diagram.common.stereotype.migration.StereotypeMigrationHelper;
import org.eclipse.papyrus.uml.diagram.common.util.CommandUtil;

public abstract class StereotypeEAnnotationMigration {
    protected StereotypeMigrationHelper migrationHelper = StereotypeMigrationHelper.getInstance();
    protected StereotypeDisplayUtil helper = StereotypeDisplayUtil.getInstance();
    protected View hostView = null;
    protected EAnnotation eAnnotation = null;

    public StereotypeEAnnotationMigration(View view) {
        this.hostView = view;
    }

    public void activate() {
        if (this.hostView != null) {
            this.eAnnotation = this.migrationHelper.getStereotypeEAnnotation((EModelElement)this.hostView);
            if (this.eAnnotation != null && !this.eAnnotation.getDetails().isEmpty()) {
                this.migrateStereotype();
            }
        }
    }

    protected void migrateStereotype() {
        if (this.eAnnotation != null) {
            if (this.hasEAnnotationDetails(this.hostView)) {
                ICommand command = this.getStereotypeMigrationCommand(this.hostView);
                CommandUtil.executeUnsafeCommand(command, (Object)this.hostView);
            }
            this.cleanEAnnotationDetails(this.hostView);
        }
    }

    public abstract void cleanEAnnotationDetails(View var1);

    public abstract boolean hasEAnnotationDetails(View var1);

    public abstract ICommand getStereotypeMigrationCommand(View var1);
}

