/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.widgets.toolbox.notification.builders;

import java.util.HashSet;
import org.eclipse.papyrus.infra.widgets.toolbox.notification.IBuilder;
import org.eclipse.papyrus.infra.widgets.toolbox.notification.ICompositeCreator;
import org.eclipse.papyrus.infra.widgets.toolbox.notification.INotification;
import org.eclipse.papyrus.infra.widgets.toolbox.notification.builders.PropertyWrapper;
import org.eclipse.papyrus.infra.widgets.toolbox.notification.dialogs.AsyncNotification;
import org.eclipse.papyrus.infra.widgets.toolbox.notification.dialogs.ImagePapyrusAsyncNotificationPopup;
import org.eclipse.papyrus.infra.widgets.toolbox.notification.utils.PapyrusControlsFactory;
import org.eclipse.papyrus.infra.widgets.toolbox.notification.view.AbstractInsideComposite;
import org.eclipse.papyrus.infra.widgets.toolbox.notification.view.PapyrusNotificationView;
import org.eclipse.papyrus.infra.widgets.toolbox.notification.view.ViewNotification;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class CombinedPopupAndViewBuilder
implements IBuilder {
    @Override
    public INotification build(PropertyWrapper wrapper, FormToolkit toolkit) {
        PapyrusNotificationView notificationView = (PapyrusNotificationView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView("org.eclipse.papyrus.infra.widgets.toolbox.notification.view.PapyrusNotificationView");
        if (notificationView == null) {
            try {
                notificationView = (PapyrusNotificationView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.eclipse.papyrus.infra.widgets.toolbox.notification.view.PapyrusNotificationView", null, 3);
            }
            catch (PartInitException e) {
                return null;
            }
        }
        if (notificationView != null && !PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().isPartVisible((IWorkbenchPart)notificationView)) {
            this.createNotificationPopup(wrapper, toolkit);
            return this.createNotificationLog(notificationView, wrapper, toolkit);
        }
        return null;
    }

    @Override
    public boolean accept(String parameterName, Object value) {
        return true;
    }

    private INotification createNotificationPopup(PropertyWrapper wrapper, FormToolkit toolkit) {
        ImagePapyrusAsyncNotificationPopup popup = new ImagePapyrusAsyncNotificationPopup(Display.getDefault(), toolkit, wrapper.getType());
        popup.setTitle(wrapper.getTitle());
        popup.setText(wrapper.getMessage());
        popup.addAllRunnable(wrapper.getActions() == null ? new HashSet() : wrapper.getActions());
        AsyncNotification notification = new AsyncNotification(popup);
        popup.setINotification(notification);
        popup.open();
        return notification;
    }

    private INotification createNotificationLog(PapyrusNotificationView notificationView, final PropertyWrapper wrapper, FormToolkit toolkit) {
        ICompositeCreator compositeCreator = wrapper.getComposite();
        if (compositeCreator == null) {
            compositeCreator = new ICompositeCreator(){

                @Override
                public Composite createComposite(Composite parent, FormToolkit toolkit) {
                    return PapyrusControlsFactory.createCompositeWithType(Display.getDefault().getActiveShell(), toolkit, parent, wrapper.getType(), wrapper.getImage(), wrapper.getMessage(), false);
                }
            };
        }
        AbstractInsideComposite compositeNotification = notificationView.setComposite(compositeCreator, wrapper.getTitle(), wrapper.getActions());
        ViewNotification notification = new ViewNotification(compositeNotification);
        compositeNotification.setINotification(notification);
        return notification;
    }
}

