/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.query.refined;

import java.net.URL;
import java.text.Format;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.collect.ArrayInt;
import org.eclipse.mat.query.Column;
import org.eclipse.mat.query.ContextDerivedData;
import org.eclipse.mat.query.ContextProvider;
import org.eclipse.mat.query.IContextObject;
import org.eclipse.mat.query.IDecorator;
import org.eclipse.mat.query.IIconProvider;
import org.eclipse.mat.query.IQueryContext;
import org.eclipse.mat.query.ISelectionProvider;
import org.eclipse.mat.query.IStructuredResult;
import org.eclipse.mat.query.ResultMetaData;
import org.eclipse.mat.query.refined.Filter;
import org.eclipse.mat.query.refined.TotalsCalculator;
import org.eclipse.mat.query.refined.TotalsRow;
import org.eclipse.mat.report.internal.Messages;
import org.eclipse.mat.util.IProgressListener;
import org.eclipse.mat.util.SilentProgressListener;
import org.eclipse.mat.util.SimpleMonitor;
import org.eclipse.mat.util.VoidProgressListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RefinedStructuredResult
implements IStructuredResult,
ISelectionProvider,
IIconProvider,
Filter.FilterChangeListener {
    protected IStructuredResult subject;
    protected ResultMetaData metaData;
    protected IQueryContext context;
    protected ISelectionProvider selectionProvider;
    protected IIconProvider iconProvider;
    protected TotalsCalculator totalsCalculator;
    protected List<Column> columns = new ArrayList<Column>();
    protected List<ValueAccessor> accessors = new ArrayList<ValueAccessor>();
    protected List<Filter> filters = new ArrayList<Filter>();
    protected List<IDecorator> decorators = new ArrayList<IDecorator>();
    private boolean resultIsSorted = false;
    private int sortColumn = -1;
    private Column.SortDirection sortDirection;
    private Comparator<Object> comparator;
    protected boolean inlineJobs = false;
    protected List<DerivedDataJobDefinition> jobs = new ArrayList<DerivedDataJobDefinition>();

    RefinedStructuredResult() {
    }

    protected void init() {
    }

    void addColumn(Column column, ValueAccessor accessor) {
        this.columns.add(column);
        this.filters.add(Filter.Factory.build(column, this));
        this.accessors.add(accessor);
        this.decorators.add(column.getDecorator());
    }

    public void setSelectionProvider(ISelectionProvider provider) {
        this.selectionProvider = provider != null ? provider : ISelectionProvider.EMPTY;
    }

    public boolean isDecorated(int columnIndex) {
        return this.decorators.get(columnIndex) != null;
    }

    public Filter[] getFilter() {
        return this.filters.toArray(new Filter[0]);
    }

    public boolean hasActiveFilter() {
        for (Filter f : this.filters) {
            if (!f.isActive()) continue;
            return true;
        }
        return false;
    }

    public int getFilteredCount(List<?> elements) {
        return elements instanceof FilteredList ? ((FilteredList)elements).getFilteredCount() : 0;
    }

    @Override
    public void filterChanged(Filter filter) {
    }

    public int getSortColumn() {
        return this.sortColumn;
    }

    public Column.SortDirection getSortDirection() {
        return this.sortDirection;
    }

    void internalSetSortOrder(int columnIndex, Column.SortDirection direction, boolean isPreSorted, Comparator<Object> cmp) {
        this.sortColumn = columnIndex;
        this.sortDirection = direction;
        this.resultIsSorted = isPreSorted;
        if (cmp == null) {
            cmp = this.buildComparator(columnIndex, direction);
        }
        this.comparator = cmp;
    }

    Comparator<Object> buildComparator(int columnIndex, Column.SortDirection direction) {
        Comparator<Object> cmp = this.columns.get(columnIndex).getComparator();
        if (cmp == null) {
            cmp = new NaturalComparator(this, columnIndex);
        }
        if (direction == Column.SortDirection.DESC) {
            cmp = Collections.reverseOrder(cmp);
        }
        return cmp;
    }

    public void setSortOrder(Column queryColumn, Column.SortDirection direction) {
        this.internalSetSortOrder(this.columns.indexOf(queryColumn), direction, false, null);
    }

    public void sort(List<?> elements) {
        if (this.comparator != null) {
            Collections.sort(elements, this.comparator);
        }
    }

    public TotalsRow buildTotalsRow(List<?> elements) {
        TotalsRow row = new TotalsRow();
        row.setNumberOfItems(elements.size());
        row.setFilteredItems(this.getFilteredCount(elements));
        return row;
    }

    public void calculateTotals(List<?> elements, TotalsRow totals, IProgressListener listener) {
        totals.setTotals(this.totalsCalculator.calculate(this.subject, elements, listener));
    }

    public List<DerivedDataJobDefinition> getJobs() {
        return this.jobs;
    }

    public synchronized Column addDerivedDataColumn(ContextProvider provider, ContextDerivedData.DerivedColumn derivedColumn) {
        CalculatedColumnAccessor accessor = this.getAccessorFor(provider, derivedColumn);
        if (accessor != null) {
            return accessor.column;
        }
        ContextDerivedData derivedData = this.context.getContextDerivedData();
        Column column = derivedData.columnFor(derivedColumn, this.subject, provider);
        ContextDerivedData.DerivedCalculator calculator = (ContextDerivedData.DerivedCalculator)column.getData(ContextDerivedData.DerivedCalculator.class);
        this.addColumn(column, new CalculatedColumnAccessor(column, provider, derivedColumn, calculator));
        this.totalsCalculator = TotalsCalculator.create(this);
        return column;
    }

    public Column getColumnFor(ContextProvider provider, ContextDerivedData.DerivedColumn derivedColumn) {
        CalculatedColumnAccessor a = this.getAccessorFor(provider, derivedColumn);
        return a != null ? a.column : null;
    }

    private CalculatedColumnAccessor getAccessorFor(ContextProvider provider, ContextDerivedData.DerivedColumn derivedColumn) {
        for (ValueAccessor a : this.accessors) {
            if (!(a instanceof CalculatedColumnAccessor)) continue;
            CalculatedColumnAccessor rsa = (CalculatedColumnAccessor)a;
            if (!rsa.derivedColumn.equals(derivedColumn)) continue;
            if (provider.getLabel() == null && rsa.provider.getLabel() == null) {
                return rsa;
            }
            if (provider.getLabel() == null || !provider.getLabel().equals(rsa.provider.getLabel())) continue;
            return rsa;
        }
        return null;
    }

    public void calculate(ContextProvider provider, ContextDerivedData.DerivedOperation operation, List<?> elements, ICalculationProgress progress, IProgressListener listener) throws SnapshotException {
        SimpleMonitor sm;
        IProgressListener l2;
        IProgressListener l1;
        int work;
        ContextDerivedData derivedData = this.context.getContextDerivedData();
        ContextDerivedData.DerivedColumn derivedColumn = derivedData.lookup(operation);
        CalculatedColumnAccessor accessor = this.getAccessorFor(provider, derivedColumn);
        if (accessor == null) {
            this.addDerivedDataColumn(provider, derivedColumn);
            accessor = this.getAccessorFor(provider, derivedColumn);
        }
        if ((work = elements.size()) == 1) {
            l1 = null;
            l2 = listener;
            Object var10_12 = null;
        }
        if (work > 1 && work <= 10) {
            l1 = null;
            l2 = null;
            int[] wk = new int[work];
            int i = 0;
            while (i < work) {
                wk[i] = 100;
                ++i;
            }
            sm = new SimpleMonitor(Messages.RefinedStructuredResult_Calculating, listener, wk);
        } else {
            l1 = listener;
            l1.beginTask(Messages.RefinedStructuredResult_Calculating, work);
            l2 = new SilentProgressListener(listener);
            sm = null;
        }
        int index = 0;
        for (Object row : elements) {
            if (sm != null) {
                l2 = sm.nextMonitor();
            }
            accessor.calculator.calculate(operation, row, l2);
            if (progress != null) {
                progress.done(index, row);
            }
            if (l1 != null) {
                l1.worked(1);
            }
            ++index;
            if (!listener.isCanceled()) continue;
            return;
        }
        if (l1 != null) {
            l1.done();
        }
    }

    public IStructuredResult unwrap() {
        return this.subject;
    }

    @Override
    public ResultMetaData getResultMetaData() {
        return this.metaData;
    }

    @Override
    public Column[] getColumns() {
        return this.columns.toArray(new Column[0]);
    }

    @Override
    public Object getColumnValue(Object row, int columnIndex) {
        return this.accessors.get(columnIndex).getValue(row);
    }

    public String getFormattedColumnValue(Object row, int columnIndex) {
        Object v = this.getColumnValue(row, columnIndex);
        if (v == null) {
            return "";
        }
        if (v.getClass() == String.class) {
            return (String)v;
        }
        return this.format(v, columnIndex);
    }

    @Override
    public IContextObject getContext(Object row) {
        return this.subject.getContext(row);
    }

    @Override
    public URL getIcon(Object row) {
        return this.iconProvider.getIcon(row);
    }

    @Override
    public boolean isExpanded(Object row) {
        return this.selectionProvider.isExpanded(row);
    }

    @Override
    public boolean isSelected(Object row) {
        return this.selectionProvider.isSelected(row);
    }

    protected List<?> refine(List<?> elements) throws SnapshotException {
        if (this.inlineJobs) {
            return this.refineInlined(elements);
        }
        int[] active = this.getActiveFilterIndeces();
        if (active.length > 0) {
            elements = this.filter(elements, active);
        }
        if (!this.resultIsSorted && this.sortColumn != -1 && elements != null) {
            this.sort(elements);
        }
        return elements;
    }

    protected List<?> refineUnfiltered(List<?> elements) throws SnapshotException {
        if (this.inlineJobs) {
            for (DerivedDataJobDefinition job : this.jobs) {
                this.calculate(job.getContextProvider(), job.getOperation(), elements, null, new VoidProgressListener());
            }
        }
        if (!this.resultIsSorted && this.sortColumn != -1 && elements != null) {
            this.sort(elements);
        }
        return elements;
    }

    private int[] getActiveFilterIndeces() {
        ArrayInt active = new ArrayInt();
        int ii = 0;
        while (ii < this.filters.size()) {
            if (this.filters.get(ii).isActive()) {
                active.add(ii);
            }
            ++ii;
        }
        return active.toArray();
    }

    private List<?> refineInlined(List<?> elements) throws SnapshotException {
        for (DerivedDataJobDefinition job : this.jobs) {
            this.calculate(job.getContextProvider(), job.getOperation(), elements, null, new VoidProgressListener());
        }
        int[] active = this.getActiveFilterIndeces();
        if (active.length > 0) {
            elements = this.filter(elements, active);
        }
        if (!this.resultIsSorted && this.sortColumn != -1) {
            this.sort(elements);
        }
        return elements;
    }

    private List<?> filter(List<?> elements, int[] active) {
        FilteredList answer = new FilteredList();
        Filter[] filter = new Filter[active.length];
        int ii = 0;
        while (ii < active.length) {
            filter[ii] = this.filters.get(active[ii]);
            ++ii;
        }
        for (Object object : elements) {
            boolean accept = true;
            int ii2 = 0;
            while (accept && ii2 < active.length) {
                Object v = this.getColumnValue(object, active[ii2]);
                accept = filter[ii2].acceptObject() ? filter[ii2].accept(v) : filter[ii2].accept(this.format(v, active[ii2]));
                ++ii2;
            }
            if (!accept) continue;
            answer.add(object);
        }
        answer.setFilteredCount(elements.size() - answer.size());
        return answer;
    }

    private String format(Object value, int columnIndex) {
        if (value == null) {
            return "";
        }
        Format f = this.columns.get(columnIndex).getFormatter();
        if (f != null) {
            try {
                return f.format(value);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return String.valueOf(value);
    }

    static class CalculatedColumnAccessor
    implements ValueAccessor {
        Column column;
        ContextProvider provider;
        ContextDerivedData.DerivedColumn derivedColumn;
        ContextDerivedData.DerivedCalculator calculator;

        public CalculatedColumnAccessor(Column column, ContextProvider provider, ContextDerivedData.DerivedColumn derivedColumn, ContextDerivedData.DerivedCalculator calculator) {
            this.column = column;
            this.provider = provider;
            this.derivedColumn = derivedColumn;
            this.calculator = calculator;
        }

        public Object getValue(Object row) {
            return this.calculator.lookup(row);
        }
    }

    class DefaultValueAccessor
    implements ValueAccessor {
        int columnIndex;

        public DefaultValueAccessor(int columnIndex) {
            this.columnIndex = columnIndex;
        }

        public Object getValue(Object row) {
            return RefinedStructuredResult.this.subject.getColumnValue(row, this.columnIndex);
        }
    }

    public static class DerivedDataJobDefinition {
        private ContextProvider provider;
        private ContextDerivedData.DerivedOperation operation;

        public DerivedDataJobDefinition(ContextProvider provider, ContextDerivedData.DerivedOperation operation) {
            this.provider = provider;
            this.operation = operation;
        }

        public ContextProvider getContextProvider() {
            return this.provider;
        }

        public ContextDerivedData.DerivedOperation getOperation() {
            return this.operation;
        }

        public void setOperation(ContextDerivedData.DerivedOperation operation) {
            this.operation = operation;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class FilteredList<E>
    extends ArrayList<E> {
        private static final long serialVersionUID = 1L;
        private int filteredCount;

        FilteredList() {
        }

        public int getFilteredCount() {
            return this.filteredCount;
        }

        public void setFilteredCount(int filteredCount) {
            this.filteredCount = filteredCount;
        }
    }

    public static interface ICalculationProgress {
        public void done(int var1, Object var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class MultiColumnComparator
    implements Comparator<Object> {
        private List<Comparator<Object>> list;

        public MultiColumnComparator(List<Comparator<Object>> list) {
            this.list = list;
        }

        @Override
        public int compare(Object o1, Object o2) {
            for (Comparator<Object> c : this.list) {
                int result = c.compare(o1, o2);
                if (result == 0) continue;
                return result;
            }
            return 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class NaturalComparator
    implements Comparator<Object> {
        private RefinedStructuredResult refinedResult;
        private int sortColumn;

        public NaturalComparator(RefinedStructuredResult refinedResult, int sortColumn) {
            this.refinedResult = refinedResult;
            this.sortColumn = sortColumn;
        }

        @Override
        public int compare(Object o1, Object o2) {
            Object d1 = this.refinedResult.getColumnValue(o1, this.sortColumn);
            Object d2 = this.refinedResult.getColumnValue(o2, this.sortColumn);
            if (d1 == null) {
                return d2 == null ? 0 : -1;
            }
            if (d2 == null) {
                return 1;
            }
            if (d1 instanceof Comparable && d2 instanceof Comparable) {
                try {
                    return ((Comparable)d1).compareTo(d2);
                }
                catch (ClassCastException e) {
                    if (d1 instanceof Number && d2 instanceof Number) {
                        int ret = Double.compare(((Number)d1).doubleValue(), ((Number)d2).doubleValue());
                        if (ret == 0) {
                            long l2;
                            long l1 = ((Number)d1).longValue();
                            if (l1 < (l2 = ((Number)d2).longValue())) {
                                return -1;
                            }
                            if (l1 > l2) {
                                return 1;
                            }
                            return 0;
                        }
                        return ret;
                    }
                    if (d1 instanceof Number) {
                        return -1;
                    }
                    if (d2 instanceof Number) {
                        return 1;
                    }
                    return d1.getClass().getName().compareTo(d2.getClass().getName());
                }
            }
            if (d1 instanceof Comparable) {
                return -1;
            }
            if (d2 instanceof Comparable) {
                return 1;
            }
            return d1.toString().compareTo(d2.toString());
        }
    }

    static interface ValueAccessor {
        public Object getValue(Object var1);
    }
}

