/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.oprofile.core.opxml.info;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.linuxtools.internal.oprofile.core.Oprofile;
import org.eclipse.linuxtools.internal.oprofile.core.OprofileCorePlugin;
import org.eclipse.linuxtools.internal.oprofile.core.opxml.AbstractDataAdapter;
import org.eclipse.linuxtools.internal.oprofile.core.opxml.EventIdCache;
import org.eclipse.linuxtools.profiling.launch.IRemoteFileProxy;
import org.eclipse.linuxtools.profiling.launch.RemoteProxyManager;
import org.eclipse.linuxtools.tools.launch.core.factory.RuntimeProcessFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class InfoAdapter
extends AbstractDataAdapter {
    public static final String HELP_EVENTS = "help_events";
    public static final String INFO = "info";
    public static final String DEFAULTS = "defaults";
    public static final String NUM_COUNTERS = "num-counters";
    public static final String CPU_FREQUENCY = "cpu-frequency";
    public static final String TIMER_MODE = "timer-mode";
    public static final String TIMER = "timer";
    public static final String EVENT_LIST = "event-list";
    public static final String COUNTER = "counter";
    public static final String EVENT = "event";
    public static final String EVENT_NAME = "event_name";
    public static final String NAME = "name";
    public static final String DESC = "desc";
    public static final String DESCRIPTION = "description";
    public static final String MIN_COUNT = "min_count";
    public static final String MINIMUM = "minimum";
    public static final String VALUE = "value";
    public static final String UNIT_MASKS = "unit_masks";
    public static final String UNITMASK = "unit-mask";
    public static final String DEFAULT = "default";
    public static final String TYPE = "type";
    public static final String UNIT_MASK = "unit_mask";
    public static final String MASK = "mask";
    public static final String SAMPLE_DIR = "sample-dir";
    public static final String LOCK_FILE = "lock-file";
    public static final String LOG_FILE = "log-file";
    public static final String DUMP_STATUS = "dump-status";
    public static final String CPUINFO = "/proc/cpuinfo";
    public static String DEV_OPROFILE = "/dev/oprofile/";
    public static String CPUTYPE = String.valueOf(DEV_OPROFILE) + "cpu_type";
    public static final String OP_SHARE = "/usr/share/oprofile/";
    public static final String EVENTS = "events";
    public static final String SAMPLE_DIR_VAL = "/var/lib/oprofile/samples/";
    public static final String LOCK_FILE_VAL = "/var/lib/oprofile/lock";
    public static final String LOG_FILE_VAL = "/var/lib/oprofile/samples/oprofiled.log";
    public static final String DUMP_STATUS_VAL = "/var/lib/oprofile/complete_dump";
    private Document newDoc;
    private Element oldRoot;
    private Element newRoot;
    private static IRemoteFileProxy proxy;
    private static boolean hasTimerSupport;

    public InfoAdapter() {
        try {
            if (InfoAdapter.hasTimerSupport()) {
                this.createDOM(null);
            } else {
                Process p = RuntimeProcessFactory.getFactory().exec("ophelp -X", Oprofile.OprofileProject.getProject());
                if (p != null) {
                    InputStream is = p.getInputStream();
                    this.createDOM(is);
                } else {
                    this.createDOM(null);
                }
            }
        }
        catch (IOException e) {
            this.createDOM(null);
        }
    }

    public InfoAdapter(IFileStore resourceFile) {
        InputStream inputStream = null;
        try {
            inputStream = resourceFile.openInputStream(0, (IProgressMonitor)new NullProgressMonitor());
            this.createDOM(inputStream);
            this.setEventIdCacheDoc(this.oldRoot);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    private void createDOM(InputStream is) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            if (is != null) {
                try {
                    Element elem;
                    Document oldDoc = builder.parse(is);
                    this.oldRoot = elem = (Element)oldDoc.getElementsByTagName(HELP_EVENTS).item(0);
                }
                catch (IOException | SAXException e) {
                    e.printStackTrace();
                    CoreException opcontrolException = new CoreException(OprofileCorePlugin.createErrorStatus("ophelpRun", null));
                    OprofileCorePlugin.showErrorDialog("opxmlSAXParseException", opcontrolException);
                }
            } else {
                CoreException opcontrolException = new CoreException(OprofileCorePlugin.createErrorStatus("ophelpRun", null));
                OprofileCorePlugin.showErrorDialog("ophelpInputStream", opcontrolException);
            }
            this.newDoc = builder.newDocument();
            try {
                this.newRoot = this.newDoc.createElement(INFO);
                this.newDoc.appendChild(this.newRoot);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        catch (ParserConfigurationException e1) {
            e1.printStackTrace();
        }
    }

    @Override
    public void process() {
        if (this.getNrCounters() == -1) {
            Element numCountersTag = this.newDoc.createElement(NUM_COUNTERS);
            numCountersTag.setTextContent("error");
            this.newRoot.appendChild(numCountersTag);
            return;
        }
        this.createHeaders();
        if (!InfoAdapter.hasTimerSupport() && this.oldRoot != null) {
            this.createXML();
        }
    }

    private void createHeaders() {
        String numCounters = String.valueOf(this.getNrCounters());
        Element numCountersTag = this.newDoc.createElement(NUM_COUNTERS);
        numCountersTag.setTextContent(String.valueOf(numCounters));
        this.newRoot.appendChild(numCountersTag);
        int cpuFreq = this.getCPUFrequency();
        Element cpuFreqTag = this.newDoc.createElement(CPU_FREQUENCY);
        cpuFreqTag.setTextContent(String.valueOf(cpuFreq));
        this.newRoot.appendChild(cpuFreqTag);
        Element defaultsTag = this.newDoc.createElement(DEFAULTS);
        Element sampleDirTag = this.newDoc.createElement(SAMPLE_DIR);
        sampleDirTag.setTextContent(SAMPLE_DIR_VAL);
        defaultsTag.appendChild(sampleDirTag);
        Element lockFileTag = this.newDoc.createElement(LOCK_FILE);
        lockFileTag.setTextContent(LOCK_FILE_VAL);
        defaultsTag.appendChild(lockFileTag);
        Element logFileTag = this.newDoc.createElement(LOG_FILE);
        logFileTag.setTextContent(LOG_FILE_VAL);
        defaultsTag.appendChild(logFileTag);
        Element dumpStatusTag = this.newDoc.createElement(DUMP_STATUS);
        dumpStatusTag.setTextContent(DUMP_STATUS_VAL);
        defaultsTag.appendChild(dumpStatusTag);
        this.newRoot.appendChild(defaultsTag);
        Element timerModeTag = this.newDoc.createElement(TIMER_MODE);
        timerModeTag.setTextContent(String.valueOf(InfoAdapter.hasTimerSupport()));
        this.newRoot.appendChild(timerModeTag);
    }

    public static void setOprofileDir(String dir) {
        DEV_OPROFILE = dir;
        CPUTYPE = String.valueOf(DEV_OPROFILE) + "cpu_type";
    }

    public static boolean hasTimerSupport() {
        return hasTimerSupport;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void checkTimerSupport() {
        try {
            proxy = RemoteProxyManager.getInstance().getFileProxy(Oprofile.OprofileProject.getProject());
            IFileStore fileStore = proxy.getResource(CPUTYPE);
            if (!fileStore.fetchInfo().exists()) return;
            Throwable throwable = null;
            Object var2_6 = null;
            try {
                InputStream is = fileStore.openInputStream(0, (IProgressMonitor)new NullProgressMonitor());
                try {
                    try (BufferedReader bi = new BufferedReader(new InputStreamReader(is));){
                        String cpuType = bi.readLine();
                        hasTimerSupport = cpuType.equals(TIMER);
                    }
                    if (is == null) return;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (is == null) throw throwable;
                    is.close();
                    throw throwable;
                }
                is.close();
                return;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (FileNotFoundException e) {
            hasTimerSupport = true;
            return;
        }
        catch (IOException e) {
            hasTimerSupport = true;
            e.printStackTrace();
            return;
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int getCPUFrequency() {
        int val = 0;
        try {
            proxy = RemoteProxyManager.getInstance().getFileProxy(Oprofile.OprofileProject.getProject());
            IFileStore fileStore = proxy.getResource(CPUINFO);
            if (!fileStore.fetchInfo().exists()) return val;
            InputStream is = fileStore.openInputStream(0, (IProgressMonitor)new NullProgressMonitor());
            try {
                Throwable throwable = null;
                Object var5_8 = null;
                try {
                    int n;
                    BufferedReader bi = new BufferedReader(new InputStreamReader(is));
                    try {
                        int index;
                        String line;
                        while (true) {
                            if ((line = bi.readLine()) == null) {
                                return val;
                            }
                            index = line.indexOf(58);
                            if (index == -1) continue;
                            if (line.startsWith("cpu MHz")) {
                                String substr = line.substring(index + 1).trim();
                                n = (int)Double.parseDouble(substr);
                                return n;
                            }
                            if (line.startsWith("clock")) {
                                int MHzLoc = line.indexOf("MHz");
                                String substr = line.substring(index + 1, MHzLoc);
                                return (int)Double.parseDouble(substr);
                            }
                            if (line.startsWith("cycle frequency [Hz]")) {
                                String substr = line.substring(index + 1).trim();
                                return (int)(Double.parseDouble(substr) / 1000000.0);
                            }
                            if (line.startsWith("Cpu0ClkTck")) break;
                        }
                        String substr = line.substring(index + 1).trim();
                        return (int)(Double.parseDouble(substr) / 1000000.0);
                    }
                    finally {
                        if (bi == null) return n;
                        bi.close();
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                        throw throwable;
                    }
                    if (throwable == throwable2) throw throwable;
                    throwable.addSuppressed(throwable2);
                    throw throwable;
                }
            }
            catch (IOException | NumberFormatException e) {
                e.printStackTrace();
                return val;
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return val;
    }

    private int getNrCounters() {
        if (Oprofile.OprofileProject.getProfilingBinary().equals("operf") || Oprofile.OprofileProject.getProfilingBinary().equals("ocount")) {
            return 1;
        }
        try {
            proxy = RemoteProxyManager.getInstance().getFileProxy(Oprofile.OprofileProject.getProject());
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        int MAXCPUS = Integer.MAX_VALUE;
        int i = 0;
        while (i < Integer.MAX_VALUE) {
            IFileStore fileStore = proxy.getResource(String.valueOf(DEV_OPROFILE) + i);
            if (!fileStore.fetchInfo().exists()) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private void createXML() {
        NodeList eventList = this.oldRoot.getElementsByTagName(EVENT);
        Element newEventList = this.newDoc.createElement(EVENT_LIST);
        int i = 0;
        while (i < eventList.getLength()) {
            Element defaultValTag;
            Element typeTag;
            Element newUnitMaskTag;
            String type;
            String defaultVal;
            Element event = (Element)eventList.item(i);
            String name = event.getAttribute(EVENT_NAME);
            String desc = event.getAttribute(DESC);
            String min_count = event.getAttribute(MIN_COUNT);
            Element newEventTag = this.newDoc.createElement(EVENT);
            Element nameTag = this.newDoc.createElement(NAME);
            nameTag.setTextContent(name);
            Element descTag = this.newDoc.createElement(DESCRIPTION);
            descTag.setTextContent(desc);
            Element minimumTag = this.newDoc.createElement(MINIMUM);
            minimumTag.setTextContent(min_count);
            newEventTag.appendChild(nameTag);
            newEventTag.appendChild(descTag);
            newEventTag.appendChild(minimumTag);
            Element unitMaskTag = (Element)event.getElementsByTagName(UNIT_MASKS).item(0);
            if (unitMaskTag != null) {
                defaultVal = unitMaskTag.getAttribute(DEFAULT);
                type = EventIdCache.getInstance().getUnitMaskType(name);
                newUnitMaskTag = this.newDoc.createElement(UNITMASK);
                typeTag = this.newDoc.createElement(TYPE);
                typeTag.setTextContent(type);
                defaultValTag = this.newDoc.createElement(DEFAULT);
                defaultValTag.setTextContent(defaultVal);
                newUnitMaskTag.appendChild(typeTag);
                newUnitMaskTag.appendChild(defaultValTag);
                newEventTag.appendChild(newUnitMaskTag);
                NodeList unitMaskList = unitMaskTag.getElementsByTagName(UNIT_MASK);
                int j = 0;
                while (j < unitMaskList.getLength()) {
                    Element unitMask = (Element)unitMaskList.item(j);
                    String maskVal = unitMask.getAttribute(MASK);
                    String maskDesc = unitMask.getAttribute(DESC);
                    String maskName = unitMask.getAttribute(NAME);
                    Element newMask = this.newDoc.createElement(MASK);
                    Element newVal = this.newDoc.createElement(VALUE);
                    newVal.setTextContent(maskVal);
                    Element newDesc = this.newDoc.createElement(DESCRIPTION);
                    newDesc.setTextContent(maskDesc);
                    Element newName = this.newDoc.createElement(NAME);
                    newName.setTextContent(maskName);
                    newMask.appendChild(newVal);
                    newMask.appendChild(newDesc);
                    newUnitMaskTag.appendChild(newMask);
                    ++j;
                }
            } else {
                defaultVal = "0";
                type = "mandatory";
                newUnitMaskTag = this.newDoc.createElement(UNITMASK);
                typeTag = this.newDoc.createElement(TYPE);
                typeTag.setTextContent(type);
                defaultValTag = this.newDoc.createElement(DEFAULT);
                defaultValTag.setTextContent(defaultVal);
                newUnitMaskTag.appendChild(typeTag);
                newUnitMaskTag.appendChild(defaultValTag);
                newEventTag.appendChild(newUnitMaskTag);
                Element newMask = this.newDoc.createElement(MASK);
                Element newVal = this.newDoc.createElement(VALUE);
                newVal.setTextContent("0");
                Element newDesc = this.newDoc.createElement(DESCRIPTION);
                newDesc.setTextContent("No unit mask");
                newMask.appendChild(newVal);
                newMask.appendChild(newDesc);
                newUnitMaskTag.appendChild(newMask);
            }
            newEventList.appendChild(newEventTag);
            ++i;
        }
        i = 0;
        while (i < this.getNrCounters()) {
            Element eventListTag = (Element)newEventList.cloneNode(true);
            eventListTag.setAttribute(COUNTER, String.valueOf(i));
            this.newRoot.appendChild(eventListTag);
            ++i;
        }
    }

    @Override
    public Document getDocument() {
        return this.newDoc;
    }

    private void setEventIdCacheDoc(Element elem) {
        EventIdCache.getInstance().setCacheDoc(elem);
    }
}

