/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.gcov.action;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.IBinary;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.linuxtools.binutils.utils.STSymbolManager;
import org.eclipse.linuxtools.internal.gcov.Activator;
import org.eclipse.linuxtools.internal.gcov.action.Messages;
import org.eclipse.linuxtools.internal.gcov.dialog.OpenGCDialog;
import org.eclipse.linuxtools.internal.gcov.view.CovView;
import org.eclipse.linuxtools.internal.gcov.view.annotatedsource.GcovAnnotationModelTracker;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorLauncher;
import org.eclipse.ui.PlatformUI;

public class OpenGCAction
implements IEditorLauncher {
    public void autoOpen(IPath file, String binaryPath, boolean isCompleteCoverageResultWanted) {
        GCFilePair pair = new GCFilePair(file);
        if (this.isFileValid(pair.gcda) && this.isFileValid(pair.gcno)) {
            String safeBinaryPath = STSymbolManager.sharedInstance.getBinaryObject(binaryPath) == null ? this.getDefaultBinary(file) : binaryPath;
            this.displayCoverage(file, safeBinaryPath, pair.gcda, isCompleteCoverageResultWanted);
        }
    }

    private boolean exists(String binaryFile) {
        File f = new File(binaryFile);
        return f.isFile();
    }

    public void open(IPath file) {
        OpenGCDialog d;
        String defaultBinary;
        GCFilePair pair = new GCFilePair(file);
        Shell shell = PlatformUI.getWorkbench().getDisplay().getActiveShell();
        if (!this.isFileValid(pair.gcda)) {
            String msg = NLS.bind((String)Messages.OpenGCAction_file_dne_run, (Object)pair.gcda);
            MessageDialog.openError((Shell)shell, (String)Messages.OpenGCAction_gcov_error, (String)msg);
            return;
        }
        if (!this.isFileValid(pair.gcno)) {
            String msg = NLS.bind((String)Messages.OpenGCAction_file_dne_compile, (Object)pair.gcno);
            MessageDialog.openError((Shell)shell, (String)Messages.OpenGCAction_gcov_error, (String)msg);
            return;
        }
        IDialogSettings ds = Activator.getDefault().getDialogSettings();
        IDialogSettings defaultMapping = ds.getSection(OpenGCDialog.class.getName());
        if (defaultMapping == null) {
            defaultMapping = ds.addNewSection(OpenGCDialog.class.getName());
        }
        if ((defaultBinary = defaultMapping.get(file.toOSString())) == null || defaultBinary.isEmpty() || !this.exists(defaultBinary)) {
            defaultBinary = STSymbolManager.sharedInstance.findOneAndOnlyBinary(file).getLocation().toOSString();
        }
        if ((d = new OpenGCDialog(shell, defaultBinary, file)).open() != 0) {
            return;
        }
        Thread t = new Thread(() -> this.displayCoverage(file, d.getBinaryFile(), gCFilePair.gcda, d.isCompleteCoverageResultWanted()));
        t.start();
    }

    private void displayCoverage(IPath file, String binaryPath, File gcda, boolean isCompleteCoverageResultWanted) {
        IProject project = STSymbolManager.sharedInstance.getProjectFromFile(file);
        GcovAnnotationModelTracker.getInstance().addProject(project, (IPath)new Path(binaryPath));
        PlatformUI.getWorkbench().getDisplay().syncExec(() -> GcovAnnotationModelTracker.getInstance().annotateAllCEditors());
        if (isCompleteCoverageResultWanted) {
            CovView.displayCovResults(binaryPath, gcda.getAbsolutePath());
        } else {
            CovView.displayCovDetailedResult(binaryPath, gcda.getAbsolutePath());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getDefaultBinaryFromUserPref(IProject project, IFile infoFile) throws IOException, CoreException {
        if (!infoFile.exists()) return null;
        Throwable throwable = null;
        Object var4_5 = null;
        try {
            String string;
            BufferedReader br = new BufferedReader(new InputStreamReader(infoFile.getContents(true)));
            try {
                IFile ifile;
                while (true) {
                    String name;
                    String line;
                    if ((line = br.readLine()) == null) {
                        return null;
                    }
                    String[] tab = line.split("=");
                    if (tab.length <= 1 || !(name = tab[0].trim()).equals("Program Name")) continue;
                    String value = tab[1].trim();
                    Path p = new Path(value);
                    if (p.isAbsolute()) {
                        if (!p.toFile().isFile()) continue;
                        string = p.toOSString();
                        return string;
                    }
                    if (project != null && (ifile = project.getFile(value)).exists()) break;
                }
                return ifile.getLocation().toOSString();
            }
            finally {
                if (br == null) return string;
                br.close();
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
                throw throwable;
            }
            if (throwable == throwable2) throw throwable;
            throwable.addSuppressed(throwable2);
            throw throwable;
        }
    }

    private String getDefaultBinary(IPath file) {
        IProject project;
        IFile c = STSymbolManager.sharedInstance.findFileFromPath(file);
        if (c != null && (project = c.getProject()) != null && project.exists()) {
            IContainer folder = c.getParent();
            IFile infoFile = folder.getFile((IPath)new Path("AnalysisInfo.txt"));
            try {
                String defaultBinaryFromUserPref = this.getDefaultBinaryFromUserPref(project, infoFile);
                if (defaultBinaryFromUserPref != null) {
                    return defaultBinaryFromUserPref;
                }
            }
            catch (IOException | CoreException defaultBinaryFromUserPref) {
                // empty catch block
            }
            ICProject cproject = CoreModel.getDefault().create(project);
            if (cproject != null) {
                try {
                    IBinary[] b = cproject.getBinaryContainer().getBinaries();
                    if (b != null && b.length > 0 && b[0] != null) {
                        IResource r = b[0].getResource();
                        return r.getLocation().toOSString();
                    }
                }
                catch (CModelException cModelException) {
                    // empty catch block
                }
            }
        }
        return "";
    }

    private boolean isFileValid(File file) {
        return file != null && file.isFile() && file.exists();
    }

    private class GCFilePair {
        final File gcda;
        final File gcno;

        private GCFilePair(IPath file) {
            String extension = file.getFileExtension();
            if ("gcno".equals(extension)) {
                this.gcda = file.removeFileExtension().addFileExtension("gcda").toFile();
                this.gcno = file.toFile();
            } else if ("gcda".equals(extension)) {
                this.gcda = file.toFile();
                this.gcno = file.removeFileExtension().addFileExtension("gcno").toFile();
            } else {
                this.gcda = null;
                this.gcno = null;
            }
        }
    }
}

