/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.core;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.linuxtools.internal.docker.core.IConsoleListener;

public class DockerConsoleOutputStream
extends OutputStream {
    private OutputStream stream;
    private Map<String, Object> properties;
    ListenerList<IConsoleListener> consoleListeners;

    public DockerConsoleOutputStream(OutputStream stream) {
        this.stream = stream;
    }

    public DockerConsoleOutputStream setOutputStream(OutputStream stream) {
        this.stream = stream;
        return this;
    }

    public void setTerminalProperties(Map<String, Object> properties) {
        this.properties = properties;
    }

    public Map<String, Object> getTerminalProperties() {
        return this.properties;
    }

    @Override
    public void write(byte[] b) throws IOException {
        if (this.stream != null) {
            this.stream.write(b);
        }
        this.notifyConsoleListeners(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (this.stream != null) {
            this.stream.write(b, off, len);
        }
        this.notifyConsoleListeners(b, off, len);
    }

    @Override
    public void write(int arg0) throws IOException {
        byte[] b = new byte[]{(byte)arg0};
        this.write(b);
    }

    @Override
    public void close() throws IOException {
        if (this.stream != null) {
            this.stream.close();
        }
    }

    @Override
    public void flush() throws IOException {
        if (this.stream != null) {
            this.stream.flush();
        }
    }

    public void addConsoleListener(IConsoleListener listener) {
        if (this.consoleListeners == null) {
            this.consoleListeners = new ListenerList(1);
        }
        this.consoleListeners.add((Object)listener);
    }

    public void removeConsoleListener(IConsoleListener listener) {
        if (this.consoleListeners != null) {
            this.consoleListeners.remove((Object)listener);
        }
    }

    public void notifyConsoleListeners(byte[] b, int off, int len) {
        if (this.consoleListeners != null) {
            String output = new String(b, off, len);
            Object[] listeners = this.consoleListeners.getListeners();
            int i = 0;
            while (i < listeners.length) {
                ((IConsoleListener)listeners[i]).newOutput(output);
                ++i;
            }
        }
    }
}

