/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.callgraph.core;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.channels.FileChannel;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.NotEnabledException;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.linuxtools.internal.callgraph.core.CallgraphCorePlugin;
import org.eclipse.linuxtools.internal.callgraph.core.Messages;
import org.eclipse.linuxtools.internal.callgraph.core.SystemTapParser;
import org.eclipse.linuxtools.tools.launch.core.factory.RuntimeProcessFactory;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.progress.UIJob;

public abstract class SystemTapView
extends ViewPart {
    private final String NEW_LINE = Messages.getString("SystemTapView.1");
    public Composite masterComposite;
    private Action kill;
    protected String viewID;
    private Action helpVersion;
    protected Action saveFile;
    protected Action openFile;
    protected Action openDefault;
    protected String sourcePath;
    protected IMenuManager file;
    private SystemTapParser parser;

    public abstract IStatus initializeView(Display var1, IProgressMonitor var2);

    public void layout() {
        this.masterComposite.layout();
    }

    public void maximizeIfUnmaximized() {
        IWorkbenchPage page = this.getViewSite().getWorkbenchWindow().getActivePage();
        if (page.getPartState(page.getActivePartReference()) != 1) {
            IHandlerService handlerService = (IHandlerService)this.getSite().getService(IHandlerService.class);
            try {
                handlerService.executeCommand("org.eclipse.ui.window.maximizePart", null);
            }
            catch (ExecutionException | NotEnabledException | NotHandledException | NotDefinedException e) {
                e.printStackTrace();
            }
        }
    }

    public void update() throws InterruptedException {
        ViewUIUpdater updater = new ViewUIUpdater("SystemTapView.update");
        updater.schedule();
        updater.join();
    }

    public SystemTapParser getParser() {
        return this.parser;
    }

    public boolean setParser(SystemTapParser parser) {
        this.parser = parser;
        return this.parser != null;
    }

    public abstract void updateMethod();

    public abstract void setViewID();

    protected abstract boolean createOpenAction();

    protected abstract boolean createOpenDefaultAction();

    public void addFileMenu() {
        IMenuManager menu = this.getViewSite().getActionBars().getMenuManager();
        if (this.file == null) {
            this.file = new MenuManager(Messages.getString("SystemTapView.FileMenu"));
            menu.add((IContributionItem)this.file);
        }
        if (this.createOpenAction()) {
            this.file.add((IAction)this.openFile);
        }
        if (this.createOpenDefaultAction()) {
            this.file.add((IAction)this.openDefault);
        }
        this.createSaveAction();
        this.file.add((IAction)this.saveFile);
    }

    public void addHelpMenu() {
        IMenuManager menu = this.getViewSite().getActionBars().getMenuManager();
        MenuManager help = new MenuManager(Messages.getString("SystemTapView.Help"));
        menu.add((IContributionItem)help);
        this.createHelpActions();
        help.add((IAction)this.helpVersion);
    }

    private void createHelpActions() {
        this.helpVersion = new Action(Messages.getString("SystemTapView.Version")){

            public void run() {
                try {
                    Process pr = RuntimeProcessFactory.getFactory().exec("stap -V", null);
                    BufferedReader buf = new BufferedReader(new InputStreamReader(pr.getErrorStream()));
                    String line = "";
                    String message = "";
                    while ((line = buf.readLine()) != null) {
                        message = String.valueOf(message) + line + SystemTapView.this.NEW_LINE;
                    }
                    try {
                        pr.waitFor();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    Shell sh = new Shell();
                    MessageDialog.openInformation((Shell)sh, (String)Messages.getString("SystemTapView.StapVersion"), (String)message);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        };
    }

    private void createSaveAction() {
        this.saveFile = new Action(Messages.getString("SystemTapView.SaveMenu")){

            public void run() {
                Shell sh = new Shell();
                FileDialog dialog = new FileDialog(sh, 8192);
                String filePath = dialog.open();
                if (filePath != null) {
                    SystemTapView.this.saveData(filePath);
                }
            }
        };
    }

    protected void addKillButton() {
        IToolBarManager mgr = this.getViewSite().getActionBars().getToolBarManager();
        this.kill = new Action(Messages.getString("SystemTapView.StopScript"), AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.linuxtools.callgraph.core", (String)"icons/progress_stop.gif")){

            public void run() {
                SystemTapView.this.getParser().cancelJob();
            }
        };
        mgr.add((IAction)this.kill);
        this.setKillButtonEnabled(false);
    }

    public void setKillButtonEnabled(boolean val) {
        if (this.kill != null) {
            this.kill.setEnabled(val);
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void saveData(String targetFile) {
        try {
            file = new File(targetFile);
            file.delete();
            file.createNewFile();
            sFile = new File(this.sourcePath);
            if (!sFile.exists()) {
                return;
            }
            var4_5 = null;
            var5_7 = null;
            try {
                fileIn = new FileInputStream(sFile);
                try {
                    fileOut = new FileOutputStream(file);
                    try {
                        channelIn = fileIn.getChannel();
                        try {
                            block36: {
                                block35: {
                                    channelOut = fileOut.getChannel();
                                    if (channelIn == null) {
                                    }
                                    if (channelOut == null) {
                                    }
                                    size = channelIn.size();
                                    buf = channelIn.map(FileChannel.MapMode.READ_ONLY, 0L, size);
                                    channelOut.write(buf);
                                    break block36;
                                    finally {
                                        if (channelOut == null) break block35;
                                        channelOut.close();
                                    }
                                }
                                if (channelIn != null) {
                                    channelIn.close();
                                }
                                if (fileOut != null) {
                                    fileOut.close();
                                }
                                if (fileIn != null) {
                                    fileIn.close();
                                }
                                return;
                            }
                            ** if (channelIn == null) goto lbl-1000
                        }
                        catch (Throwable var5_8) {
                            if (var4_5 == null) {
                                var4_5 = var5_8;
                            } else if (var4_5 != var5_8) {
                                var4_5.addSuppressed(var5_8);
                            }
                            if (channelIn == null) throw var4_5;
                            channelIn.close();
                            throw var4_5;
                        }
lbl-1000:
                        // 1 sources

                        {
                            channelIn.close();
                        }
lbl-1000:
                        // 2 sources

                        {
                        }
                        ** if (fileOut == null) goto lbl-1000
                    }
                    catch (Throwable var5_9) {
                        if (var4_5 == null) {
                            var4_5 = var5_9;
                        } else if (var4_5 != var5_9) {
                            var4_5.addSuppressed(var5_9);
                        }
                        if (fileOut == null) throw var4_5;
                        fileOut.close();
                        throw var4_5;
                    }
lbl-1000:
                    // 1 sources

                    {
                        fileOut.close();
                    }
lbl-1000:
                    // 2 sources

                    {
                    }
                    if (fileIn == null) return;
                }
                catch (Throwable var5_10) {
                    if (var4_5 == null) {
                        var4_5 = var5_10;
                    } else if (var4_5 != var5_10) {
                        var4_5.addSuppressed(var5_10);
                    }
                    if (fileIn == null) throw var4_5;
                    fileIn.close();
                    throw var4_5;
                }
                fileIn.close();
                return;
            }
            catch (Throwable var5_11) {
                if (var4_5 == null) {
                    var4_5 = var5_11;
                    throw var4_5;
                }
                if (var4_5 == var5_11) throw var4_5;
                var4_5.addSuppressed(var5_11);
                throw var4_5;
            }
        }
        catch (IOException e) {
            CallgraphCorePlugin.logException(e);
        }
    }

    public void setSourcePath(String file) {
        this.sourcePath = file;
    }

    private class ViewUIUpdater
    extends UIJob {
        public ViewUIUpdater(String name) {
            super(name);
        }

        public IStatus runInUIThread(IProgressMonitor monitor) {
            SystemTapView.this.updateMethod();
            return Status.OK_STATUS;
        }
    }
}

