/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ldt.ui.wizards.pages;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.ldt.core.buildpath.LuaExecutionEnvironment;
import org.eclipse.ldt.core.grammar.IGrammar;
import org.eclipse.ldt.core.internal.grammar.LuaGrammarManager;
import org.eclipse.ldt.core.internal.konekimigration.KonekiMigrationUtil;
import org.eclipse.ldt.ui.internal.Activator;
import org.eclipse.ldt.ui.wizards.pages.GrammarGroup;
import org.eclipse.ldt.ui.wizards.pages.LuaExecutionEnvironmentGroup;
import org.eclipse.ldt.ui.wizards.pages.Messages;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class ConvertToLuaProjectMainPage
extends WizardPage {
    private boolean isKonekiMigration = false;
    private LuaExecutionEnvironmentGroup luaExecutionEnvironmentGroup;
    private GrammarGroup grammarGroup;
    private IProject project;

    public ConvertToLuaProjectMainPage(String pageName, IProject project) {
        super(pageName);
        this.project = project;
        this.isKonekiMigration = KonekiMigrationUtil.isKonekiProject((IProject)project);
        this.setTitle(NLS.bind((String)Messages.ConvertToLuaProjectMainPage_title, (Object)project.getName()));
        if (this.isKonekiMigration) {
            this.setMessage(Messages.ConvertToLuaProjectMainPage_migrationMessage, 2);
        } else {
            this.setMessage(Messages.ConvertToLuaProjectMainPage_defaultMessage);
        }
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        GridLayoutFactory.swtDefaults().applyTo(composite);
        GridDataFactory.swtDefaults().align(4, 0x1000000).applyTo((Control)composite);
        if (this.isKonekiMigration) {
            Link link = new Link(composite, 2);
            link.setText(Messages.ConvertToLuaProjectMainPage_linkToMigrationPage);
            link.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    try {
                        PlatformUI.getWorkbench().getBrowserSupport().getExternalBrowser().openURL(new URL(event.text));
                    }
                    catch (PartInitException e) {
                        Activator.logWarning("Unable to open migration koneki/ldt wiki page", e);
                    }
                    catch (MalformedURLException e) {
                        Activator.logWarning("Unable to open migration koneki/ldt wiki page", e);
                    }
                }
            });
        }
        LuaExecutionEnvironment defaultEE = null;
        if (this.isKonekiMigration) {
            defaultEE = KonekiMigrationUtil.getKonekiExecutionEnvironment((IProject)this.project);
        }
        this.luaExecutionEnvironmentGroup = new LuaExecutionEnvironmentGroup(composite, false, defaultEE);
        this.luaExecutionEnvironmentGroup.addObserver(new Observer(){

            @Override
            public void update(Observable o, Object arg) {
                LuaExecutionEnvironment ee = ConvertToLuaProjectMainPage.this.luaExecutionEnvironmentGroup.getSelectedLuaExecutionEnvironment();
                ConvertToLuaProjectMainPage.this.grammarGroup.setDefaultGrammar(LuaGrammarManager.getDefaultGrammarFor((LuaExecutionEnvironment)ee).getName());
            }
        });
        this.grammarGroup = new GrammarGroup(composite);
        IGrammar grammar = LuaGrammarManager.getDefaultGrammarFor((LuaExecutionEnvironment)this.getLuaExecutionEnvironement());
        if (grammar != null) {
            this.grammarGroup.setDefaultGrammar(grammar.getName());
        }
        this.setControl((Control)composite);
        Dialog.applyDialogFont((Control)composite);
    }

    public LuaExecutionEnvironment getLuaExecutionEnvironement() {
        return this.luaExecutionEnvironmentGroup.getSelectedLuaExecutionEnvironment();
    }

    public String getGrammar() {
        return this.grammarGroup.getSelectedGrammar();
    }

    public boolean isKonekiMigration() {
        return this.isKonekiMigration;
    }
}

