/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jwt.we.editors.outline;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LightweightSystem;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.parts.ScrollableThumbnail;
import org.eclipse.gef.editparts.ScalableFreeformRootEditPart;
import org.eclipse.jwt.we.editors.WEEditor;
import org.eclipse.jwt.we.editors.outline.ModelOutlinePage;
import org.eclipse.jwt.we.editors.pages.activityEditor.WEEditorSheet;
import org.eclipse.jwt.we.editors.preferences.PreferenceReader;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;

public class ModelOutlineAreaOverview {
    private Canvas overview;
    private ScalableFreeformRootEditPart loadedRootEditPart;
    private ScrollableThumbnail thumbnail;
    private LightweightSystem lws;

    public ModelOutlineAreaOverview(ModelOutlinePage outlinePage) {
        this.overview = new Canvas((Composite)outlinePage.getControl(), 0);
        this.overview.setBackground(PreferenceReader.appearanceEditorColor.get());
        final ModelOutlinePage outlineP = outlinePage;
        this.overview.addControlListener(new ControlListener(){

            public void controlMoved(ControlEvent e) {
            }

            public void controlResized(ControlEvent e) {
                if (PreferenceReader.outlineShowArea.get().equals(ModelOutlinePage.OUTLINE_AREA_BOTH) && outlineP.getCurrentDisplayMode().equals(ModelOutlinePage.OUTLINE_AREA_BOTH)) {
                    PreferenceReader.outlineOverviewSize.set(((SashForm)outlineP.getControl()).getWeights()[0]);
                    PreferenceReader.outlineTreeviewSize.set(((SashForm)outlineP.getControl()).getWeights()[1]);
                }
            }
        });
    }

    public void showThumbnail(ScalableFreeformRootEditPart rootEditPart) {
        if (this.loadedRootEditPart == rootEditPart) {
            return;
        }
        if (rootEditPart == null) {
            rootEditPart = new ScalableFreeformRootEditPart();
        }
        if (this.thumbnail != null) {
            this.overview.redraw();
        }
        if (this.thumbnail == null) {
            this.thumbnail = new ScrollableThumbnail((Viewport)rootEditPart.getFigure());
        } else {
            this.thumbnail.setViewport((Viewport)rootEditPart.getFigure());
        }
        this.thumbnail.setSource(rootEditPart.getLayer((Object)"Printable Layers"));
        this.lws = new LightweightSystem(this.overview);
        this.lws.setContents((IFigure)this.thumbnail);
        this.loadedRootEditPart = rootEditPart;
    }

    public void refresh(WEEditor editor) {
        if (editor.getActiveEditor() instanceof WEEditorSheet) {
            this.showThumbnail(editor.getCurrentActivitySheet().getRootEditPart());
        } else {
            this.showThumbnail(null);
        }
    }

    public void dispose() {
        if (this.thumbnail != null) {
            this.thumbnail.deactivate();
            this.thumbnail = null;
        }
        if (this.overview != null && !this.overview.isDisposed()) {
            this.overview.dispose();
        }
        this.overview = null;
        this.lws = null;
        this.loadedRootEditPart = null;
    }
}

