/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.rc.common.components;

import java.util.ArrayList;
import java.util.EventListener;
import java.util.List;
import org.eclipse.jubula.rc.common.components.AUTComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class HierarchyContainer<COMPONENT_TYPE> {
    private boolean m_nameGenerated;
    private HierarchyContainer<COMPONENT_TYPE> m_parent;
    private AUTComponent<COMPONENT_TYPE> m_component;
    private List<HierarchyContainer<COMPONENT_TYPE>> m_containerList = new ArrayList<HierarchyContainer<COMPONENT_TYPE>>();
    private List<EventListener> m_listenerList = new ArrayList<EventListener>();
    private String m_name;

    public HierarchyContainer(AUTComponent<COMPONENT_TYPE> component, HierarchyContainer<COMPONENT_TYPE> parent) {
        this.m_component = component;
        this.m_parent = parent;
    }

    public HierarchyContainer(AUTComponent<COMPONENT_TYPE> component) {
        this(component, null);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof HierarchyContainer)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        HierarchyContainer o = (HierarchyContainer)obj;
        return this.m_component.equals(o.m_component);
    }

    public int hashCode() {
        return this.m_component.hashCode();
    }

    public AUTComponent<COMPONENT_TYPE> getCompID() {
        return this.m_component;
    }

    public void add(HierarchyContainer<COMPONENT_TYPE> component) {
        this.getContainerList().add(component);
    }

    public void remove(HierarchyContainer<COMPONENT_TYPE> component) {
        this.getContainerList().remove(component);
    }

    public HierarchyContainer<COMPONENT_TYPE>[] getComps() {
        if (this.getContainerList().isEmpty()) {
            return new HierarchyContainer[0];
        }
        Object[] objectArray = this.getContainerList().toArray();
        HierarchyContainer[] containerArray = new HierarchyContainer[objectArray.length];
        int i = 0;
        while (i < objectArray.length) {
            containerArray[i] = (HierarchyContainer)objectArray[i];
            ++i;
        }
        return containerArray;
    }

    protected void addContainerListnr(EventListener listener) {
        this.m_listenerList.add(listener);
    }

    protected void removeContainerListener(EventListener listener) {
        this.m_listenerList.remove(listener);
    }

    protected EventListener[] getListnrs() {
        if (this.m_listenerList.isEmpty()) {
            return new EventListener[0];
        }
        return this.m_listenerList.toArray(new EventListener[this.m_listenerList.size()]);
    }

    public String getName() {
        return this.m_name;
    }

    public final void setName(String name, boolean nameGenerated) {
        this.m_name = name;
        this.m_nameGenerated = nameGenerated;
    }

    public final boolean isNameGenerated() {
        return this.m_nameGenerated;
    }

    public HierarchyContainer<COMPONENT_TYPE> getPrnt() {
        return this.m_parent;
    }

    public void setPrnt(HierarchyContainer<COMPONENT_TYPE> parent) {
        this.m_parent = parent;
    }

    protected List<HierarchyContainer<COMPONENT_TYPE>> getContainerList() {
        return this.m_containerList;
    }
}

