/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.handlers;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.jubula.client.core.events.DataEventDispatcher;
import org.eclipse.jubula.client.core.model.IConditionalStatementPO;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IPersistentObject;
import org.eclipse.jubula.client.core.model.NodeMaker;
import org.eclipse.jubula.client.ui.handlers.AbstractSelectionBasedHandler;
import org.eclipse.jubula.client.ui.rcp.controllers.IEditorOperation;
import org.eclipse.jubula.client.ui.rcp.editors.AbstractTestCaseEditor;
import org.eclipse.jubula.client.ui.rcp.handlers.NewTestCaseHandlerTCEditor;
import org.eclipse.jubula.client.ui.rcp.utils.NodeTargetCalculator;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.handlers.HandlerUtil;

public class NewController
extends AbstractSelectionBasedHandler {
    protected Object executeImpl(final ExecutionEvent event) {
        IWorkbenchPart activePart = HandlerUtil.getActivePart((ExecutionEvent)event);
        if (activePart instanceof AbstractTestCaseEditor) {
            final AbstractTestCaseEditor tce = (AbstractTestCaseEditor)activePart;
            tce.getEditorHelper().doEditorOperation(new IEditorOperation(){

                @Override
                public void run(IPersistentObject workingPo) {
                    INodePO selected = (INodePO)NewController.this.getSelection().getFirstElement();
                    NodeTargetCalculator.NodeTarget place = NewTestCaseHandlerTCEditor.getPositionToInsert(selected, tce.getTreeViewer().getExpandedState((Object)selected));
                    if (place == null) {
                        return;
                    }
                    NewController.this.addStatement(event.getCommand().getId(), place.getNode(), place.getPos(), tce);
                }
            });
        }
        return null;
    }

    private void addStatement(String comId, INodePO target, int position, AbstractTestCaseEditor tce) {
        IConditionalStatementPO toAdd = null;
        switch (comId) {
            case "org.eclipse.jubula.client.ui.rcp.commands.newConditionalStatement": {
                toAdd = NodeMaker.createConditionalStatementPO();
                break;
            }
            case "org.eclipse.jubula.client.ui.rcp.commands.newDoWhile": {
                toAdd = NodeMaker.createDoWhilePO();
                break;
            }
            case "org.eclipse.jubula.client.ui.rcp.commands.newWhileDo": {
                toAdd = NodeMaker.createWhileDoPO();
                break;
            }
            case "org.eclipse.jubula.client.ui.rcp.commands.newIterateLoop": {
                toAdd = NodeMaker.createIteratePO();
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown command ID");
            }
        }
        target.addNode(position, (INodePO)toAdd);
        tce.getEditorHelper().setDirty(true);
        DataEventDispatcher.getInstance().fireDataChangedListener((IPersistentObject)toAdd, DataEventDispatcher.DataState.Added, DataEventDispatcher.UpdateState.onlyInEditor);
        tce.getTreeViewer().expandToLevel((Object)target, 1);
    }
}

