/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.dialogs;

import java.util.List;
import java.util.Map;
import org.apache.commons.lang.Validate;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jubula.client.core.events.DataEventDispatcher;
import org.eclipse.jubula.client.core.model.IAUTConfigPO;
import org.eclipse.jubula.client.core.model.IAUTMainPO;
import org.eclipse.jubula.client.core.utils.IGenericListener;
import org.eclipse.jubula.client.internal.AutAgentConnection;
import org.eclipse.jubula.client.internal.exceptions.ConnectionException;
import org.eclipse.jubula.client.ui.rcp.Plugin;
import org.eclipse.jubula.client.ui.rcp.databinding.validators.AutConfigNameValidator;
import org.eclipse.jubula.client.ui.rcp.handlers.StartAutHandler;
import org.eclipse.jubula.client.ui.rcp.i18n.Messages;
import org.eclipse.jubula.client.ui.rcp.utils.DialogStatusParameter;
import org.eclipse.jubula.client.ui.rcp.widgets.autconfig.AutConfigComponent;
import org.eclipse.jubula.client.ui.utils.ErrorHandlingUtil;
import org.eclipse.jubula.toolkit.common.businessprocess.ToolkitSupportBP;
import org.eclipse.jubula.toolkit.common.exception.ToolkitPluginException;
import org.eclipse.jubula.tools.internal.exception.UnexpectedGenericTypeException;
import org.eclipse.jubula.tools.internal.messagehandling.MessageIDs;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.IHandlerService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AUTConfigPropertiesDialog
extends TitleAreaDialog
implements DataEventDispatcher.IDialogStatusListener {
    private static Logger log = LoggerFactory.getLogger(AUTConfigPropertiesDialog.class);
    private static final int TRY_AUTID = 1234;
    private IAUTConfigPO m_autConfig;
    private String m_toolkit = "";
    private String m_autName;
    private IAUTMainPO m_aut;
    private IValidator m_autIdValidator;
    private IValidator m_autConfigNameValidator;
    private AutConfigComponent m_autConfigComponent = null;

    public AUTConfigPropertiesDialog(Shell parentShell, IAUTConfigPO autConfig, String toolkit, String autName, IAUTMainPO aut, IValidator autIdValidator, AutConfigNameValidator autConfigNameValidator) {
        super(parentShell);
        this.m_autConfig = autConfig;
        this.m_toolkit = toolkit;
        this.m_autName = autName;
        this.m_aut = aut;
        this.m_autIdValidator = autIdValidator;
        this.m_autConfigNameValidator = autConfigNameValidator;
    }

    protected void setShellStyle(int newShellStyle) {
        super.setShellStyle(newShellStyle | 0x10);
    }

    protected Control createDialogArea(Composite parent) {
        DataEventDispatcher.getInstance().getDialogStatusListenerMgr().addListener((IGenericListener)this);
        Plugin.getHelpSystem().setHelp((Control)parent, "org.eclipse.jubula.client.ua.help.autConfigPropDialogContextId");
        this.setTitle(Messages.ProjectWizardAutSettings);
        this.setMessage(Messages.ProjectWizardAUTData);
        try {
            Composite autConfigComposite = ToolkitSupportBP.getAutConfigComposite((String)this.m_toolkit, (Composite)parent, (int)768, (Map)this.m_autConfig.getConfigMap(), (String)this.m_autName);
            autConfigComposite.setLayoutData((Object)new GridData(4, 4, true, true));
            if (autConfigComposite instanceof AutConfigComponent) {
                this.m_autConfigComponent = (AutConfigComponent)autConfigComposite;
                this.m_autConfigComponent.setAutIdValidator(this.m_autIdValidator);
                this.m_autConfigComponent.setAutConfignameValidator(this.m_autConfigNameValidator);
            }
        }
        catch (ToolkitPluginException e) {
            log.error(String.valueOf(Messages.NoAUTConfigPageForToolkit) + ":" + " " + String.valueOf(this.m_toolkit), (Throwable)e);
            ErrorHandlingUtil.createMessageDialog((Integer)MessageIDs.E_NO_AUTCONFIG_DIALOG);
        }
        return parent;
    }

    public int open() {
        if (this.m_autConfigComponent != null) {
            this.m_autConfigComponent.checkAll();
        }
        return super.open();
    }

    public boolean close() {
        DataEventDispatcher.getInstance().getDialogStatusListenerMgr().removeListener((IGenericListener)this);
        return super.close();
    }

    public void eventOccurred(List<? extends Object> params) {
        DialogStatusParameter parameter = (DialogStatusParameter)params.get(0);
        this.setMessage(parameter.getMessage(), parameter.getStatusType());
        Button okButton = this.getButton(0);
        if (okButton != null) {
            okButton.setEnabled(parameter.getButtonState().booleanValue());
        }
    }

    public void checkGenericListElementType(List<? extends Object> params) throws UnexpectedGenericTypeException {
        Validate.noNullElements(params);
        Class<DialogStatusParameter> type = null;
        int index = 0;
        if (!(params.get(0) instanceof DialogStatusParameter)) {
            type = DialogStatusParameter.class;
        }
        if (type != null) {
            StringBuilder msg = new StringBuilder();
            msg.append(Messages.GenericType).append(" ").append(type).append(" ").append(Messages.WasExpectedBut).append(" ").append(params.get(index).getClass()).append(" ").append(Messages.WasFound).append(".");
            throw new UnexpectedGenericTypeException(msg.toString(), MessageIDs.E_UNEXPECTED_EXCEPTION);
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 1234, Messages.TryAUTButton, false);
        super.createButtonsForButtonBar(parent);
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 1234) {
            this.tryToStartAUT();
        } else {
            super.buttonPressed(buttonId);
        }
    }

    private void tryToStartAUT() {
        boolean conn = false;
        try {
            conn = AutAgentConnection.getInstance().isConnected();
        }
        catch (ConnectionException connectionException) {}
        try {
            if (!conn) {
                ((IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class)).executeCommand("org.eclipse.jubula.client.autagent.commands.ConnectToEmbeddedAutAgent", null);
            }
            StartAutHandler.startAut(this.m_aut, this.m_autConfig);
        }
        catch (Exception e) {
            ErrorHandlingUtil.createMessageDialogException((Throwable)e);
        }
    }
}

