/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.console.ssh;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Map;
import org.apache.felix.service.command.CommandProcessor;
import org.apache.felix.service.command.CommandSession;
import org.eclipse.equinox.console.common.ConsoleInputHandler;
import org.eclipse.equinox.console.common.ConsoleInputScanner;
import org.eclipse.equinox.console.common.ConsoleInputStream;
import org.eclipse.equinox.console.common.ConsoleOutputStream;
import org.eclipse.equinox.console.common.KEYS;
import org.eclipse.equinox.console.common.terminal.TerminalTypeMappings;
import org.eclipse.equinox.console.ssh.SshInputHandler;
import org.eclipse.equinox.console.ssh.SshShell;
import org.eclipse.equinox.console.storage.SecureUserStore;
import org.osgi.framework.BundleContext;

public class SshSession
extends Thread
implements Closeable {
    private CommandProcessor processor;
    private BundleContext context;
    private SshShell sshShell;
    private InputStream in;
    private OutputStream out;
    private TerminalTypeMappings currentMappings;
    private Map<String, KEYS> currentEscapesToKey;
    private static final String PROMPT = "prompt";
    private static final String OSGI_PROMPT = "osgi> ";
    private static final String SCOPE = "SCOPE";
    private static final String EQUINOX_SCOPE = "equinox:*";
    private static final String INPUT_SCANNER = "INPUT_SCANNER";
    private static final String SSH_INPUT_SCANNER = "SSH_INPUT_SCANNER";
    private static final String USER_STORAGE_PROPERTY_NAME = "osgi.console.ssh.useDefaultSecureStorage";
    private static final String DEFAULT_USER = "equinox";
    private static final String CLOSEABLE = "CLOSEABLE";
    private static final int ADD_USER_COUNTER_LIMIT = 2;

    public SshSession(CommandProcessor processor, BundleContext context, SshShell sshShell, InputStream in, OutputStream out, TerminalTypeMappings currentMappings, Map<String, KEYS> currentExcapesToKey) {
        this.processor = processor;
        this.context = context;
        this.sshShell = sshShell;
        this.in = in;
        this.out = out;
        this.currentMappings = currentMappings;
        this.currentEscapesToKey = currentExcapesToKey;
    }

    @Override
    public void run() {
        ConsoleInputStream input = new ConsoleInputStream();
        ConsoleOutputStream outp = new ConsoleOutputStream(this.out);
        SshInputHandler inputHandler = new SshInputHandler(this.in, input, outp);
        inputHandler.getScanner().setBackspace(this.currentMappings.getBackspace());
        inputHandler.getScanner().setDel(this.currentMappings.getDel());
        inputHandler.getScanner().setCurrentEscapesToKey(this.currentEscapesToKey);
        inputHandler.getScanner().setEscapes(this.currentMappings.getEscapes());
        inputHandler.start();
        ConsoleInputStream inp = new ConsoleInputStream();
        ConsoleInputHandler consoleInputHandler = new ConsoleInputHandler((InputStream)input, inp, (OutputStream)outp);
        consoleInputHandler.getScanner().setBackspace(this.currentMappings.getBackspace());
        consoleInputHandler.getScanner().setDel(this.currentMappings.getDel());
        consoleInputHandler.getScanner().setCurrentEscapesToKey(this.currentEscapesToKey);
        consoleInputHandler.getScanner().setEscapes(this.currentMappings.getEscapes());
        ((ConsoleInputScanner)consoleInputHandler.getScanner()).setContext(this.context);
        consoleInputHandler.start();
        PrintStream output = new PrintStream((OutputStream)outp);
        CommandSession session = this.processor.createSession((InputStream)inp, (OutputStream)output, (OutputStream)output);
        session.put(SCOPE, (Object)EQUINOX_SCOPE);
        session.put(PROMPT, (Object)OSGI_PROMPT);
        session.put(INPUT_SCANNER, (Object)consoleInputHandler.getScanner());
        session.put(SSH_INPUT_SCANNER, (Object)inputHandler.getScanner());
        session.put(CLOSEABLE, (Object)this);
        ((ConsoleInputScanner)consoleInputHandler.getScanner()).setSession(session);
        try {
            try {
                if ("true".equals(this.context.getProperty(USER_STORAGE_PROPERTY_NAME))) {
                    String[] names;
                    String[] stringArray = names = SecureUserStore.getUserNames();
                    int n = names.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String name = stringArray[n2];
                        if (DEFAULT_USER.equals(name)) {
                            if (names.length == 1) {
                                session.getConsole().println("Currently the default user is the only one; since it will be deleted after first login, create a new user:");
                                boolean isUserAdded = false;
                                int count = 0;
                                while (!isUserAdded && count < 2) {
                                    isUserAdded = (Boolean)session.execute((CharSequence)"addUser");
                                    ++count;
                                }
                                if (!isUserAdded) break;
                            }
                            if (!SecureUserStore.existsUser(name)) break;
                            SecureUserStore.deleteUser(name);
                            break;
                        }
                        ++n2;
                    }
                }
                session.execute((CharSequence)"gosh --login --noshutdown");
            }
            catch (Exception e) {
                e.printStackTrace();
                session.close();
            }
        }
        finally {
            session.close();
        }
    }

    @Override
    public void close() throws IOException {
        this.interrupt();
        this.sshShell.removeSession(this);
    }
}

