/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.mpc.ui.wizards;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.epp.internal.mpc.core.model.CatalogBranding;
import org.eclipse.epp.internal.mpc.ui.CatalogRegistry;
import org.eclipse.epp.internal.mpc.ui.MarketplaceClientUi;
import org.eclipse.epp.internal.mpc.ui.MarketplaceClientUiPlugin;
import org.eclipse.epp.internal.mpc.ui.catalog.MarketplaceCatalog;
import org.eclipse.epp.internal.mpc.ui.catalog.MarketplaceNodeCatalogItem;
import org.eclipse.epp.internal.mpc.ui.catalog.MarketplaceNodeInstallableUnitItem;
import org.eclipse.epp.internal.mpc.ui.catalog.ResourceProvider;
import org.eclipse.epp.internal.mpc.ui.css.StyleHelper;
import org.eclipse.epp.internal.mpc.ui.util.Util;
import org.eclipse.epp.internal.mpc.ui.wizards.ActionLink;
import org.eclipse.epp.internal.mpc.ui.wizards.CatalogSwitcher;
import org.eclipse.epp.internal.mpc.ui.wizards.FeatureSelectionWizardPage;
import org.eclipse.epp.internal.mpc.ui.wizards.IWizardButtonLabelProvider;
import org.eclipse.epp.internal.mpc.ui.wizards.ImportFavoritesActionLink;
import org.eclipse.epp.internal.mpc.ui.wizards.InstallAllActionLink;
import org.eclipse.epp.internal.mpc.ui.wizards.MarketplaceCatalogConfiguration;
import org.eclipse.epp.internal.mpc.ui.wizards.MarketplaceViewer;
import org.eclipse.epp.internal.mpc.ui.wizards.MarketplaceWizard;
import org.eclipse.epp.internal.mpc.ui.wizards.Messages;
import org.eclipse.epp.internal.mpc.ui.wizards.NewsViewer;
import org.eclipse.epp.internal.mpc.ui.wizards.SelectionModel;
import org.eclipse.epp.mpc.core.model.ICatalogBranding;
import org.eclipse.epp.mpc.core.model.ICategory;
import org.eclipse.epp.mpc.core.model.IMarket;
import org.eclipse.epp.mpc.core.model.INews;
import org.eclipse.epp.mpc.core.model.INode;
import org.eclipse.epp.mpc.core.service.IUserFavoritesService;
import org.eclipse.epp.mpc.core.service.ServiceHelper;
import org.eclipse.epp.mpc.ui.CatalogDescriptor;
import org.eclipse.epp.mpc.ui.Operation;
import org.eclipse.equinox.internal.p2.discovery.Catalog;
import org.eclipse.equinox.internal.p2.discovery.model.CatalogItem;
import org.eclipse.equinox.internal.p2.ui.discovery.DiscoveryImages;
import org.eclipse.equinox.internal.p2.ui.discovery.wizards.CatalogPage;
import org.eclipse.equinox.internal.p2.ui.discovery.wizards.CatalogViewer;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class MarketplacePage
extends CatalogPage
implements IWizardButtonLabelProvider {
    private static final String WIDGET_ID_TAB_FAVORITES = "tab:favorites";
    public static final String WIDGET_ID_TAB_SEARCH = "tab:search";
    public static final String WIDGET_ID_TAB_FEATURED_MARKET = "tab:featured-market";
    public static final String WIDGET_ID_TAB_RECENT = "tab:recent";
    public static final String WIDGET_ID_TAB_POPULAR = "tab:popular";
    public static final String WIDGET_ID_TAB_RELATED = "tab:related";
    public static final String WIDGET_ID_TAB_INSTALLED = "tab:installed";
    public static final String WIDGET_ID_TAB_NEWS = "tab:news";
    public static final String WIDGET_ID_KEY = String.valueOf(MarketplacePage.class.getName()) + "::part";
    private static final String CONTENT_TYPE_KEY = MarketplaceViewer.ContentType.class.getName();
    private final MarketplaceCatalogConfiguration configuration;
    private CatalogDescriptor previousCatalogDescriptor;
    private boolean updated;
    private Link contentListLinks;
    private ActionLink selectionLink;
    private ActionLink deselectLink;
    private CTabFolder tabFolder;
    private CTabItem searchTabItem;
    private CTabItem recentTabItem;
    private CTabItem popularTabItem;
    private CTabItem favoritedTabItem;
    private CTabItem featuredMarketTabItem;
    private CTabItem relatedTabItem;
    private CTabItem newsTabItem;
    private Control tabContent;
    private CTabItem installedTabItem;
    private NewsViewer newsViewer;
    private CatalogSwitcher marketplaceSwitcher;
    private ICatalogBranding currentBranding = this.getDefaultBranding();
    protected boolean disableTabSelection;
    protected CatalogDescriptor lastSelection;
    private MarketplaceViewer.ContentType currentContentType;
    private MarketplaceViewer.ContentType previousContentType;
    private final List<ActionLink> actionLinks = new ArrayList<ActionLink>();
    private final Map<String, ActionLink> actions = new HashMap<String, ActionLink>();

    public MarketplacePage(MarketplaceCatalog catalog, MarketplaceCatalogConfiguration configuration) {
        super((Catalog)catalog);
        this.configuration = configuration;
        this.setDescription(Messages.MarketplacePage_selectSolutionsToInstall);
        this.setTitle(Messages.MarketplacePage_eclipseMarketplaceSolutions);
        this.updateTitle();
    }

    private void updateTitle() {
        if (this.configuration.getCatalogDescriptor() != null) {
            this.setTitle(this.configuration.getCatalogDescriptor().getLabel());
        }
    }

    public void createControl(Composite parent) {
        this.currentBranding = this.getDefaultBranding();
        boolean needSwitchMarketplaceControl = this.configuration.getCatalogDescriptors().size() > 1;
        StyleHelper styleHelper = new StyleHelper();
        Composite pageContent = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(1).spacing(0, 5).applyTo(pageContent);
        styleHelper.on((Widget)pageContent).setId("MarketplacePage");
        this.tabFolder = new CTabFolder(pageContent, 0x800880);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)this.tabFolder);
        MarketplacePage.setTabFolderAlwaysHighlight(this.tabFolder);
        super.createControl((Composite)this.tabFolder);
        this.tabContent = this.getControl();
        styleHelper.on((Widget)this.tabContent).setId("MarketplaceContent");
        Color selectionBackground = this.tabFolder.getSelectionBackground();
        this.tabContent.setBackground(selectionBackground);
        this.tabContent.addPaintListener(e -> {
            Control control = (Control)e.widget;
            Color currentSelectionBackground = this.tabFolder.getSelectionBackground();
            Color currentBackground = control.getBackground();
            if (currentBackground != currentSelectionBackground && !currentBackground.equals((Object)currentSelectionBackground)) {
                control.setBackground(currentSelectionBackground);
            }
        });
        this.searchTabItem = this.createCatalogTab(-1, MarketplaceViewer.ContentType.SEARCH, WIDGET_ID_TAB_SEARCH, this.currentBranding.getSearchTabName());
        this.recentTabItem = this.createCatalogTab(-1, MarketplaceViewer.ContentType.RECENT, WIDGET_ID_TAB_RECENT, this.currentBranding.getRecentTabName());
        this.popularTabItem = this.createCatalogTab(-1, MarketplaceViewer.ContentType.POPULAR, WIDGET_ID_TAB_POPULAR, this.currentBranding.getPopularTabName());
        this.favoritedTabItem = this.createCatalogTab(-1, MarketplaceViewer.ContentType.FAVORITES, WIDGET_ID_TAB_FAVORITES, this.getFavoritedTabName(this.currentBranding));
        this.installedTabItem = this.createCatalogTab(-1, MarketplaceViewer.ContentType.INSTALLED, WIDGET_ID_TAB_INSTALLED, Messages.MarketplacePage_installed);
        this.updateNewsTab();
        this.searchTabItem.setControl(this.tabContent);
        this.tabFolder.setSelection(this.searchTabItem);
        int defaultTabHeight = this.tabFolder.getTabHeight();
        this.tabFolder.setTabHeight(defaultTabHeight + 4);
        this.tabFolder.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (e.item.isDisposed()) {
                    return;
                }
                MarketplacePage.this.setActiveTab((CTabItem)e.item);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.contentListLinks = new Link(pageContent, 0);
        this.contentListLinks.setToolTipText(Messages.MarketplacePage_showSelection);
        this.contentListLinks.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                String actionId = e.text;
                ActionLink actionLink = (ActionLink)MarketplacePage.this.actions.get(actionId);
                if (actionLink != null) {
                    actionLink.selected();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        GridDataFactory.swtDefaults().align(0x1000000, 0x1000000).applyTo((Control)this.contentListLinks);
        this.updateSelectionLink();
        if (needSwitchMarketplaceControl) {
            this.createMarketplaceSwitcher(pageContent);
        }
        this.updateBranding();
        this.getViewer().addSelectionChangedListener(new ISelectionChangedListener(){
            private int previousSelectionSize = 0;

            public void selectionChanged(SelectionChangedEvent event) {
                if (!MarketplacePage.this.isCurrentPage()) {
                    return;
                }
                SelectionModel selectionModel = MarketplacePage.this.getWizard().getSelectionModel();
                int newSelectionSize = selectionModel.getItemToSelectedOperation().size();
                if (!event.getSelection().isEmpty() && this.previousSelectionSize == 0 && newSelectionSize > 0 && selectionModel.computeProvisioningOperationViableForFeatureSelection()) {
                    MarketplacePage.this.showNextPage();
                }
                this.previousSelectionSize = newSelectionSize;
            }
        });
        this.getViewer().addPropertyChangeListener(event -> {
            if (event.getProperty().equals(MarketplaceViewer.CONTENT_TYPE_PROPERTY) && event.getNewValue() != null) {
                this.setActiveTab((MarketplaceViewer.ContentType)((Object)((Object)event.getNewValue())));
            }
        });
        this.setControl((Control)pageContent);
        if (!this.tabContent.isDisposed()) {
            MarketplaceClientUi.setDefaultHelp(this.tabContent);
        }
        styleHelper.on((Widget)pageContent).applyStyles();
    }

    private static void setTabFolderAlwaysHighlight(final CTabFolder tabFolder) {
        Field highlightField;
        try {
            highlightField = CTabFolder.class.getDeclaredField("highlight");
            highlightField.setAccessible(true);
        }
        catch (Exception ex) {
            return;
        }
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                try {
                    Object wasHighlight = highlightField.get(tabFolder);
                    highlightField.set(tabFolder, true);
                    if (!Boolean.TRUE.equals(wasHighlight)) {
                        tabFolder.redraw();
                    }
                }
                catch (Exception ex) {
                    tabFolder.removeListener(27, (Listener)this);
                }
            }
        };
        tabFolder.addListener(27, listener);
    }

    protected void showNextPage() {
        IWizardContainer container = this.getContainer();
        if (container == null) {
            return;
        }
        IWizardPage currentPage = container.getCurrentPage();
        if (currentPage == this && currentPage.isPageComplete()) {
            IWizardPage nextPage = this.getNextPage();
            if (nextPage != null && nextPage instanceof FeatureSelectionWizardPage) {
                ((FeatureSelectionWizardPage)nextPage).setPageComplete(true);
            }
            container.showPage(nextPage);
        }
    }

    public boolean canFlipToNextPage() {
        MarketplaceWizard wizard;
        if (this.isPageComplete() && (wizard = this.getWizard()) != null) {
            return wizard.getNextPageInList((IWizardPage)this) != null;
        }
        return false;
    }

    protected boolean canSkipFeatureSelection() {
        SelectionModel selectionModel = this.getWizard().getSelectionModel();
        Map<CatalogItem, Operation> selectedOperations = selectionModel.getItemToSelectedOperation();
        Set<Map.Entry<CatalogItem, Operation>> entrySet = selectedOperations.entrySet();
        Operation mode = null;
        for (Map.Entry<CatalogItem, Operation> entry : entrySet) {
            if (!(entry.getKey() instanceof MarketplaceNodeCatalogItem)) {
                return false;
            }
            MarketplaceNodeCatalogItem item = (MarketplaceNodeCatalogItem)entry.getKey();
            Operation value = entry.getValue();
            switch (value) {
                case NONE: {
                    break;
                }
                case INSTALL: 
                case UPDATE: {
                    if (mode == null) {
                        mode = Operation.INSTALL;
                    } else if (mode == Operation.UNINSTALL) {
                        return false;
                    }
                    if (!this.hasOptionalFeatures(item)) break;
                    return false;
                }
                case UNINSTALL: {
                    if (mode == null) {
                        mode = Operation.UNINSTALL;
                    } else if (mode == Operation.INSTALL) {
                        return false;
                    }
                    if (!this.hasOptionalFeatures(item)) break;
                    return false;
                }
                case CHANGE: {
                    return false;
                }
            }
        }
        return mode != null;
    }

    private boolean hasOptionalFeatures(MarketplaceNodeCatalogItem item) {
        List<MarketplaceNodeInstallableUnitItem> installableUnitItems = item.getInstallableUnitItems();
        if (installableUnitItems.size() > 1) {
            for (MarketplaceNodeInstallableUnitItem iuItem : installableUnitItems) {
                if (!iuItem.isOptional()) continue;
                return true;
            }
        }
        return false;
    }

    private void setActiveTab(CTabItem tab) {
        CTabItem tabItem;
        if (this.disableTabSelection) {
            return;
        }
        if (tab == this.newsTabItem) {
            INews news = this.getNews();
            if (news == null) {
                this.setActiveTab(this.currentContentType != null ? this.currentContentType : (this.previousContentType != null ? this.previousContentType : MarketplaceViewer.ContentType.SEARCH));
                this.updateNewsTab();
                return;
            }
            boolean wasUpdated = this.newsViewer.isUpdated(news);
            this.newsViewer.showNews(news);
            if (wasUpdated) {
                this.updateBranding();
                CTabItem currentTabItem = this.getSelectedTabItem();
                if (currentTabItem != this.newsTabItem) {
                    this.tabFolder.setSelection(this.newsTabItem);
                    this.getControl().getDisplay().asyncExec(() -> this.tabFolder.setSelection(this.newsTabItem));
                }
            }
            return;
        }
        MarketplaceViewer.ContentType currentContentType = this.getViewer().getContentType();
        if (currentContentType != null && (tabItem = this.getTabItem(currentContentType)) == tab) {
            this.setActiveTab(currentContentType);
            return;
        }
        MarketplaceViewer.ContentType[] contentTypeArray = MarketplaceViewer.ContentType.values();
        int n = contentTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            MarketplaceViewer.ContentType contentType = contentTypeArray[n2];
            if (this.getTabItem(contentType) == tab) {
                this.setActiveTab(contentType);
                return;
            }
            ++n2;
        }
        throw new IllegalArgumentException(tab.getText());
    }

    public void setPreviouslyActiveTab() {
        if (this.previousContentType == null) {
            this.setActiveTab(this.tabFolder.getItem(0));
        } else {
            this.setActiveTab(this.previousContentType);
        }
    }

    public void setActiveTab(MarketplaceViewer.ContentType contentType) {
        if (this.disableTabSelection) {
            return;
        }
        boolean showSelected = false;
        if (contentType == MarketplaceViewer.ContentType.SELECTION) {
            showSelected = true;
            contentType = MarketplaceViewer.ContentType.SEARCH;
        }
        if (contentType != this.currentContentType) {
            this.previousContentType = this.currentContentType;
            this.currentContentType = contentType;
        }
        CTabItem tabItem = this.getTabItem(contentType);
        CTabItem currentTabItem = this.getSelectedTabItem();
        if (currentTabItem != tabItem) {
            if (currentTabItem.getControl() == this.tabContent) {
                currentTabItem.setControl(null);
            }
            this.tabFolder.setSelection(tabItem);
        }
        tabItem.setControl(null);
        if (this.tabContent != null && !this.tabContent.isDisposed()) {
            tabItem.setControl(this.tabContent);
        }
        if (this.previousContentType != contentType) {
            this.contentTypeChanged(this.previousContentType, contentType);
        }
        if (showSelected) {
            this.getViewer().showSelected();
        } else {
            this.getViewer().setContentType(contentType);
        }
    }

    private void contentTypeChanged(MarketplaceViewer.ContentType previousContentType, MarketplaceViewer.ContentType contentType) {
        this.actionLinks.clear();
        this.actions.clear();
        if (this.selectionLink != null) {
            this.doAddActionLink(0, this.selectionLink);
        }
        if (contentType == MarketplaceViewer.ContentType.FAVORITES) {
            this.doAddActionLink(-1, new ImportFavoritesActionLink(this));
            this.doAddActionLink(-1, new InstallAllActionLink(this));
        }
        this.updateContentListLinks();
    }

    public MarketplaceViewer.ContentType getActiveTab() {
        CTabItem selectedTabItem = this.getSelectedTabItem();
        return selectedTabItem == null ? null : this.getContentType(selectedTabItem);
    }

    private MarketplaceViewer.ContentType getContentType(CTabItem tabItem) {
        Object data;
        if (tabItem != null && !tabItem.isDisposed() && (data = tabItem.getData(CONTENT_TYPE_KEY)) instanceof MarketplaceViewer.ContentType) {
            return (MarketplaceViewer.ContentType)((Object)data);
        }
        return null;
    }

    private CTabItem getSelectedTabItem() {
        int currentTabIndex = this.tabFolder.getSelectionIndex();
        CTabItem currentTabItem = null;
        if (currentTabIndex != -1) {
            currentTabItem = this.tabFolder.getItem(currentTabIndex);
        }
        return currentTabItem;
    }

    private CTabItem getTabItem(MarketplaceViewer.ContentType content) {
        switch (content) {
            case INSTALLED: {
                return this.installedTabItem;
            }
            case FEATURED_MARKET: {
                return this.featuredMarketTabItem;
            }
            case POPULAR: {
                return this.popularTabItem;
            }
            case RECENT: {
                return this.recentTabItem;
            }
            case SEARCH: {
                return this.searchTabItem;
            }
            case RELATED: {
                return this.relatedTabItem;
            }
            case SELECTION: {
                return this.searchTabItem;
            }
            case FAVORITES: {
                return this.favoritedTabItem;
            }
        }
        throw new IllegalArgumentException();
    }

    private CTabItem createCatalogTab(int index, MarketplaceViewer.ContentType contentType, String widgetId, String label) {
        return this.createTab(index, contentType, widgetId, label, null);
    }

    private CTabItem createTab(int index, MarketplaceViewer.ContentType contentType, String widgetId, String label, Control tabControl) {
        CTabItem tabItem = index == -1 ? new CTabItem(this.tabFolder, 0) : new CTabItem(this.tabFolder, 0, index);
        tabItem.setData(WIDGET_ID_KEY, (Object)widgetId);
        tabItem.setData(CONTENT_TYPE_KEY, (Object)contentType);
        tabItem.setText(label);
        tabItem.setControl(tabControl);
        return tabItem;
    }

    private void createNewsTab() {
        this.newsTabItem = new CTabItem(this.tabFolder, 1);
        this.newsTabItem.setText(Messages.MarketplacePage_DefaultNewsTitle);
        this.newsTabItem.setData(WIDGET_ID_KEY, (Object)WIDGET_ID_TAB_NEWS);
        if (this.newsViewer == null || this.newsViewer.getControl().isDisposed()) {
            this.createNewsViewer((Composite)this.tabFolder);
        }
        this.newsTabItem.setControl(this.newsViewer.getControl());
    }

    private void updateNewsTab() {
        INews news;
        if (this.newsTabItem == null) {
            this.createNewsTab();
        }
        if ((news = this.getNews()) == null) {
            if (!this.newsTabItem.isDisposed()) {
                this.newsTabItem.dispose();
            }
            return;
        }
        if (this.newsTabItem.isDisposed()) {
            this.createNewsTab();
        }
        if (news.getShortTitle() != null && news.getShortTitle().length() > 0) {
            String title;
            String tooltip = title = news.getShortTitle().replace("&", "&&");
            if (title.length() > 40) {
                tooltip = title;
                title = String.valueOf(title.substring(0, 39)) + '\u2026';
            }
            this.newsTabItem.setText(title);
            this.newsTabItem.setToolTipText(tooltip);
        }
        this.updateNewsStatus();
    }

    private void updateNewsStatus() {
        INews news = this.getNews();
        Image tabImage = null;
        if (news != null && this.newsViewer.isUpdated(news)) {
            tabImage = MarketplaceClientUiPlugin.getInstance().getImageRegistry().get("NEWS_ICON_UPDATE");
        }
        this.newsTabItem.setImage(tabImage);
        this.newsTabItem.getParent().layout();
    }

    private INews getNews() {
        CatalogDescriptor descriptor = this.configuration.getCatalogDescriptor();
        INews news = CatalogRegistry.getInstance().getCatalogNews(descriptor);
        return news;
    }

    private void createNewsViewer(Composite parent) {
        this.newsViewer = new NewsViewer(this.getWizard());
        this.newsViewer.createControl(parent);
    }

    private void createMarketplaceSwitcher(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setBackgroundMode(1);
        composite.setLayout((Layout)new FillLayout());
        composite.setData("CSS_SUPPORTS_BORDERS", (Object)true);
        StyleHelper styleHelper = new StyleHelper();
        styleHelper.on((Widget)composite).setId("switcher-parent");
        CatalogSwitcher switcher = new CatalogSwitcher(composite, MarketplaceClientUi.useNativeBorders() ? 2048 : 0, this.configuration);
        switcher.addSelectionChangedListener(event -> {
            CatalogDescriptor descriptor = (CatalogDescriptor)((IStructuredSelection)event.getSelection()).getFirstElement();
            this.showMarketplace(descriptor);
        });
        CatalogDescriptor selectedDescriptor = this.configuration.getCatalogDescriptor();
        if (selectedDescriptor != null) {
            switcher.setSelection((ISelection)new StructuredSelection((Object)selectedDescriptor));
            this.lastSelection = selectedDescriptor;
        }
        styleHelper.on((Widget)switcher).setId("MarketplaceSwitcher");
        this.marketplaceSwitcher = switcher;
        GridDataFactory.fillDefaults().align(4, 4).grab(true, false).minSize(1, -1).hint(500, -1).applyTo((Control)composite);
    }

    private void updateContentListLinks() {
        if (this.contentListLinks != null) {
            String originalText = this.contentListLinks.getText();
            StringBuilder bldr = new StringBuilder();
            boolean first = true;
            for (ActionLink actionLink : this.actionLinks) {
                if (first) {
                    first = false;
                } else {
                    bldr.append(" | ");
                }
                bldr.append(NLS.bind((String)"<a href=\"{0}\">{1}</a>", (Object)actionLink.getId(), (Object)actionLink.getLabel()));
            }
            String text = bldr.toString();
            if (!text.equals(originalText)) {
                this.contentListLinks.setText(text);
                this.contentListLinks.getParent().layout(true, false);
            }
        }
    }

    private void updateSelectionLink() {
        if (this.contentListLinks != null) {
            String originalText = this.selectionLink == null ? "" : this.selectionLink.getLabel();
            String text = "";
            int count = this.getWizard().getSelectionModel().getItemToSelectedOperation().size();
            if (count == 1) {
                text = Messages.MarketplacePage_linkShowSelection_One;
            } else if (count > 0) {
                text = NLS.bind((String)Messages.MarketplacePage_linkShowSelection_Multiple, (Object)count);
            }
            if (!text.equals(originalText)) {
                if (text.equals("")) {
                    if (this.selectionLink != null) {
                        this.removeActionLink(this.selectionLink);
                        this.selectionLink = null;
                        this.removeActionLink(this.deselectLink);
                        this.deselectLink = null;
                    }
                } else {
                    ActionLink newSelectionLink = this.createSelectionLink(text);
                    if (this.selectionLink != null) {
                        this.updateActionLink(this.selectionLink, newSelectionLink);
                    } else {
                        this.addActionLink(0, newSelectionLink);
                        this.deselectLink = this.createDeselectionLink();
                        this.addActionLink(1, this.deselectLink);
                    }
                    this.selectionLink = newSelectionLink;
                }
            }
        }
    }

    private ActionLink createDeselectionLink() {
        return new ActionLink("clearSelection", Messages.MarketplacePage_DeselectAll, Messages.MarketplacePage_DeselectAllTooltip){

            @Override
            public void selected() {
                MarketplacePage.this.deselectionLinkActivated();
            }
        };
    }

    private ActionLink createSelectionLink(String text) {
        return new ActionLink("showSelection", text, Messages.MarketplacePage_showSelection){

            @Override
            public void selected() {
                MarketplacePage.this.selectionLinkActivated();
            }
        };
    }

    protected void selectionLinkActivated() {
        this.setActiveTab(MarketplaceViewer.ContentType.SELECTION);
    }

    protected void deselectionLinkActivated() {
        SelectionModel selectionModel = this.getWizard().getSelectionModel();
        selectionModel.clear();
        this.getWizard().updateSelection();
    }

    public IWizardPage getPreviousPage() {
        return super.getPreviousPage();
    }

    public MarketplaceWizard getWizard() {
        return (MarketplaceWizard)super.getWizard();
    }

    protected MarketplaceViewer getViewer() {
        return (MarketplaceViewer)super.getViewer();
    }

    protected CatalogViewer doCreateViewer(Composite parent) {
        MarketplaceViewer viewer = new MarketplaceViewer(this.getCatalog(), (IShellProvider)this, this.getWizard());
        viewer.setMinimumHeight(480);
        viewer.createControl(parent);
        Composite viewerPanel = (Composite)viewer.getControl();
        viewerPanel.setBackgroundMode(1);
        GridLayoutFactory.fillDefaults().extendedMargins(2, 2, 2, 2).applyTo(viewerPanel);
        return viewer;
    }

    protected void doUpdateCatalog() {
        if (!this.updated) {
            this.updated = true;
            Display.getCurrent().asyncExec(() -> {
                if (!this.getControl().isDisposed() && this.isCurrentPage()) {
                    this.safeUpdateCatalog();
                }
            });
        }
    }

    private void safeUpdateCatalog() {
        try {
            this.getWizard().updateNews();
            if (this.getControl().isDisposed()) {
                return;
            }
            this.getViewer().updateCatalog();
            if (this.getControl().isDisposed()) {
                return;
            }
            this.updateBranding();
        }
        catch (SWTException ex) {
            if (ex.code == 24) {
                return;
            }
            throw ex;
        }
    }

    public void setVisible(boolean visible) {
        if (visible) {
            CatalogDescriptor catalogDescriptor = this.configuration.getCatalogDescriptor();
            if (catalogDescriptor != null) {
                this.setTitle(catalogDescriptor.getLabel());
            }
            if (this.previousCatalogDescriptor == null || !this.previousCatalogDescriptor.equals(catalogDescriptor)) {
                this.previousCatalogDescriptor = catalogDescriptor;
                this.tabFolder.setSelection(this.searchTabItem);
                this.getViewer().setContentType(MarketplaceViewer.ContentType.SEARCH);
                this.getWizard().initializeCatalog();
                this.updated = false;
            }
        }
        super.setVisible(visible);
    }

    public void setPageComplete(boolean complete) {
        MarketplaceWizard wizard = this.getWizard();
        if (wizard != null) {
            if (complete) {
                complete = wizard.getSelectionModel().computeProvisioningOperationViableForFeatureSelection();
            }
            if (wizard.getContainer() != null) {
                this.computeMessages();
            }
        }
        super.setPageComplete(complete);
    }

    private void computeMessages() {
        this.computeStatusMessage();
        this.updateSelectionLink();
    }

    private void computeStatusMessage() {
        IStatus viability;
        String message = null;
        int messageType = 0;
        if (this.getWizard() != null && (viability = this.getWizard().getSelectionModel().computeProvisioningOperationViability()) != null) {
            message = viability.getMessage();
            messageType = Util.computeMessageType(viability);
        }
        this.setMessage(message, messageType);
    }

    public void performHelp() {
        this.getControl().notifyListeners(28, new Event());
    }

    private void updateBranding() {
        ICatalogBranding branding;
        this.disableTabSelection = true;
        this.updateTitle();
        CatalogDescriptor descriptor = this.configuration.getCatalogDescriptor();
        ICatalogBranding oldBranding = this.currentBranding;
        ICatalogBranding iCatalogBranding = branding = descriptor == null ? null : descriptor.getCatalogBranding();
        if (branding == null) {
            branding = this.getDefaultBranding();
        }
        this.currentBranding = branding;
        CTabItem selectedTabItem = this.getSelectedTabItem();
        int tabIndex = 0;
        boolean hasTab = branding.hasSearchTab();
        this.searchTabItem = this.updateTab(this.searchTabItem, MarketplaceViewer.ContentType.SEARCH, WIDGET_ID_TAB_SEARCH, branding.getSearchTabName(), hasTab, oldBranding.hasSearchTab(), tabIndex);
        if (hasTab) {
            ++tabIndex;
        }
        hasTab = this.hasFeaturedMarketTab(branding);
        this.featuredMarketTabItem = this.updateTab(this.featuredMarketTabItem, MarketplaceViewer.ContentType.SEARCH, WIDGET_ID_TAB_FEATURED_MARKET, branding.getFeaturedMarketTabName(), hasTab, this.hasFeaturedMarketTab(oldBranding), tabIndex);
        if (hasTab) {
            ++tabIndex;
        }
        hasTab = branding.hasRecentTab();
        this.recentTabItem = this.updateTab(this.recentTabItem, MarketplaceViewer.ContentType.SEARCH, WIDGET_ID_TAB_RECENT, branding.getRecentTabName(), hasTab, oldBranding.hasRecentTab(), tabIndex);
        if (hasTab) {
            ++tabIndex;
        }
        hasTab = branding.hasPopularTab();
        this.popularTabItem = this.updateTab(this.popularTabItem, MarketplaceViewer.ContentType.SEARCH, WIDGET_ID_TAB_POPULAR, branding.getPopularTabName(), hasTab, oldBranding.hasPopularTab(), tabIndex);
        if (hasTab) {
            ++tabIndex;
        }
        hasTab = branding.hasRelatedTab();
        this.relatedTabItem = this.updateTab(this.relatedTabItem, MarketplaceViewer.ContentType.SEARCH, WIDGET_ID_TAB_RELATED, branding.getRelatedTabName(), hasTab, oldBranding.hasRelatedTab(), tabIndex);
        if (hasTab) {
            ++tabIndex;
        }
        hasTab = this.hasFavoritedTab(branding);
        this.favoritedTabItem = this.updateTab(this.favoritedTabItem, MarketplaceViewer.ContentType.SEARCH, WIDGET_ID_TAB_FAVORITES, this.getFavoritedTabName(branding), hasTab, this.hasFavoritedTab(oldBranding), tabIndex);
        if (hasTab) {
            ++tabIndex;
        }
        this.updateNewsTab();
        if (selectedTabItem == null || selectedTabItem.isDisposed()) {
            this.tabFolder.setSelection(0);
        }
        this.tabFolder.setFocus();
        final ImageDescriptor defaultWizardIconDescriptor = DiscoveryImages.BANNER_DISOVERY;
        if (branding.getWizardIcon() == null) {
            this.setImageDescriptor(defaultWizardIconDescriptor);
        } else {
            final Display display = Display.getCurrent();
            MarketplaceClientUiPlugin.getInstance().getResourceProvider().provideResource(new ResourceProvider.ResourceReceiver<ImageDescriptor>(){

                @Override
                public ImageDescriptor processResource(URL resource) {
                    return ImageDescriptor.createFromURL((URL)resource);
                }

                @Override
                public void setResource(ImageDescriptor resource) {
                    display.asyncExec(() -> {
                        try {
                            MarketplacePage.this.setImageDescriptor(resource);
                        }
                        catch (SWTException ex) {
                            MarketplacePage.this.setImageDescriptor(defaultWizardIconDescriptor);
                        }
                    });
                }
            }, branding.getWizardIcon(), defaultWizardIconDescriptor);
        }
        this.disableTabSelection = false;
    }

    private boolean hasFavoritedTab(ICatalogBranding branding) {
        IUserFavoritesService favoritesService;
        if (branding.hasFavoritesTab()) {
            return true;
        }
        CatalogDescriptor catalogDescriptor = this.configuration.getCatalogDescriptor();
        if (catalogDescriptor == null) {
            return false;
        }
        URL url = catalogDescriptor.getUrl();
        IUserFavoritesService iUserFavoritesService = favoritesService = url == null ? null : ServiceHelper.getMarketplaceServiceLocator().getFavoritesService(url.toString());
        return favoritesService != null;
    }

    private String getFavoritedTabName(ICatalogBranding branding) {
        String favoritesTabName = branding.getFavoritesTabName();
        if (favoritesTabName == null) {
            return Messages.MarketplacePage_favorites;
        }
        return favoritesTabName;
    }

    private boolean hasFeaturedMarketTab(ICatalogBranding branding) {
        String marketName;
        if (branding.hasFeaturedMarketTab() && (marketName = branding.getFeaturedMarketTabName()) != null && marketName.length() > 0) {
            List<IMarket> markets = this.getCatalog().getMarkets();
            for (IMarket market : markets) {
                if (!marketName.equals(market.getName())) continue;
                return true;
            }
        }
        return false;
    }

    private CTabItem updateTab(CTabItem tabItem, MarketplaceViewer.ContentType contentType, String widgetId, String tabLabel, boolean hasTab, boolean hadTab, int tabIndex) {
        if (hasTab) {
            if (!hadTab) {
                tabItem = this.createCatalogTab(tabIndex, contentType, widgetId, tabLabel);
            } else {
                tabItem.setText(tabLabel);
            }
        } else if (tabItem != null && !tabItem.isDisposed()) {
            tabItem.dispose();
        }
        return tabItem;
    }

    private ICatalogBranding getDefaultBranding() {
        CatalogBranding branding = new CatalogBranding();
        branding.setHasSearchTab(true);
        branding.setHasPopularTab(true);
        branding.setHasRecentTab(true);
        branding.setHasRelatedTab(false);
        branding.setHasFavoritesTab(false);
        branding.setHasFeaturedMarketTab(false);
        branding.setSearchTabName(Messages.MarketplacePage_search);
        branding.setPopularTabName(Messages.MarketplacePage_popular);
        branding.setRecentTabName(Messages.MarketplacePage_recent);
        branding.setRelatedTabName(Messages.MarketplacePage_related);
        branding.setFeaturedMarketTabName(Messages.MarketplacePage_featuredMarket);
        branding.setFavoritesTabName(Messages.MarketplacePage_favorites);
        branding.setWizardTitle(Messages.MarketplacePage_eclipseMarketplaceSolutions);
        branding.setWizardIcon(null);
        return branding;
    }

    public IStatus showMarketplace(CatalogDescriptor catalogDescriptor) {
        if (this.configuration.getCatalogDescriptor() != catalogDescriptor) {
            if (this.getWizard().getSelectionModel().getSelectedCatalogItems().size() > 0) {
                boolean discardSelection = MessageDialog.openConfirm((Shell)this.getShell(), (String)Messages.MarketplacePage_selectionSolutions, (String)Messages.MarketplacePage_discardPendingSolutions);
                if (discardSelection) {
                    this.getWizard().getSelectionModel().clear();
                    this.updateSelectionLink();
                } else {
                    if (this.marketplaceSwitcher != null) {
                        if (this.lastSelection == null) {
                            this.lastSelection = this.configuration.getCatalogDescriptor();
                        }
                        this.marketplaceSwitcher.setSelection((ISelection)new StructuredSelection((Object)this.lastSelection));
                    }
                    return Status.CANCEL_STATUS;
                }
            }
            this.lastSelection = catalogDescriptor;
            this.configuration.setCatalogDescriptor(catalogDescriptor);
            if (this.marketplaceSwitcher != null) {
                this.marketplaceSwitcher.setSelection((ISelection)new StructuredSelection((Object)catalogDescriptor));
            }
            this.updateCatalog();
        }
        return Status.OK_STATUS;
    }

    private void updateCatalog() {
        try {
            this.getContainer().run(false, true, monitor -> {
                if (this.getViewer().getControl().isDisposed()) {
                    return;
                }
                this.getWizard().initializeCatalog();
                this.safeUpdateCatalog();
            });
        }
        catch (InvocationTargetException e) {
            MarketplaceClientUi.error(e.getCause());
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void showNews(CatalogDescriptor catalogDescriptor) {
        IStatus proceed = Status.OK_STATUS;
        if (catalogDescriptor != null) {
            proceed = this.showMarketplace(catalogDescriptor);
        }
        if (proceed.isOK()) {
            this.setActiveTab(this.newsTabItem);
        }
    }

    public void show(CatalogDescriptor catalogDescriptor, MarketplaceViewer.ContentType content) {
        IStatus proceed = Status.OK_STATUS;
        if (catalogDescriptor != null) {
            proceed = this.showMarketplace(catalogDescriptor);
        }
        if (proceed.isOK()) {
            this.setActiveTab(content);
        }
    }

    public void show(CatalogDescriptor catalogDescriptor, Set<? extends INode> nodes) {
        IStatus proceed = Status.OK_STATUS;
        if (catalogDescriptor != null) {
            proceed = this.showMarketplace(catalogDescriptor);
        }
        if (proceed.isOK()) {
            this.setActiveTab(this.searchTabItem);
            this.getViewer().show(nodes);
        }
    }

    public void search(CatalogDescriptor catalogDescriptor, IMarket searchMarket, ICategory searchCategory, String searchString) {
        IStatus proceed = Status.OK_STATUS;
        if (catalogDescriptor != null) {
            proceed = this.showMarketplace(catalogDescriptor);
        }
        if (proceed.isOK()) {
            this.setActiveTab(this.searchTabItem);
            this.getViewer().search(searchMarket, searchCategory, searchString);
        }
    }

    protected void initialize(MarketplaceWizard.WizardState initialState) {
        MarketplaceViewer.ContentType contentType = initialState.getContentType();
        if (contentType != null && contentType != MarketplaceViewer.ContentType.SEARCH) {
            this.show(this.configuration.getCatalogDescriptor(), contentType);
        } else if (initialState.getContent() != null && !initialState.getContent().isEmpty()) {
            this.show(this.configuration.getCatalogDescriptor(), initialState.getContent());
        } else {
            IMarket market = initialState.getFilterMarket();
            ICategory category = initialState.getFilterCategory();
            String query = initialState.getFilterQuery();
            if (market != null || category != null || query != null) {
                this.search(this.configuration.getCatalogDescriptor(), market, category, query);
            }
        }
    }

    protected void addActionLink(int pos, ActionLink actionLink) {
        this.doAddActionLink(pos, actionLink);
        this.updateContentListLinks();
    }

    private void doAddActionLink(int pos, ActionLink actionLink) {
        ActionLink existingAction = this.actions.get(actionLink.getId());
        if (existingAction != null && existingAction != actionLink) {
            throw new IllegalArgumentException();
        }
        int insertIndex = pos == -1 || pos > this.actionLinks.size() ? this.actionLinks.size() : pos;
        this.actionLinks.add(insertIndex, actionLink);
        this.actions.put(actionLink.getId(), actionLink);
    }

    protected void removeActionLink(ActionLink actionLink) {
        this.doRemoveActionLink(actionLink);
        this.updateContentListLinks();
    }

    private void doRemoveActionLink(ActionLink actionLink) {
        this.actionLinks.remove(actionLink);
        if (this.actions.get(actionLink.getId()) == actionLink) {
            this.actions.remove(actionLink.getId());
        }
    }

    protected void updateActionLink(ActionLink oldLink, ActionLink newLink) {
        if (oldLink == newLink) {
            return;
        }
        this.doUpdateActionLink(oldLink, newLink);
        this.updateContentListLinks();
    }

    private void doUpdateActionLink(ActionLink oldLink, ActionLink newLink) {
        String id;
        int index = this.actionLinks.indexOf(oldLink);
        if (index != -1) {
            id = oldLink.getId();
            if (this.actions.get(id) != oldLink) {
                throw new IllegalArgumentException();
            }
            if (!id.equals(newLink.getId())) {
                throw new IllegalArgumentException();
            }
        } else {
            throw new NoSuchElementException();
        }
        this.actionLinks.set(index, newLink);
        this.actions.put(id, newLink);
    }

    public MarketplaceCatalog getCatalog() {
        return (MarketplaceCatalog)super.getCatalog();
    }

    public void dispose() {
        if (this.marketplaceSwitcher != null) {
            this.marketplaceSwitcher.dispose();
        }
        super.dispose();
    }

    public void reloadCatalog() {
        this.getViewer().reload();
    }

    @Override
    public String getNextButtonLabel() {
        return Messages.MarketplaceWizardDialog_Install_Now;
    }

    @Override
    public String getBackButtonLabel() {
        return null;
    }
}

