/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.widgets.table.ui.nattable.internal.nattable;

import java.util.List;
import net.sourceforge.nattable.command.LayerCommandUtil;
import net.sourceforge.nattable.config.IConfigRegistry;
import net.sourceforge.nattable.coordinate.ColumnPositionCoordinate;
import net.sourceforge.nattable.layer.ILayer;
import net.sourceforge.nattable.layer.cell.LayerCell;
import net.sourceforge.nattable.painter.cell.ImagePainter;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.Column;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.FeatureColumn;
import org.eclipse.emf.facet.widgets.table.ui.nattable.internal.NatTableWidget;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.graphics.Image;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HeaderImagePainter
extends ImagePainter {
    private final NatTableWidget.BodyLayerStack bodyLayer;
    private final List<Column> columns;
    private final ILabelProvider labelProvider;

    public HeaderImagePainter(NatTableWidget.BodyLayerStack bodyLayer, List<Column> columns, ILabelProvider labelProvider) {
        super(null, false);
        this.bodyLayer = bodyLayer;
        this.columns = columns;
        this.labelProvider = labelProvider;
    }

    protected Image getImage(LayerCell cell, IConfigRegistry configRegistry) {
        ColumnPositionCoordinate converted = LayerCommandUtil.convertColumnPositionToTargetContext((ColumnPositionCoordinate)new ColumnPositionCoordinate(cell.getLayer(), cell.getColumnPosition()), (ILayer)this.bodyLayer.getBodyDataLayer());
        if (converted != null && converted.columnPosition >= 0 && converted.columnPosition < this.columns.size()) {
            return this.getColumnImage(this.columns.get(converted.columnPosition));
        }
        return null;
    }

    private Image getColumnImage(Column column) {
        if (column instanceof FeatureColumn) {
            FeatureColumn referenceColumn = (FeatureColumn)column;
            ETypedElement reference = referenceColumn.getFeature();
            return this.labelProvider.getImage((Object)reference);
        }
        return null;
    }
}

