/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.lucene;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.StringReader;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.lucene.geo.SimpleWKTShapeParser;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.BooleanLiteral;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.model.vocabulary.GEO;
import org.eclipse.rdf4j.model.vocabulary.GEOF;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.MalformedQueryException;
import org.eclipse.rdf4j.query.algebra.Var;
import org.eclipse.rdf4j.query.algebra.evaluation.QueryBindingSet;
import org.eclipse.rdf4j.query.algebra.evaluation.function.geosparql.SpatialAlgebra;
import org.eclipse.rdf4j.query.algebra.evaluation.function.geosparql.SpatialSupport;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.lucene.BindingSetCollection;
import org.eclipse.rdf4j.sail.lucene.BulkUpdater;
import org.eclipse.rdf4j.sail.lucene.DistanceQuerySpec;
import org.eclipse.rdf4j.sail.lucene.DocumentDistance;
import org.eclipse.rdf4j.sail.lucene.DocumentResult;
import org.eclipse.rdf4j.sail.lucene.DocumentScore;
import org.eclipse.rdf4j.sail.lucene.GeoRelationQuerySpec;
import org.eclipse.rdf4j.sail.lucene.PropertyCache;
import org.eclipse.rdf4j.sail.lucene.QuerySpec;
import org.eclipse.rdf4j.sail.lucene.SearchDocument;
import org.eclipse.rdf4j.sail.lucene.SearchFields;
import org.eclipse.rdf4j.sail.lucene.SearchIndex;
import org.eclipse.rdf4j.sail.lucene.SearchQueryEvaluator;
import org.eclipse.rdf4j.sail.lucene.util.MapOfListMaps;
import org.locationtech.spatial4j.context.SpatialContext;
import org.locationtech.spatial4j.io.ShapeReader;
import org.locationtech.spatial4j.shape.Point;
import org.locationtech.spatial4j.shape.Shape;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSearchIndex
implements SearchIndex {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ValueFactory vf = SimpleValueFactory.getInstance();
    private static final Set<String> REJECTED_DATATYPES = new HashSet<String>();
    protected int defaultNumDocs = -1;
    protected int maxDocs = Integer.MAX_VALUE;
    protected Set<String> wktFields = Collections.singleton(SearchFields.getPropertyField(GEO.AS_WKT));
    private Set<String> indexedLangs;
    private Map<IRI, Set<IRI>> indexedTypeMapping;

    @Override
    public void initialize(Properties parameters) throws Exception {
        String maxDocumentsParam = parameters.getProperty("maxDocuments");
        String defaultNumDocsParam = parameters.getProperty("defaultNumDocs");
        if (maxDocumentsParam != null) {
            this.maxDocs = Integer.parseInt(maxDocumentsParam);
            this.defaultNumDocs = defaultNumDocsParam != null ? Math.min(this.maxDocs, Integer.parseInt(defaultNumDocsParam)) : this.maxDocs;
        } else {
            this.maxDocs = Integer.MAX_VALUE;
            int n = this.defaultNumDocs = defaultNumDocsParam != null ? Integer.parseInt(defaultNumDocsParam) : -1;
        }
        if (this.defaultNumDocs > this.maxDocs) {
            throw new IllegalArgumentException("defaultNumDocs must be less than or equal to maxDocuments (" + this.defaultNumDocs + " > " + this.maxDocs + ")");
        }
        String wktFieldParam = parameters.getProperty("wktFields");
        if (wktFieldParam != null) {
            this.wktFields = Sets.newHashSet((Object[])wktFieldParam.split("\\s+"));
        }
        if (parameters.containsKey("indexedlang")) {
            String indexedlangString = parameters.getProperty("indexedlang");
            this.indexedLangs = new HashSet<String>();
            this.indexedLangs.addAll(Arrays.asList(indexedlangString.toLowerCase().split("\\s+")));
        }
        if (parameters.containsKey("indexedtypes")) {
            String indexedtypesString = parameters.getProperty("indexedtypes");
            Properties prop = new Properties();
            try (StringReader reader = new StringReader(indexedtypesString);){
                prop.load(reader);
            }
            catch (IOException e) {
                throw new SailException("Could read indexedtypes: " + indexedtypesString, (Throwable)e);
            }
            this.indexedTypeMapping = new HashMap<IRI, Set<IRI>>();
            for (Object key : prop.keySet()) {
                String keyStr = key.toString();
                HashSet<IRI> objects = new HashSet<IRI>();
                for (String obj : prop.getProperty(keyStr).split("\\s+")) {
                    objects.add(this.vf.createIRI(obj));
                }
                IRI keyIRI = keyStr.equals("a") ? RDF.TYPE : this.vf.createIRI(keyStr);
                this.indexedTypeMapping.put(keyIRI, objects);
            }
        }
    }

    protected abstract SpatialContext getSpatialContext(String var1);

    @Override
    public boolean accept(Literal literal) {
        if (literal == null) {
            return false;
        }
        if (literal.getDatatype() != null && REJECTED_DATATYPES.contains(literal.getDatatype().stringValue())) {
            return false;
        }
        return this.indexedLangs == null || !literal.getLanguage().isEmpty() && this.indexedLangs.contains(((String)literal.getLanguage().get()).toLowerCase());
    }

    @Override
    public boolean isGeoField(String fieldName) {
        return this.wktFields != null && this.wktFields.contains(fieldName);
    }

    @Override
    public boolean isTypeStatement(Statement statement) {
        return this.isTypeFilteringEnabled() && statement.getObject().isIRI() && this.indexedTypeMapping.get(statement.getPredicate()) != null;
    }

    @Override
    public boolean isTypeFilteringEnabled() {
        return this.indexedTypeMapping != null;
    }

    @Override
    public boolean isIndexedTypeStatement(Statement statement) {
        if (!this.isTypeFilteringEnabled() || !statement.getObject().isIRI()) {
            return false;
        }
        Set<IRI> objects = this.indexedTypeMapping.get(statement.getPredicate());
        return objects != null && objects.contains((IRI)statement.getObject());
    }

    @Override
    public Map<IRI, Set<IRI>> getIndexedTypeMapping() {
        return this.indexedTypeMapping;
    }

    @Override
    public final synchronized void addStatement(Statement statement) throws IOException {
        String contextId;
        String text = SearchFields.getLiteralPropertyValueAsString(statement);
        if (text == null) {
            return;
        }
        String field = SearchFields.getPropertyField(statement.getPredicate());
        String resourceId = SearchFields.getResourceID(statement.getSubject());
        String id = SearchFields.formIdString(resourceId, contextId = SearchFields.getContextID(statement.getContext()));
        SearchDocument document = this.getDocument(id);
        if (document == null) {
            document = this.newDocument(id, resourceId, contextId);
            this.addProperty(field, text, document);
            this.addDocument(document);
        } else if (!document.hasProperty(field, text)) {
            SearchDocument newDocument = this.copyDocument(document);
            this.addProperty(field, text, newDocument);
            this.updateDocument(newDocument);
        }
    }

    @Override
    public final synchronized void removeStatement(Statement statement) throws IOException {
        String fieldName;
        String contextId;
        String text = SearchFields.getLiteralPropertyValueAsString(statement);
        if (text == null) {
            return;
        }
        String resourceId = SearchFields.getResourceID(statement.getSubject());
        String id = SearchFields.formIdString(resourceId, contextId = SearchFields.getContextID(statement.getContext()));
        SearchDocument document = this.getDocument(id);
        if (document != null && document.hasProperty(fieldName = SearchFields.getPropertyField(statement.getPredicate()), text)) {
            int nrProperties = AbstractSearchIndex.countPropertyValues(document);
            if (nrProperties == 1) {
                this.deleteDocument(document);
            } else {
                SearchDocument newDocument = this.newDocument(id, resourceId, contextId);
                boolean mutated = this.copyDocument(newDocument, document, Collections.singletonMap(fieldName, Collections.singleton(text)));
                if (mutated) {
                    this.updateDocument(newDocument);
                }
            }
        }
    }

    @Override
    public final synchronized void addRemoveStatements(Collection<Statement> added, Collection<Statement> removed) throws IOException {
        MapOfListMaps<Resource, String, Statement> rsAdded = new MapOfListMaps<Resource, String, Statement>();
        MapOfListMaps<Resource, String, Statement> rsRemoved = new MapOfListMaps<Resource, String, Statement>();
        HashSet<Resource> resources = new HashSet<Resource>();
        for (Statement s : added) {
            rsAdded.add(s.getSubject(), SearchFields.getContextID(s.getContext()), s);
            resources.add(s.getSubject());
        }
        for (Statement s : removed) {
            rsRemoved.add(s.getSubject(), SearchFields.getContextID(s.getContext()), s);
            resources.add(s.getSubject());
        }
        this.logger.debug("Removing " + removed.size() + " statements, adding " + added.size() + " statements");
        BulkUpdater updater = this.newBulkUpdate();
        for (Resource resource : resources) {
            Map stmtsToRemove = rsRemoved.get(resource);
            Map stmtsToAdd = rsAdded.get(resource);
            HashSet contextsToUpdate = new HashSet(stmtsToAdd.keySet());
            contextsToUpdate.addAll(stmtsToRemove.keySet());
            HashMap<String, SearchDocument> docsByContext = new HashMap<String, SearchDocument>();
            String resourceId = SearchFields.getResourceID(resource);
            Iterable<? extends SearchDocument> documents = this.getDocuments(resourceId);
            for (SearchDocument searchDocument : documents) {
                docsByContext.put(searchDocument.getContext(), searchDocument);
            }
            for (String string : contextsToUpdate) {
                int nrProperties;
                String val;
                String id = SearchFields.formIdString(resourceId, string);
                SearchDocument document = (SearchDocument)docsByContext.get(string);
                if (document == null) {
                    document = this.newDocument(id, resourceId, string);
                    List list = stmtsToAdd.get(string);
                    if (list != null) {
                        for (Statement s : list) {
                            this.addProperty(s, document);
                        }
                    }
                    updater.add(document);
                    if (!stmtsToRemove.containsKey(string)) continue;
                    this.logger.info("Statements are marked to be removed that should not be in the store, for resource {} and context {}. Nothing done.", (Object)resource, (Object)string);
                    continue;
                }
                HashMap<String, Set<String>> removedOfResource = null;
                List removedStatements = stmtsToRemove.get(string);
                if (removedStatements != null && !removedStatements.isEmpty()) {
                    removedOfResource = new HashMap<String, Set<String>>();
                    for (Statement r : removedStatements) {
                        val = SearchFields.getLiteralPropertyValueAsString(r);
                        if (val == null) continue;
                        String field = SearchFields.getPropertyField(r.getPredicate());
                        Set removedValues = removedOfResource.computeIfAbsent(field, k -> new HashSet());
                        removedValues.add(val);
                    }
                }
                SearchDocument newDocument = this.newDocument(id, resourceId, string);
                boolean mutated = this.copyDocument(newDocument, document, removedOfResource);
                List addedToResource = stmtsToAdd.get(string);
                if (addedToResource != null && !addedToResource.isEmpty()) {
                    PropertyCache propertyCache = new PropertyCache(newDocument);
                    for (Statement s : addedToResource) {
                        String field;
                        val = SearchFields.getLiteralPropertyValueAsString(s);
                        if (val == null || propertyCache.hasProperty(field = SearchFields.getPropertyField(s.getPredicate()), val)) continue;
                        this.addProperty(s, newDocument);
                        mutated = true;
                    }
                }
                if ((nrProperties = AbstractSearchIndex.countPropertyValues(newDocument)) > 0) {
                    if (!mutated) continue;
                    updater.update(newDocument);
                    continue;
                }
                updater.delete(document);
            }
        }
        updater.end();
    }

    private boolean copyDocument(SearchDocument newDocument, SearchDocument document, Map<String, Set<String>> removedProperties) {
        boolean mutated = false;
        for (String oldFieldName : document.getPropertyNames()) {
            newDocument.addProperty(oldFieldName);
            List<String> oldValues = document.getProperty(oldFieldName);
            if (oldValues == null) continue;
            Set<String> objectsRemoved = removedProperties != null ? removedProperties.get(oldFieldName) : null;
            for (String oldValue : oldValues) {
                if (objectsRemoved != null && objectsRemoved.contains(oldValue)) {
                    mutated = true;
                    continue;
                }
                this.addProperty(oldFieldName, oldValue, newDocument);
            }
        }
        return mutated;
    }

    private static int countPropertyValues(SearchDocument document) {
        int numValues = 0;
        Collection<String> propertyNames = document.getPropertyNames();
        for (String propertyName : propertyNames) {
            List<String> propertyValues = document.getProperty(propertyName);
            if (propertyValues == null) continue;
            numValues += propertyValues.size();
        }
        return numValues;
    }

    @Override
    public final synchronized void addDocuments(Resource subject, List<Statement> statements) throws IOException {
        String resourceId = SearchFields.getResourceID(subject);
        HashMultimap stmtsByContextId = HashMultimap.create();
        for (Statement statement : statements) {
            String contextId = SearchFields.getContextID(statement.getContext());
            stmtsByContextId.put((Object)contextId, (Object)statement);
        }
        BulkUpdater batch = this.newBulkUpdate();
        for (Map.Entry entry : stmtsByContextId.asMap().entrySet()) {
            String id = SearchFields.formIdString(resourceId, (String)entry.getKey());
            SearchDocument document = this.newDocument(id, resourceId, (String)entry.getKey());
            for (Statement stmt : (Collection)entry.getValue()) {
                this.addProperty(stmt, document);
            }
            batch.add(document);
        }
        batch.end();
    }

    private void addProperty(Statement statement, SearchDocument document) {
        String value = SearchFields.getLiteralPropertyValueAsString(statement);
        if (value == null) {
            return;
        }
        String field = SearchFields.getPropertyField(statement.getPredicate());
        this.addProperty(field, value, document);
    }

    private void addProperty(String field, String value, SearchDocument document) {
        if (this.isGeoField(field)) {
            document.addGeoProperty(field, value);
        } else {
            document.addProperty(field, value);
        }
    }

    @Override
    public final Collection<BindingSet> evaluate(SearchQueryEvaluator evaluator) throws SailException {
        if (evaluator instanceof QuerySpec) {
            QuerySpec query = (QuerySpec)evaluator;
            Iterable<? extends DocumentScore> result = this.evaluateQuery(query);
            return this.generateBindingSets(query, result);
        }
        if (evaluator instanceof DistanceQuerySpec) {
            DistanceQuerySpec query = (DistanceQuerySpec)evaluator;
            Iterable<? extends DocumentDistance> result = this.evaluateQuery(query);
            return this.generateBindingSets(query, result);
        }
        if (evaluator instanceof GeoRelationQuerySpec) {
            GeoRelationQuerySpec query = (GeoRelationQuerySpec)evaluator;
            Iterable<? extends DocumentResult> result = this.evaluateQuery(query);
            return this.generateBindingSets(query, result);
        }
        throw new IllegalArgumentException("Unsupported " + SearchQueryEvaluator.class.getSimpleName() + ": " + evaluator.getClass().getName());
    }

    private Iterable<? extends DocumentScore> evaluateQuery(QuerySpec query) {
        Iterable<? extends DocumentScore> hits;
        block3: {
            hits = null;
            try {
                if (query.getQueryPatterns().stream().map(QuerySpec.QueryParam::getQuery).anyMatch(s -> !s.isEmpty())) {
                    hits = this.query(query.getSubject(), query);
                }
            }
            catch (Exception e) {
                this.logger.error("There was a problem evaluating query '{}'!", (Object)query.getCatQuery(), (Object)e);
                if ($assertionsDisabled) break block3;
                throw new AssertionError((Object)("There was a problem evaluating query '" + query.getCatQuery() + "'!"));
            }
        }
        return hits;
    }

    private BindingSetCollection generateBindingSets(QuerySpec query, Iterable<? extends DocumentScore> hits) throws SailException {
        String scoreVar;
        LinkedHashSet<BindingSet> bindingSets = new LinkedHashSet<BindingSet>();
        HashSet<String> bindingNames = new HashSet<String>();
        String matchVar = query.getMatchesVariableName();
        if (matchVar != null) {
            bindingNames.add(matchVar);
        }
        if ((scoreVar = query.getScoreVariableName()) != null) {
            bindingNames.add(scoreVar);
        }
        for (QuerySpec.QueryParam queryParam2 : query.getQueryPatterns()) {
            String propertyVar;
            String snippetVar = queryParam2.getSnippetVarName();
            if (snippetVar != null) {
                bindingNames.add(snippetVar);
            }
            if ((propertyVar = queryParam2.getPropertyVarName()) == null || queryParam2.getProperty() != null) continue;
            bindingNames.add(propertyVar);
        }
        if (hits != null) {
            for (DocumentScore documentScore : hits) {
                QueryBindingSet derivedBindings = new QueryBindingSet();
                SearchDocument doc = documentScore.getDocument();
                if (doc == null) continue;
                float score = documentScore.getScore();
                if (matchVar != null) {
                    Resource resource = this.getResource(doc);
                    derivedBindings.addBinding(matchVar, (Value)resource);
                }
                if (scoreVar != null && score > 0.0f) {
                    derivedBindings.addBinding(scoreVar, (Value)SearchFields.scoreToLiteral(score));
                }
                if (query.isHighlight()) {
                    if (documentScore.isHighlighted()) {
                        Set reducedSet = query.getQueryPatterns().stream().filter(QuerySpec.QueryParam::isHighlight).map(queryParam -> {
                            Collection<String> fields;
                            String snippetVar = queryParam.getSnippetVarName();
                            String propertyVar = queryParam.getPropertyVarName();
                            if (queryParam.getProperty() != null) {
                                String fieldname = SearchFields.getPropertyField(queryParam.getProperty());
                                fields = Collections.singleton(fieldname);
                            } else {
                                fields = doc.getPropertyNames();
                            }
                            HashSet<QueryBindingSet> paramBindings = new HashSet<QueryBindingSet>();
                            for (String field : fields) {
                                Iterable<String> snippets = hit.getSnippets(field);
                                if (snippets == null) continue;
                                for (String snippet : snippets) {
                                    if (snippet == null || snippet.isEmpty()) continue;
                                    QueryBindingSet snippetBindings = new QueryBindingSet();
                                    if (snippetVar != null) {
                                        snippetBindings.addBinding(snippetVar, (Value)this.vf.createLiteral(snippet));
                                    }
                                    if (propertyVar != null && queryParam.getProperty() == null) {
                                        snippetBindings.addBinding(propertyVar, (Value)this.vf.createIRI(field));
                                    }
                                    paramBindings.add(snippetBindings);
                                }
                            }
                            return paramBindings;
                        }).reduce(Set.of(derivedBindings), (bindingA, bindingB) -> {
                            if (bindingA.isEmpty()) {
                                return bindingB;
                            }
                            if (bindingB.isEmpty()) {
                                return bindingA;
                            }
                            HashSet<QueryBindingSet> paramBindings = new HashSet<QueryBindingSet>();
                            for (QueryBindingSet a : bindingA) {
                                for (QueryBindingSet b : bindingB) {
                                    QueryBindingSet binding = new QueryBindingSet((BindingSet)a);
                                    binding.addAll((BindingSet)b);
                                    paramBindings.add(binding);
                                }
                            }
                            return paramBindings;
                        });
                        bindingSets.addAll(reducedSet);
                        continue;
                    }
                    this.logger.warn("Lucene Query requests snippet, but no highlighter was generated for it, no snippets will be generated!\n{}", (Object)query);
                    bindingSets.add((BindingSet)derivedBindings);
                    continue;
                }
                bindingSets.add((BindingSet)derivedBindings);
            }
        }
        return new BindingSetCollection(bindingNames, bindingSets);
    }

    private Iterable<? extends DocumentDistance> evaluateQuery(DistanceQuerySpec query) {
        Iterable<? extends DocumentDistance> hits;
        block4: {
            hits = null;
            Literal from = query.getFrom();
            double distance = query.getDistance();
            IRI units = query.getUnits();
            IRI geoProperty = query.getGeoProperty();
            try {
                if (!GEO.WKT_LITERAL.equals((Object)from.getDatatype())) {
                    throw new MalformedQueryException("Unsupported datatype: " + String.valueOf(from.getDatatype()));
                }
                Shape shape = this.parseQueryPoint(SearchFields.getPropertyField(geoProperty), from.getLabel());
                if (!(shape instanceof Point)) {
                    throw new MalformedQueryException("Geometry literal is not a point: " + from.getLabel());
                }
                Point p = (Point)shape;
                hits = this.geoQuery(geoProperty, p, units, distance, query.getDistanceVar(), query.getContextVar());
            }
            catch (Exception e) {
                this.logger.error("There was a problem evaluating distance query 'within " + distance + AbstractSearchIndex.getUnitSymbol(units) + " of " + from.getLabel() + "'!", (Throwable)e);
                if ($assertionsDisabled) break block4;
                throw new AssertionError((Object)("There was a problem evaluating distance query 'within " + distance + AbstractSearchIndex.getUnitSymbol(units) + " of " + from.getLabel() + "'!"));
            }
        }
        return hits;
    }

    private static String getUnitSymbol(IRI units) {
        if (GEOF.UOM_METRE.equals((Object)units)) {
            return "m";
        }
        return "";
    }

    private BindingSetCollection generateBindingSets(DistanceQuerySpec query, Iterable<? extends DocumentDistance> hits) throws SailException {
        Var contextVar;
        String distanceVar;
        String geoVar;
        LinkedHashSet<BindingSet> bindingSets = new LinkedHashSet<BindingSet>();
        HashSet<String> bindingNames = new HashSet<String>();
        String subjVar = query.getSubjectVar();
        if (subjVar != null) {
            bindingNames.add(subjVar);
        }
        if ((geoVar = query.getGeoVar()) != null) {
            bindingNames.add(geoVar);
        }
        if ((distanceVar = query.getDistanceVar()) != null) {
            bindingNames.add(distanceVar);
        }
        if ((contextVar = query.getContextVar()) != null && !contextVar.hasValue()) {
            bindingNames.add(contextVar.getName());
        }
        if (hits != null) {
            double maxDistance = query.getDistance();
            for (DocumentDistance documentDistance : hits) {
                SearchDocument doc = documentDistance.getDocument();
                if (doc == null) continue;
                List<String> geometries = doc.getProperty(SearchFields.getPropertyField(query.getGeoProperty()));
                for (String geometry : geometries) {
                    Resource ctx;
                    double distance = documentDistance.getDistance();
                    if (!(distance < maxDistance)) continue;
                    QueryBindingSet derivedBindings = new QueryBindingSet();
                    if (subjVar != null) {
                        Resource resource = this.getResource(doc);
                        derivedBindings.addBinding(subjVar, (Value)resource);
                    }
                    if (contextVar != null && !contextVar.hasValue() && (ctx = SearchFields.createContext(doc.getContext())) != null) {
                        derivedBindings.addBinding(contextVar.getName(), (Value)ctx);
                    }
                    if (geoVar != null) {
                        derivedBindings.addBinding(geoVar, (Value)SearchFields.wktToLiteral(geometry));
                    }
                    if (distanceVar != null) {
                        derivedBindings.addBinding(distanceVar, (Value)SearchFields.distanceToLiteral(distance));
                    }
                    bindingSets.add((BindingSet)derivedBindings);
                }
            }
        }
        return new BindingSetCollection(bindingNames, bindingSets);
    }

    private Iterable<? extends DocumentResult> evaluateQuery(GeoRelationQuerySpec query) {
        Iterable<? extends DocumentResult> hits;
        block3: {
            hits = null;
            Literal qgeom = query.getQueryGeometry();
            IRI geoProperty = query.getGeoProperty();
            try {
                if (!GEO.WKT_LITERAL.equals((Object)qgeom.getDatatype())) {
                    throw new MalformedQueryException("Unsupported datatype: " + String.valueOf(qgeom.getDatatype()));
                }
                hits = this.geoRelationQuery(query.getRelation(), geoProperty, qgeom.getLabel(), query.getContextVar());
            }
            catch (Exception e) {
                this.logger.error("There was a problem evaluating spatial relation query '" + query.getRelation() + " " + qgeom.getLabel() + "'!", (Throwable)e);
                if ($assertionsDisabled) break block3;
                throw new AssertionError((Object)("There was a problem evaluating spatial relation query '" + query.getRelation() + " " + qgeom.getLabel() + "'!"));
            }
        }
        return hits;
    }

    private IRI toSpatialOp(String relation) {
        if (GEOF.SF_INTERSECTS.stringValue().equals(relation)) {
            return GEOF.SF_INTERSECTS;
        }
        if (GEOF.SF_DISJOINT.stringValue().equals(relation)) {
            return GEOF.SF_DISJOINT;
        }
        if (GEOF.SF_EQUALS.stringValue().equals(relation)) {
            return GEOF.SF_EQUALS;
        }
        if (GEOF.SF_OVERLAPS.stringValue().equals(relation)) {
            return GEOF.SF_OVERLAPS;
        }
        if (GEOF.EH_COVERED_BY.stringValue().equals(relation)) {
            return GEOF.SF_WITHIN;
        }
        if (GEOF.EH_COVERS.stringValue().equals(relation)) {
            return GEOF.EH_CONTAINS;
        }
        if (GEOF.SF_WITHIN.stringValue().equals(relation)) {
            return GEOF.SF_WITHIN;
        }
        if (GEOF.EH_CONTAINS.stringValue().equals(relation)) {
            return GEOF.EH_CONTAINS;
        }
        return null;
    }

    private Shape readShape(String geo) {
        ShapeReader reader = SpatialSupport.getSpatialContext().getFormats().getWktReader();
        try {
            return reader.read((Object)geo);
        }
        catch (IOException | ParseException e) {
            throw new SailException("Can't read geo wkt shape", (Throwable)e);
        }
    }

    private boolean checkSpatialOp(IRI op, Shape arg1, Shape arg2) {
        SpatialAlgebra algebra = SpatialSupport.getSpatialAlgebra();
        if (op == GEOF.SF_INTERSECTS) {
            return algebra.sfIntersects(arg1, arg2);
        }
        if (op == GEOF.SF_DISJOINT) {
            return algebra.sfDisjoint(arg1, arg2);
        }
        if (op == GEOF.SF_EQUALS) {
            return algebra.sfEquals(arg1, arg2);
        }
        if (op == GEOF.SF_OVERLAPS) {
            return algebra.sfOverlaps(arg1, arg2);
        }
        if (op == GEOF.SF_WITHIN) {
            return algebra.sfWithin(arg1, arg2);
        }
        if (op == GEOF.EH_CONTAINS) {
            return algebra.ehContains(arg1, arg2);
        }
        throw new SailException((Throwable)new IllegalArgumentException("bad spatial op : " + String.valueOf(op)));
    }

    private BindingSetCollection generateBindingSets(GeoRelationQuerySpec query, Iterable<? extends DocumentResult> hits) throws SailException {
        Var contextVar;
        String fVar;
        String geoVar;
        LinkedHashSet<BindingSet> bindingSets = new LinkedHashSet<BindingSet>();
        HashSet<String> bindingNames = new HashSet<String>();
        String subjVar = query.getSubjectVar();
        if (subjVar != null) {
            bindingNames.add(subjVar);
        }
        if ((geoVar = query.getGeoVar()) != null) {
            bindingNames.add(geoVar);
        }
        if ((fVar = query.getFunctionValueVar()) != null) {
            bindingNames.add(fVar);
        }
        if ((contextVar = query.getContextVar()) != null && !contextVar.hasValue()) {
            bindingNames.add(contextVar.getName());
        }
        if (hits != null) {
            for (DocumentResult documentResult : hits) {
                SearchDocument doc = documentResult.getDocument();
                if (doc == null) continue;
                List<String> geometries = doc.getProperty(SearchFields.getPropertyField(query.getGeoProperty()));
                boolean needValidation = geometries.size() != 1;
                IRI spatialOp = null;
                Shape funcGeo = null;
                if (needValidation) {
                    spatialOp = this.toSpatialOp(query.getRelation());
                    funcGeo = this.readShape(query.getQueryGeometry().getLabel());
                }
                for (String geometry : geometries) {
                    Resource ctx;
                    QueryBindingSet derivedBindings = new QueryBindingSet();
                    if (geoVar != null) {
                        Shape geo;
                        if (needValidation && spatialOp != null && !this.checkSpatialOp(spatialOp, funcGeo, geo = this.readShape(geometry))) continue;
                        derivedBindings.addBinding(geoVar, (Value)SearchFields.wktToLiteral(geometry));
                    }
                    if (subjVar != null) {
                        Resource resource = this.getResource(doc);
                        derivedBindings.addBinding(subjVar, (Value)resource);
                    }
                    if (contextVar != null && !contextVar.hasValue() && (ctx = SearchFields.createContext(doc.getContext())) != null) {
                        derivedBindings.addBinding(contextVar.getName(), (Value)ctx);
                    }
                    if (fVar != null) {
                        derivedBindings.addBinding(fVar, (Value)BooleanLiteral.TRUE);
                    }
                    bindingSets.add((BindingSet)derivedBindings);
                }
            }
        }
        return new BindingSetCollection(bindingNames, bindingSets);
    }

    protected Object parseLuceneQueryShape(String property, String value) throws ParseException, IOException {
        return SimpleWKTShapeParser.parse((String)value);
    }

    protected Shape parseQueryShape(String property, String value) throws ParseException {
        return this.getSpatialContext(property).readShapeFromWkt(value);
    }

    protected Shape parseQueryPoint(String property, String value) throws ParseException {
        return this.getSpatialContext(property).readShapeFromWkt(value);
    }

    protected Resource getResource(SearchDocument document) {
        return SearchFields.createResource(document.getResource());
    }

    protected abstract SearchDocument getDocument(String var1) throws IOException;

    protected abstract Iterable<? extends SearchDocument> getDocuments(String var1) throws IOException;

    protected abstract SearchDocument newDocument(String var1, String var2, String var3);

    protected abstract SearchDocument copyDocument(SearchDocument var1);

    protected abstract void addDocument(SearchDocument var1) throws IOException;

    protected abstract void updateDocument(SearchDocument var1) throws IOException;

    protected abstract void deleteDocument(SearchDocument var1) throws IOException;

    protected abstract Iterable<? extends DocumentScore> query(Resource var1, QuerySpec var2) throws MalformedQueryException, IOException;

    protected abstract Iterable<? extends DocumentDistance> geoQuery(IRI var1, Point var2, IRI var3, double var4, String var6, Var var7) throws MalformedQueryException, IOException;

    protected abstract Iterable<? extends DocumentResult> geoRelationQuery(String var1, IRI var2, String var3, Var var4) throws MalformedQueryException, IOException;

    protected abstract BulkUpdater newBulkUpdate();

    static {
        REJECTED_DATATYPES.add("http://www.w3.org/2001/XMLSchema#float");
    }
}

