/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sparqlbuilder.core;

import org.eclipse.rdf4j.sparqlbuilder.core.Orderable;
import org.eclipse.rdf4j.sparqlbuilder.util.SparqlBuilderUtils;

public class OrderCondition
implements Orderable {
    private static final String ASC = "ASC";
    private static final String DESC = "DESC";
    private final Orderable orderOn;
    private boolean isAscending;

    OrderCondition(Orderable orderOn) {
        this(orderOn, true);
    }

    OrderCondition(Orderable orderOn, boolean ascending) {
        this.orderOn = orderOn;
        if (ascending) {
            this.asc();
        } else {
            this.desc();
        }
    }

    @Override
    public OrderCondition asc() {
        this.isAscending = true;
        return this;
    }

    @Override
    public OrderCondition desc() {
        this.isAscending = false;
        return this;
    }

    @Override
    public String getQueryString() {
        StringBuilder condition = new StringBuilder();
        if (this.orderOn != null) {
            if (this.isAscending) {
                condition.append(ASC);
            } else {
                condition.append(DESC);
            }
            condition.append(SparqlBuilderUtils.getParenthesizedString(this.orderOn.getQueryString()));
        }
        return condition.toString();
    }
}

