/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.tesla.swt.logging;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.aspectj.lang.JoinPoint;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.rcptt.tesla.recording.core.TeslaRecorder;
import org.eclipse.rcptt.tesla.swt.events.TeslaEventManager;
import org.eclipse.rcptt.tesla.swt.workbench.EclipseWorkbenchProvider;
import org.eclipse.rcptt.tesla.ui.SWTTeslaActivator;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Widget;

public class SwtEventLog {
    private static SwtEventLog instance = null;
    private boolean logStackTraceOnSend = false;
    private boolean active = false;
    private FileWriter writer = null;
    private List<IFilter> filters = new ArrayList<IFilter>();
    private List<Tagger> taggers = new ArrayList<Tagger>();
    private Widget lastWidget = null;
    private Integer lastType = null;
    private Map<String, Object> lastSnapshot = null;
    private AutState lastState = null;
    private static Map<Integer, String> eventNames = null;
    private static Set<Class<? extends Object>> justToStringClasses = new HashSet<Class<? extends Object>>();
    private static final Map<Class<?>, IFormatter> formatters;

    static {
        justToStringClasses.add(Integer.class);
        justToStringClasses.add(Double.class);
        justToStringClasses.add(Float.class);
        justToStringClasses.add(Boolean.class);
        justToStringClasses.add(String.class);
        justToStringClasses.add(Byte.class);
        justToStringClasses.add(Short.class);
        justToStringClasses.add(Long.class);
        justToStringClasses.add(Character.class);
        formatters = new HashMap();
        formatters.put(Combo.class, new IFormatter(){

            @Override
            public String format(Object value) {
                Combo combo = (Combo)value;
                return SwtEventLog.formatArray(combo.getItems());
            }
        });
        formatters.put(CCombo.class, new IFormatter(){

            @Override
            public String format(Object value) {
                CCombo combo = (CCombo)value;
                return SwtEventLog.formatArray(combo.getItems());
            }
        });
    }

    public static SwtEventLog getInstance() {
        if (instance == null) {
            instance = new SwtEventLog();
            instance.setLogStackTraceOnSend(true);
            instance.addFilter(new BlockAllFilter());
        }
        return instance;
    }

    public void setLogStackTraceOnSend(boolean value) {
        this.logStackTraceOnSend = value;
    }

    public void activate() {
        try {
            Class.forName("org.eclipse.core.resources.ResourcesPlugin");
        }
        catch (ClassNotFoundException e) {
            SWTTeslaActivator.log("Unable to create q7-swt-event.log writter", e);
            return;
        }
        File workspaceRoot = ResourcesPlugin.getWorkspace().getRoot().getLocation().toFile();
        File logFile = new File(workspaceRoot, ".metadata/q7-swt-event.log");
        try {
            this.writer = new FileWriter(logFile, true);
        }
        catch (IOException e) {
            SWTTeslaActivator.log("Unable to create q7-swt-event.log writter", e);
            return;
        }
        this.active = true;
    }

    public void addFilter(IFilter filter) {
        this.filters.add(filter);
    }

    private void addTagger(String name, IFilter filter) {
        this.taggers.add(new Tagger(name, filter));
    }

    private void write(String line, Object ... args) {
        try {
            this.writer.append(String.format(line, args));
            this.writer.append('\n');
            this.writer.flush();
        }
        catch (IOException e) {
            SWTTeslaActivator.log("Unable to write to q7-swt-event.log", e);
        }
    }

    private void writeAnnouncement(String message, Object ... args) {
        this.write("\n=== %s ===\n", String.format(message, args));
    }

    private synchronized void writeEvent(String message, Widget widget, int type, Event event, boolean send) {
        if (!this.active || this.writer == null) {
            return;
        }
        AutState state = SwtEventLog.detectAutState();
        if (this.lastState == null || this.lastState != state) {
            this.writeAnnouncement("%s is the current AUT mode", new Object[]{state});
            this.lastState = state;
        }
        for (IFilter f : this.filters) {
            if (!f.filter(widget, type, event, send)) continue;
            return;
        }
        Map<String, Object> snapshot = SwtEventLog.makeSnapshot(event);
        if (widget == this.lastWidget && this.lastType != null && type == this.lastType && SwtEventLog.areSnapshotsEqual(snapshot, this.lastSnapshot)) {
            this.write("%s...", message);
            return;
        }
        this.lastWidget = widget;
        this.lastType = type;
        this.lastSnapshot = snapshot;
        this.write("%s %s%s %s - %s\n  %s\n", message, this.formatTags(widget, type, event, send), SwtEventLog.formatEventName(type, event), SwtEventLog.formatObject(widget), new SimpleDateFormat("yyyy/MM/dd HH:mm:ss:SSS").format(new Date()), SwtEventLog.formatEvent(widget, snapshot));
        if (this.logStackTraceOnSend || !send) {
            this.writeStackTrace();
        }
    }

    private String formatTags(Widget widget, int type, Event event, boolean send) {
        StringBuilder b = new StringBuilder();
        for (Tagger t : this.taggers) {
            if (t.filter.filter(widget, type, event, send)) continue;
            if (b.length() > 0) {
                b.append(", ");
            }
            b.append(t.name);
        }
        return b.length() > 0 ? String.format("[%s] ", b) : "";
    }

    public void logProceed(Widget widget, int type, Event event, boolean send) {
        this.writeEvent("+", widget, type, event, send);
    }

    public void logSkip(Widget widget, int type, Event event, boolean send) {
        this.writeEvent("-", widget, type, event, send);
    }

    public void logRecord(Widget widget, int type, Event event, boolean send) {
        if (this.lastState == null || this.lastState != AutState.Recording) {
            return;
        }
        this.writeEvent("*", widget, type, event, send);
    }

    private void writeMethodCall(String message, JoinPoint point) {
        if (!this.active || this.writer == null) {
            return;
        }
        AutState state = SwtEventLog.detectAutState();
        if (this.lastState == null || this.lastState != state) {
            this.writeAnnouncement("%s is the current AUT mode", new Object[]{state});
            this.lastState = state;
        }
        this.write("%s %s %s - %s\n  %s: %s\n", message, point.getSignature(), point.getSourceLocation(), new SimpleDateFormat("yyyy/MM/dd HH:mm:ss:SSS").format(new Date()), SwtEventLog.formatObject(point.getThis()), SwtEventLog.formatArgs(point.getArgs()));
    }

    private void writeStackTrace() {
        StackTraceElement[] trace;
        if (!this.active || this.writer == null) {
            return;
        }
        StackTraceElement[] stackTraceElementArray = trace = Thread.currentThread().getStackTrace();
        int n = trace.length;
        int n2 = 0;
        while (n2 < n) {
            StackTraceElement e = stackTraceElementArray[n2];
            this.write("  " + e.toString(), new Object[0]);
            ++n2;
        }
        this.write("\n", new Object[0]);
    }

    public void logMethodCallTo(JoinPoint point) {
        this.writeMethodCall(">", point);
        this.writeStackTrace();
    }

    public void logMethodCallFrom(JoinPoint point) {
        this.writeMethodCall(" ", point);
    }

    public void logTypedEvent(TypedEvent event) {
        if (!this.active || this.writer == null) {
            return;
        }
        AutState state = SwtEventLog.detectAutState();
        if (this.lastState == null || this.lastState != state) {
            this.writeAnnouncement("%s is the current AUT mode", new Object[]{state});
            this.lastState = state;
        }
        Map<String, Object> snapshot = SwtEventLog.makeSnapshot(event);
        this.write("# %s %s - %s\n  %s\n", event.getClass().getName(), SwtEventLog.formatObject(event.widget), new SimpleDateFormat("yyyy/MM/dd HH:mm:ss:SSS").format(new Date()), SwtEventLog.formatEvent(event.widget, snapshot));
        this.writeStackTrace();
    }

    private static boolean areSnapshotsEqual(Map<String, Object> a, Map<String, Object> b) {
        if (a == null || b == null) {
            return false;
        }
        if (a.get("meta:class") != b.get("meta:class")) {
            return false;
        }
        if (a.size() != b.size()) {
            return false;
        }
        for (String name : a.keySet()) {
            Object bValue;
            if (!b.containsKey(name)) {
                return false;
            }
            Object aValue = a.get(name);
            if (aValue == (bValue = b.get(name))) continue;
            if (aValue == null || bValue == null) {
                return false;
            }
            if (aValue.equals(bValue)) continue;
            return false;
        }
        return true;
    }

    private static Map<String, Object> makeSnapshot(Object object) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        if (object == null) {
            return null;
        }
        Class<?> class_ = object.getClass();
        result.put("meta:class", class_);
        while (class_ != null) {
            Field[] fields;
            Field[] fieldArray = fields = class_.getDeclaredFields();
            int n = fields.length;
            int n2 = 0;
            while (n2 < n) {
                Field f = fieldArray[n2];
                try {
                    if (!Modifier.isStatic(f.getModifiers())) {
                        f.setAccessible(true);
                        result.put(f.getName(), f.get(object));
                    }
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                ++n2;
            }
            class_ = class_.getSuperclass();
        }
        return result;
    }

    private static Map<Integer, String> getEventNames() {
        if (eventNames == null) {
            eventNames = new HashMap<Integer, String>();
            eventNames.put(-1, "[unknown]");
            Class[] classArray = new Class[]{SWT.class, DND.class};
            int n = classArray.length;
            int n2 = 0;
            while (n2 < n) {
                Field[] fields;
                Class c = classArray[n2];
                Field[] fieldArray = fields = c.getDeclaredFields();
                int n3 = fields.length;
                int n4 = 0;
                while (n4 < n3) {
                    String name;
                    Field f = fieldArray[n4];
                    if (Modifier.isStatic(f.getModifiers()) && (name = f.getName()).length() >= 2 && Character.isUpperCase(name.charAt(0)) && Character.isLowerCase(name.charAt(1))) {
                        try {
                            eventNames.put(f.getInt(null), name);
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                        }
                        catch (IllegalAccessException illegalAccessException) {
                            // empty catch block
                        }
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        return eventNames;
    }

    private static String formatEventName(int type, Event event) {
        String result = SwtEventLog.getEventNames().get(type == -1 && event != null ? event.type : type);
        if (result == null) {
            result = Integer.toString(type);
        }
        return result;
    }

    private static String formatEvent(Widget widget, Map<String, Object> snapshot) {
        if (snapshot == null) {
            return "null";
        }
        StringBuilder b = new StringBuilder();
        for (String name : snapshot.keySet()) {
            if (name.contains(":")) continue;
            Object value = snapshot.get(name);
            if (b.length() > 0) {
                b.append(", ");
            }
            b.append(name).append(": ").append(value == widget ? "..." : SwtEventLog.formatObject(value));
        }
        return b.toString();
    }

    private static String formatArray(Object[] items) {
        Object result = "[";
        Object[] objectArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            result = (String)result + (String)(((String)result).length() > 1 ? ", " + SwtEventLog.formatObject(o) : SwtEventLog.formatObject(o));
            ++n2;
        }
        return (String)result + "]";
    }

    private static String genericFormatObject(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Character && ((Character)value).charValue() == '\u0000') {
            return "NUL";
        }
        if (justToStringClasses.contains(value.getClass())) {
            return value.toString();
        }
        if (value instanceof Object[]) {
            return SwtEventLog.formatArray((Object[])value);
        }
        if (value instanceof Widget) {
            Widget widget = (Widget)value;
            return String.format("%s@%x [%s] %s", value.getClass().getName(), System.identityHashCode(value), widget.isDisposed() ? "disposed" : SwtEventLog.formatWidgetPath(widget), widget.isDisposed() ? "[disposed]" : value.toString());
        }
        return String.format("%s@%x %s", value.getClass().getName(), System.identityHashCode(value), value.toString());
    }

    private static String detailsFormatObject(Object value) {
        IFormatter formatter = formatters.get(value.getClass());
        return formatter == null ? null : formatter.format(value);
    }

    private static String formatObject(Object value) {
        String genericText = SwtEventLog.genericFormatObject(value);
        String details = value == null ? null : SwtEventLog.detailsFormatObject(value);
        return details == null ? genericText : genericText + "\n  " + details;
    }

    private static String formatWidgetPath(Widget widget) {
        StringBuilder b = new StringBuilder();
        while (widget != null) {
            if (b.length() > 0) {
                b.append(" <- ");
            }
            b.append(widget.getClass().getSimpleName());
            try {
                Object text;
                Method getText = widget.getClass().getMethod("getText", new Class[0]);
                if (getText.getReturnType() == String.class && (text = (String)getText.invoke((Object)widget, new Object[0])) != null && ((String)text).length() > 0) {
                    if (((String)text).length() > 32) {
                        text = ((String)text).substring(0, 32) + " ...";
                    }
                    b.append('(').append((String)text).append(')');
                }
            }
            catch (SecurityException securityException) {
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
            Composite composite = widget = widget instanceof Control ? ((Control)widget).getParent() : null;
        }
        return b.toString();
    }

    private static String formatArgs(Object[] args) {
        if (args.length == 0) {
            return "[none]";
        }
        StringBuilder b = new StringBuilder();
        Object[] objectArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            if (b.length() > 0) {
                b.append(", ");
            }
            b.append(o == null ? null : SwtEventLog.formatObject(o));
            ++n2;
        }
        return b.toString();
    }

    private static AutState detectAutState() {
        boolean replaying = TeslaEventManager.getManager().hasListeners();
        boolean recording = TeslaRecorder.getInstance().hasListeners();
        if (replaying) {
            if (recording) {
                return AutState.Invalid;
            }
            return AutState.Replaying;
        }
        if (recording) {
            if (replaying) {
                return AutState.Invalid;
            }
            return AutState.Recording;
        }
        return AutState.Normal;
    }

    private static enum AutState {
        Normal,
        Recording,
        Replaying,
        Invalid;

    }

    private static class BlockAllFilter
    implements IFilter {
        private BlockAllFilter() {
        }

        @Override
        public boolean filter(Widget widget, int type, Event event, boolean send) {
            return true;
        }
    }

    public static interface IFilter {
        public boolean filter(Widget var1, int var2, Event var3, boolean var4);
    }

    private static interface IFormatter {
        public String format(Object var1);
    }

    private static class OrFilter
    implements IFilter {
        private IFilter left;
        private IFilter right;

        public OrFilter(IFilter left, IFilter right) {
            this.left = left;
            this.right = right;
        }

        @Override
        public boolean filter(Widget widget, int type, Event event, boolean send) {
            return this.left.filter(widget, type, event, send) && this.right.filter(widget, type, event, send);
        }
    }

    private static class Tagger {
        public String name;
        public IFilter filter;

        public Tagger(String name, IFilter filter) {
            this.name = name;
            this.filter = filter;
        }
    }

    private static class TypeFilter
    implements IFilter {
        private int[] types;
        public static final int[] DND_EVENTS = new int[]{2000, 2002, 2003, 2005, 2004, 2001, 2008, 2006, 2007};

        public TypeFilter(int ... types) {
            this.types = types;
        }

        @Override
        public boolean filter(Widget widget, int type, Event event, boolean send) {
            type = type == -1 && event != null ? event.type : type;
            int[] nArray = this.types;
            int n = this.types.length;
            int n2 = 0;
            while (n2 < n) {
                int t = nArray[n2];
                if (t == type) {
                    return false;
                }
                ++n2;
            }
            return true;
        }
    }

    private static class ViewFilter
    implements IFilter {
        private final String viewId;

        public ViewFilter(String viewId) {
            this.viewId = viewId;
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public boolean filter(Widget widget, int type, Event event, boolean send) {
            if (send) ** GOTO lbl7
            return true;
lbl-1000:
            // 1 sources

            {
                id = EclipseWorkbenchProvider.getProvider().getViewId(widget);
                if (this.viewId.equalsIgnoreCase(id)) {
                    return false;
                }
                v0 = widget = widget instanceof Control != false ? ((Control)widget).getParent() : null;
lbl7:
                // 2 sources

                ** while (widget != null)
            }
lbl8:
            // 1 sources

            return true;
        }
    }
}

