/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.plugin;

import aQute.bnd.osgi.Processor;
import aQute.service.reporter.Reporter;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.SortedMap;
import java.util.stream.Collectors;
import org.bndtools.templating.Template;
import org.bndtools.templating.TemplateLoader;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.elements.ElementList;
import org.eclipse.pde.internal.ui.wizards.IProjectProvider;
import org.eclipse.pde.internal.ui.wizards.NewWizard;
import org.eclipse.pde.internal.ui.wizards.WizardElement;
import org.eclipse.pde.internal.ui.wizards.plugin.NewProjectCreationOperation;
import org.eclipse.pde.internal.ui.wizards.plugin.NewProjectCreationPage;
import org.eclipse.pde.internal.ui.wizards.plugin.PluginContentPage;
import org.eclipse.pde.internal.ui.wizards.plugin.PluginFieldData;
import org.eclipse.pde.internal.ui.wizards.plugin.TemplateListSelectionPage;
import org.eclipse.pde.ui.IPluginContentWizard;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;
import org.osgi.framework.ServiceReference;
import org.osgi.util.promise.Promise;
import org.osgi.util.tracker.ServiceTracker;

public class NewPluginProjectWizard
extends NewWizard
implements IExecutableExtension {
    public static final String PLUGIN_POINT = "pluginContent";
    public static final String TAG_WIZARD = "wizard";
    public static final String DEF_PROJECT_NAME = "project_name";
    public static final String DEF_TEMPLATE_ID = "template-id";
    private IConfigurationElement fConfig;
    private final PluginFieldData fPluginData;
    private IProjectProvider fProjectProvider;
    protected NewProjectCreationPage fMainPage;
    protected PluginContentPage fContentPage;
    private TemplateListSelectionPage fWizardListPage;

    public NewPluginProjectWizard() {
        this.setDefaultPageImageDescriptor(PDEPluginImages.DESC_NEWPPRJ_WIZ);
        this.setDialogSettings(PDEPlugin.getDefault().getDialogSettings());
        this.setWindowTitle(PDEUIMessages.NewProjectWizard_title);
        this.setNeedsProgressMonitor(true);
        this.fPluginData = new PluginFieldData();
    }

    public NewPluginProjectWizard(String osgiFramework) {
        this();
        this.fPluginData.setOSGiFramework(osgiFramework);
    }

    public void addPages() {
        this.fMainPage = new NewProjectCreationPage("main", this.fPluginData, false, this.getSelection());
        this.fMainPage.setTitle(PDEUIMessages.NewProjectWizard_MainPage_title);
        this.fMainPage.setDescription(PDEUIMessages.NewProjectWizard_MainPage_desc);
        String pname = this.getDefaultValue(DEF_PROJECT_NAME);
        if (pname != null) {
            this.fMainPage.setInitialProjectName(pname);
        }
        this.addPage((IWizardPage)this.fMainPage);
        this.fProjectProvider = new IProjectProvider(){

            @Override
            public String getProjectName() {
                return NewPluginProjectWizard.this.fMainPage.getProjectName();
            }

            @Override
            public IProject getProject() {
                return NewPluginProjectWizard.this.fMainPage.getProjectHandle();
            }

            @Override
            public IPath getLocationPath() {
                return NewPluginProjectWizard.this.fMainPage.getLocationPath();
            }
        };
        this.fContentPage = new PluginContentPage("page2", this.fProjectProvider, this.fMainPage, this.fPluginData);
        this.fWizardListPage = new TemplateListSelectionPage(this.getAvailableCodegenWizards(), this.fContentPage, PDEUIMessages.WizardListSelectionPage_templates);
        String tid = this.getDefaultValue(DEF_TEMPLATE_ID);
        if (tid != null) {
            this.fWizardListPage.setInitialTemplateId(tid);
        }
        this.addPage((IWizardPage)this.fContentPage);
        this.addPage((IWizardPage)this.fWizardListPage);
    }

    public boolean canFinish() {
        IWizardPage page = this.getContainer().getCurrentPage();
        return super.canFinish() && page != this.fMainPage;
    }

    @Override
    public boolean performFinish() {
        try {
            this.fMainPage.updateData();
            this.fContentPage.updateData();
            IDialogSettings settings = this.getDialogSettings();
            if (settings != null) {
                this.fMainPage.saveSettings(settings);
                this.fContentPage.saveSettings(settings);
            }
            BasicNewProjectResourceWizard.updatePerspective((IConfigurationElement)this.fConfig);
            if (!PDECore.getDefault().areModelsInitialized()) {
                try {
                    this.getContainer().run(true, true, monitor -> {
                        PDECore.getDefault().getModelManager().targetReloaded(monitor);
                        if (monitor.isCanceled()) {
                            throw new InterruptedException();
                        }
                    });
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            IPluginContentWizard contentWizard = this.fWizardListPage.getSelectedWizard();
            this.getContainer().run(false, true, (IRunnableWithProgress)new NewProjectCreationOperation(this.fPluginData, this.fProjectProvider, contentWizard));
            IWorkingSet[] workingSets = this.fMainPage.getSelectedWorkingSets();
            if (workingSets.length > 0) {
                this.getWorkbench().getWorkingSetManager().addToWorkingSets((IAdaptable)this.fProjectProvider.getProject(), workingSets);
            }
            return true;
        }
        catch (InvocationTargetException e) {
            PDEPlugin.logException(e);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return false;
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        this.fConfig = config;
    }

    protected WizardElement createWizardElement(IConfigurationElement config) {
        return WizardElement.create(config, "name", "id", "class");
    }

    public ElementList getAvailableCodegenWizards() {
        IExtension[] extensions;
        final ElementList wizards = new ElementList("CodegenWizards");
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint point = registry.getExtensionPoint(PDEPlugin.getPluginId(), PLUGIN_POINT);
        if (point == null) {
            return wizards;
        }
        IExtension[] iExtensionArray = extensions = point.getExtensions();
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] elements;
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = elements = extension.getConfigurationElements();
            int n3 = elements.length;
            int n4 = 0;
            while (n4 < n3) {
                WizardElement element;
                IConfigurationElement element2 = iConfigurationElementArray[n4];
                if (element2.getName().equals(TAG_WIZARD) && (element = this.createWizardElement(element2)) != null) {
                    wizards.add(element);
                }
                ++n4;
            }
            ++n2;
        }
        try {
            IWizardContainer container = this.getContainer();
            if (container == null) {
                return wizards;
            }
            container.run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    tracker.open();
                    try (ServiceTracker tracker = new ServiceTracker(PDEPlugin.getDefault().getBundle().getBundleContext(), TemplateLoader.class, null);){
                        SortedMap tracked = tracker.getTracked();
                        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)PDEUIMessages.NewPluginProjectWizard_0, (int)tracked.size());
                        HashMap<String, List> templatesByCategory = new HashMap<String, List>();
                        for (Map.Entry entry : tracked.entrySet()) {
                            ServiceReference reference = (ServiceReference)entry.getKey();
                            TemplateLoader templateLoader = (TemplateLoader)entry.getValue();
                            Object label = (String)reference.getProperty("service.description");
                            if (label == null) {
                                label = (String)reference.getProperty("component.name");
                            }
                            if (label == null) {
                                label = "Template Loader  " + templateLoader.getClass().getSimpleName();
                            }
                            subMonitor.subTask((String)label);
                            Promise templates = templateLoader.findTemplates("project", (Reporter)new Processor());
                            Collection loadedTemplates = (Collection)templates.getValue();
                            int templ = 0;
                            for (Template template : loadedTemplates) {
                                WizardElement element = WizardElement.create(template, templateLoader.getClass().getName() + "." + templ++);
                                if (element == null) continue;
                                templatesByCategory.computeIfAbsent(Objects.requireNonNullElse(template.getCategory(), ""), nil -> new ArrayList()).add(element);
                            }
                        }
                        for (List list : templatesByCategory.values()) {
                            list.stream().collect(Collectors.groupingBy(WizardElement::getName)).values().stream().map(elements -> elements.stream().max(Comparator.comparing(WizardElement::getVersion)).orElse(null)).filter(Objects::nonNull).forEach(wizards::add);
                        }
                    }
                }
            });
        }
        catch (InvocationTargetException e) {
            PDEPlugin.getDefault().getLog().error("Loading Templates from OSGi registry failed", (Throwable)e);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return wizards;
    }

    public String getPluginId() {
        return this.fPluginData.getId();
    }

    public String getPluginVersion() {
        return this.fPluginData.getVersion();
    }
}

