/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.push;

import org.eclipse.egit.core.op.PushOperationResult;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.jobs.RepositoryJobResultAction;
import org.eclipse.egit.ui.internal.push.PushMode;
import org.eclipse.egit.ui.internal.push.PushResultDialog;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class ShowPushResultAction
extends RepositoryJobResultAction {
    private final boolean showConfigure;
    private final PushOperationResult operationResult;
    private final String destination;
    @NonNull
    private final PushMode pushMode;

    public ShowPushResultAction(@NonNull Repository repository, PushOperationResult result, String destination, boolean showConfigureButton, @NonNull PushMode pushMode) {
        super(repository, UIText.ShowPushResultAction_name);
        this.operationResult = result;
        this.destination = destination;
        this.showConfigure = showConfigureButton;
        this.pushMode = pushMode;
    }

    private boolean isModal(Shell shell) {
        return (shell.getStyle() & 0x38000) != 0;
    }

    @Override
    protected void showResult(@NonNull Repository repository) {
        Shell shell = PlatformUI.getWorkbench().getModalDialogShellProvider().getShell();
        PushResultDialog dialog = new PushResultDialog(shell, repository, this.operationResult, this.destination, this.isModal(shell), this.pushMode);
        dialog.showConfigureButton(this.showConfigure);
        dialog.open();
    }
}

