/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.tesla.recording.core.gef;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.IFigure;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.rcptt.logging.Q7LoggingManager;
import org.eclipse.rcptt.tesla.core.TeslaFeatures;
import org.eclipse.rcptt.tesla.core.protocol.diagram.DiagramViewerUIElement;
import org.eclipse.rcptt.tesla.core.protocol.raw.Element;
import org.eclipse.rcptt.tesla.core.ui.PropertyNodeList;
import org.eclipse.rcptt.tesla.gef.GefModelMapper;
import org.eclipse.rcptt.tesla.gef.RawFigureUIElement;
import org.eclipse.rcptt.tesla.internal.ui.player.SWTModelMapper;
import org.eclipse.rcptt.tesla.internal.ui.player.SWTUIElement;
import org.eclipse.rcptt.tesla.recording.core.TeslaRecorder;
import org.eclipse.rcptt.tesla.recording.core.gef.GefEventRecorder;
import org.eclipse.rcptt.tesla.recording.core.gef.GefFigureLocator;
import org.eclipse.rcptt.tesla.recording.core.swt.BasicRecordingHelper;

public class GefRecordingHelper
extends BasicRecordingHelper<Object> {
    private static GefRecordingHelper mapper;
    private static Map<EditPartViewer, GraphicalViewerEntry> entries;

    static {
        entries = new HashMap<EditPartViewer, GraphicalViewerEntry>();
    }

    public static Map<EditPartViewer, GraphicalViewerEntry> getGraphicalViewerEntries() {
        return entries;
    }

    public static synchronized GefRecordingHelper getHelper() {
        if (mapper == null) {
            mapper = new GefRecordingHelper();
        }
        return mapper;
    }

    public void clearAllWithParent(Object part) {
        HashSet keySet = new HashSet(this.elements.keySet());
        for (Object e : keySet) {
            List<EditPart> list;
            if (!(e instanceof EditPart) || !(list = this.getParentsList((EditPart)e)).contains(part)) continue;
            this.elements.remove(e);
            if (!(e instanceof GraphicalEditPart)) continue;
            IFigure figure = ((GraphicalEditPart)e).getFigure();
            List<IFigure> figuresList = this.getFiguresList(figure);
            for (IFigure ef : figuresList) {
                this.elements.remove(ef);
            }
        }
        if (part instanceof GraphicalEditPart) {
            IFigure figure = ((GraphicalEditPart)part).getFigure();
            List<IFigure> figuresList = this.getFiguresList(figure);
            for (IFigure ef : figuresList) {
                this.elements.remove(ef);
            }
        }
    }

    private List<EditPart> getParentsList(EditPart e) {
        ArrayList<EditPart> items = new ArrayList<EditPart>();
        while (e != null) {
            EditPart parent = e.getParent();
            if (parent != null) {
                items.add(parent);
            }
            e = parent;
        }
        return items;
    }

    private List<IFigure> getFiguresList(IFigure figure) {
        ArrayList<IFigure> items = new ArrayList<IFigure>();
        if (items.contains(figure)) {
            return new ArrayList<IFigure>();
        }
        items.add(figure);
        List children = figure.getChildren();
        for (Object object : children) {
            if (!(object instanceof IFigure)) continue;
            IFigure fig = (IFigure)object;
            items.addAll(this.getFiguresList(fig));
        }
        return items;
    }

    public void clear() {
        super.clear();
        entries.clear();
    }

    public PropertyNodeList getNodeProperties(Element element, String nodePath) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        PropertyNodeList propertyNodeList;
        Object original = this.findByElement(element);
        if (original instanceof EditPart) {
            PropertyNodeList propertyNodeList2;
            GefFigureLocator locator;
            if (TeslaFeatures.isActivityLogging()) {
                Q7LoggingManager.logMessage((String)"widget.properties", (String)("fill list of extra properties for element: " + String.valueOf(original.getClass()) + (String)(nodePath != null && nodePath.length() > 0 ? " with prefix: " + nodePath : "")));
            }
            if ((locator = this.getLocator()) != null && (propertyNodeList2 = locator.getNodeProperties((EditPart)original, nodePath)) != null) {
                return propertyNodeList2;
            }
        }
        if (original instanceof RawFigureUIElement && (propertyNodeList = GefModelMapper.getPropertyNodes((IFigure)((RawFigureUIElement)original).getFigure(), (String)nodePath)) != null) {
            return propertyNodeList;
        }
        GraphicalViewerEntry originalElement = entries.get(original);
        if (originalElement != null && originalElement.lowerParent != null) {
            return SWTModelMapper.getPropertyNodes((SWTUIElement)originalElement.lowerParent, (String)nodePath);
        }
        return null;
    }

    private GefFigureLocator getLocator() {
        List recorders = TeslaRecorder.getInstance().getProcessors(GefEventRecorder.class);
        if (recorders.size() > 0) {
            return ((GefEventRecorder)recorders.get(0)).getLocator();
        }
        return null;
    }

    public String getWidgetDetails(Element element) {
        return null;
    }

    public static class GraphicalViewerEntry {
        SWTUIElement lowerParent;
        public DiagramViewerUIElement diagramViewer;
    }
}

