/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core.synchronize;

import java.io.UnsupportedEncodingException;
import org.eclipse.egit.core.info.GitInfo;
import org.eclipse.egit.core.internal.Utils;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.team.core.variants.CachedResourceVariant;

public abstract class GitRemoteResource
extends CachedResourceVariant
implements GitInfo {
    private final Repository repo;
    private final String path;
    private final RevCommit commitId;
    private final ObjectId objectId;

    GitRemoteResource(Repository repo, RevCommit commitId, ObjectId objectId, String path) {
        this.repo = repo;
        this.path = path;
        this.objectId = objectId;
        this.commitId = commitId;
    }

    public String getName() {
        int lastSeparator = this.path.lastIndexOf("/");
        return this.path.substring(lastSeparator + 1, this.path.length());
    }

    public String getContentIdentifier() {
        if (this.commitId == null) {
            return "";
        }
        StringBuilder s = new StringBuilder();
        s.append(Utils.getShortObjectId((ObjectId)this.commitId));
        s.append("...");
        PersonIdent authorIdent = this.commitId.getAuthorIdent();
        if (authorIdent != null) {
            s.append(" (");
            s.append(authorIdent.getName());
            s.append(")");
        }
        return s.toString();
    }

    public byte[] asBytes() {
        try {
            return this.getObjectId().name().getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public final Repository getRepository() {
        return this.repo;
    }

    @Override
    public final String getGitPath() {
        return this.path;
    }

    protected String getCachePath() {
        return this.path;
    }

    protected String getCacheId() {
        return "org.eclipse.egit";
    }

    boolean exists() {
        return this.commitId != null;
    }

    public RevCommit getCommitId() {
        return this.commitId;
    }

    @Override
    public GitInfo.Source getSource() {
        return GitInfo.Source.COMMIT;
    }

    ObjectId getObjectId() {
        return this.objectId != null ? this.objectId : ObjectId.zeroId();
    }

    public String getPath() {
        return this.path;
    }
}

