/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.tesla.internal.ui.player;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.rcptt.logging.Q7LoggingManager;
import org.eclipse.rcptt.reporting.core.ReportManager;
import org.eclipse.rcptt.sherlock.core.model.sherlock.report.Node;
import org.eclipse.rcptt.sherlock.core.reporting.Procedure1;
import org.eclipse.rcptt.tesla.core.Q7WaitUtils;
import org.eclipse.rcptt.tesla.core.TeslaFeatures;
import org.eclipse.rcptt.tesla.core.TeslaLimits;
import org.eclipse.rcptt.tesla.core.context.ContextManagement;
import org.eclipse.rcptt.tesla.core.info.Q7WaitInfoRoot;
import org.eclipse.rcptt.tesla.internal.ui.player.DetailUtils;
import org.eclipse.rcptt.tesla.internal.ui.player.JobCollectorExtensions;
import org.eclipse.rcptt.tesla.internal.ui.player.PlayerWidgetUtils;
import org.eclipse.rcptt.tesla.internal.ui.player.SWTUIPlayer;
import org.eclipse.rcptt.tesla.internal.ui.player.TeslaSWTAccess;
import org.eclipse.rcptt.tesla.jobs.JobsManager;
import org.eclipse.rcptt.tesla.swt.events.TeslaEventManager;
import org.eclipse.rcptt.tesla.ui.IJobCollector;
import org.eclipse.rcptt.tesla.ui.SWTTeslaActivator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class UIJobCollector
implements IJobChangeListener {
    private static final boolean DEBUG = "true".equals(Platform.getDebugOption((String)"org.eclipse.rcptt.tesla.swt/debug/jobCollector"));
    private static final boolean DEBUG_REPORT_OUTPUT = "true".equals(Platform.getDebugOption((String)"org.eclipse.rcptt.tesla.swt/debug/debugReportOutput"));
    private static final PrintWriter DEBUG_WRITER = new PrintWriter(System.out);
    private static final Object FAMILY = new Object();
    private final Map<Job, JobInfo> jobs = Collections.synchronizedMap(new IdentityHashMap());
    private boolean state;
    private boolean needDisable = false;
    private final IParameters parameters;
    private final Job removeCompletedJob = new Job("Eliminate completed jobs"){
        {
            this.setPriority(10);
            this.setSystem(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected IStatus run(IProgressMonitor monitor) {
            while (!monitor.isCanceled()) {
                List doneJobs;
                Map map = UIJobCollector.this.jobs;
                synchronized (map) {
                    doneJobs = UIJobCollector.this.jobs.keySet().stream().filter(j -> j.getState() == 0).collect(Collectors.toList());
                }
                if (doneJobs.isEmpty()) break;
                for (Job job : doneJobs) {
                    TeslaSWTAccess.waitListeners(job);
                    if (job.getState() != 0) continue;
                    JobInfo info = (JobInfo)UIJobCollector.this.jobs.remove(job);
                    UIJobCollector.this.event("gone", info);
                }
            }
            return Status.OK_STATUS;
        }

        public boolean belongsTo(Object family) {
            return family == FAMILY;
        }
    };
    private static final Set<String> IGNORED_BY_DEFAULT = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("org.eclipse.jdt.internal.core.search.processing.JobManager$1$ProgressJob", "org.eclipse.ui.internal.progress.ProgressViewUpdater$1", "org.eclipse.ui.internal.progress.WorkbenchSiteProgressService$SiteUpdateJob", "org.eclipse.ui.dialogs.FilteredItemsSelectionDialog.RefreshProgressMessageJob", "org.eclipse.ui.dialogs.FilteredItemsSelectionDialog$RefreshProgressMessageJob", "org.eclipse.ui.internal.progress.AnimationManager$1", "org.eclipse.ui.internal.progress.ProgressManager$6", "org.eclipse.ui.internal.progress.TaskBarProgressManager$1", "org.eclipse.ui.internal.progress.TaskBarProgressManager$2", "org.eclipse.rcptt.ecl.internal.core.Session$1", "org.eclipse.ui.internal.views.markers.CachedMarkerBuilder$1", "org.eclipse.core.internal.utils.StringPoolJob", "org.eclipse.equinox.internal.p2.ui.sdk.scheduler.AutomaticUpdateScheduler$1", "org.eclipse.ui.internal.Workbench.lambda$3", "org.eclipse.ui.internal.Workbench$42", "org.eclipse.debug.internal.ui.views.console.ProcessConsole$InputReadJob", "org.eclipse.rcptt.ecl.internal.debug.runtime.ServerSession", "org.eclipse.ui.internal.Workbench$40")));
    private long lastSuccessTime = 0L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JobInfo getOrCreateJobInfo(Job job) {
        if (job.belongsTo(FAMILY)) {
            throw new AssertionError((Object)"Can't work with an internal job");
        }
        Map<Job, JobInfo> map = this.jobs;
        synchronized (map) {
            JobInfo rv = this.jobs.get(job);
            if (rv == null) {
                rv = new JobInfo(job);
                if (TeslaFeatures.isActivityLogging()) {
                    String msg = "waiting for job: " + job.getClass().getName();
                    if (!IGNORED_BY_DEFAULT.contains(job.getClass().getName())) {
                        this.debug(msg);
                    }
                    Q7LoggingManager.get((String)"jobs").log(msg, null);
                    ReportManager.appendLogExtra((String)msg);
                }
                this.jobs.put(job, rv);
                this.event("new", rv);
            }
            return rv;
        }
    }

    public void aboutToRun(IJobChangeEvent event) {
    }

    public void awake(IJobChangeEvent event) {
        Job job = event.getJob();
        if (job.belongsTo(FAMILY)) {
            return;
        }
        JobInfo info = this.getOrCreateJobInfo(job);
        info.awake();
        this.event("awake", info);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void done(IJobChangeEvent event) {
        Job job = event.getJob();
        if (job.belongsTo(FAMILY)) {
            return;
        }
        JobInfo info = null;
        Map<Job, JobInfo> map = this.jobs;
        synchronized (map) {
            boolean reschedule;
            boolean bl = reschedule = TeslaSWTAccess.getJobEventReSchedule(event) && this.state;
            if (this.needDisable && this.isJoinEmpty()) {
                this.disable();
            }
            if (reschedule) {
                info = this.getOrCreateJobInfo(job);
                info.done(reschedule);
                this.event("rescheduled", info);
            } else {
                info = this.jobs.get(job);
                if (info != null) {
                    info.done(reschedule);
                    this.event("done", info);
                }
            }
        }
        if (info != null) {
            this.removeCompletedJob.schedule();
        }
    }

    public void running(IJobChangeEvent event) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scheduled(IJobChangeEvent event) {
        Map<Job, JobInfo> map = this.jobs;
        synchronized (map) {
            if (!this.state) {
                return;
            }
        }
        Job job = event.getJob();
        if (job.belongsTo(FAMILY)) {
            return;
        }
        JobInfo jobInfo = this.getOrCreateJobInfo(job);
        jobInfo.scheduled(event.getDelay());
        this.event("scheduled", jobInfo);
        jobInfo.poke();
    }

    protected IJobCollector.JobStatus calcJobStatus(Job job) {
        IJobCollector.JobStatus result = UIJobCollector.detectJobStatus(job);
        if (result == null) {
            result = IJobCollector.JobStatus.UNKNOWN;
        }
        return result;
    }

    public static IJobCollector.JobStatus detectJobStatus(Job job) {
        IJobCollector[] collectors;
        IJobCollector.JobStatus status = null;
        if (job.belongsTo(FAMILY)) {
            return IJobCollector.JobStatus.IGNORED;
        }
        IJobCollector[] iJobCollectorArray = collectors = JobCollectorExtensions.getDefault().getCollectors();
        int n = collectors.length;
        int n2 = 0;
        while (n2 < n) {
            IJobCollector cl = iJobCollectorArray[n2];
            IJobCollector.JobStatus jobStatus = cl.testJob(job);
            if (jobStatus != null && !jobStatus.equals((Object)IJobCollector.JobStatus.UNKNOWN) && status == null) {
                status = jobStatus;
                break;
            }
            ++n2;
        }
        if (status == null) {
            String jClassName;
            if (job.belongsTo(UIJobCollector.getFamilyAutoBuild())) {
                status = IJobCollector.JobStatus.REQUIRED;
            }
            if (job.belongsTo(TeslaSWTAccess.getDecoratorManagerFamily())) {
                status = IJobCollector.JobStatus.REQUIRED;
            }
            if (job.isUser()) {
                status = IJobCollector.JobStatus.REQUIRED;
            }
            if (IGNORED_BY_DEFAULT.contains(jClassName = job.getClass().getName())) {
                status = IJobCollector.JobStatus.IGNORED;
            }
        }
        return status;
    }

    public UIJobCollector() {
        this(new IParameters(){

            @Override
            public int stepInterval() {
                return TeslaLimits.getStepModeStepTime();
            }

            @Override
            public int stepModeStartDelay() {
                return TeslaLimits.getStepModeEnableTimeout();
            }

            @Override
            public int stepModeTimeout() {
                return TeslaLimits.getStepModeTimeout();
            }

            @Override
            public int timeout() {
                return TeslaLimits.getJobTimeout();
            }

            @Override
            public int delayToWaitFor() {
                return TeslaLimits.getJobWaitForDelayedTimeout();
            }
        });
    }

    public UIJobCollector(IParameters parameters) {
        if (parameters == null) {
            throw new NullPointerException();
        }
        this.parameters = new NormalizedParameters(parameters);
    }

    public void sleeping(IJobChangeEvent event) {
        Job job = event.getJob();
        if (job.belongsTo(FAMILY)) {
            return;
        }
        JobInfo info = this.getOrCreateJobInfo(job);
        info.sleeping();
        this.event("sleeping", info);
    }

    private static boolean isModal(Shell shell) {
        return PlayerWidgetUtils.isModal(shell);
    }

    private String getJobMessage(Job job) {
        return UIJobCollector.getJobMessage(this.getOrCreateJobInfo(job));
    }

    private static String getJobMessage(JobInfo jobInfo) {
        Job job = jobInfo.job;
        StringBuilder msg = new StringBuilder();
        msg.append("Job: ").append(job.toString()).append("\n");
        msg.append("\tclass: ").append(job.getClass().getName()).append(" ").append(DetailUtils.extractSupers(job.getClass())).append("\n");
        Long startTime = jobInfo.startingTime;
        long currentTimeMillis = System.currentTimeMillis();
        long time = 0L;
        if (startTime != null) {
            time = currentTimeMillis - startTime;
        }
        msg.append("\tworking time: ").append(time).append("(ms)\n");
        msg.append("\tstate: ").append(job.getState()).append("\n");
        ISchedulingRule rule = job.getRule();
        if (rule != null) {
            if (rule instanceof IResource) {
                IPath location = ((IResource)rule).getLocation();
                msg.append("\trule is resource: ").append(location != null ? location.toOSString() : "/").append("\n");
            } else {
                msg.append("\trule: ").append(rule.toString()).append("\n");
            }
        } else {
            msg.append("\trule: Empty\n");
        }
        Thread thread = job.getThread();
        if (thread != null) {
            StackTraceElement[] trace = thread.getStackTrace();
            msg.append("\tstack trace: \n");
            int c = 0;
            StackTraceElement[] stackTraceElementArray = trace;
            int n = trace.length;
            int n2 = 0;
            while (n2 < n) {
                StackTraceElement stackTraceElement = stackTraceElementArray[n2];
                if (c > 15) {
                    msg.append("\t\t....");
                    break;
                }
                ++c;
                msg.append("\t\t" + stackTraceElement.getClassName() + "." + stackTraceElement.getMethodName() + ":" + stackTraceElement.getLineNumber() + (stackTraceElement.getFileName() != null ? " [" + stackTraceElement.getFileName() + "]" : "")).append("\n");
                ++n2;
            }
        }
        return msg.toString();
    }

    private boolean logReturnResult(boolean result, List<Job> realJobs, List<Job> jobsInUI, Q7WaitInfoRoot info) {
        try {
            this.debug("Result: " + result);
            long curTime = System.currentTimeMillis();
            if (result) {
                this.lastSuccessTime = curTime;
                this.debug("No active jobs");
                return result;
            }
            for (Job job : jobsInUI) {
                Q7WaitUtils.updateInfo((String)"job.ui", (String)job.getClass().getName(), (Q7WaitInfoRoot)info);
            }
            for (Job job : realJobs) {
                Q7WaitUtils.updateInfo((String)"job", (String)job.getClass().getName(), (Q7WaitInfoRoot)info);
            }
            if (this.lastSuccessTime == 0L) {
                this.lastSuccessTime = curTime;
                return result;
            }
            if (curTime - this.lastSuccessTime > TeslaLimits.getJobLoggingTimeout()) {
                this.lastSuccessTime = curTime;
                this.logJobInformation(realJobs, jobsInUI);
            }
            this.report("Active jobs: " + realJobs);
        }
        catch (Exception e) {
            SWTTeslaActivator.log(e);
        }
        return result;
    }

    static String getCurrentReportNodeName() {
        final String[] rv = new String[1];
        ReportManager.getCurrentReportNode().update((Procedure1)new Procedure1<Node>(){

            public void apply(Node node) {
                rv[0] = node.getName();
            }
        });
        return rv[0];
    }

    private void logJobInformation(List<Job> realJobs, List<Job> jobsInUI) {
        ArrayList<Job> otherJobs = new ArrayList<Job>(this.jobs.keySet());
        HashSet<Job> jobInStepMode = new HashSet<Job>();
        for (Job job : otherJobs) {
            if (!this.getOrCreateJobInfo(job).jobInStepMode) continue;
            jobInStepMode.add(job);
        }
        otherJobs.removeAll(realJobs);
        otherJobs.removeAll(jobsInUI);
        otherJobs.removeAll(jobInStepMode);
        StringBuilder reportMessage = new StringBuilder();
        reportMessage.append("----->>> Waiting for Jobs during execution: ").append(UIJobCollector.getCurrentReportNodeName()).append(" -----<<<< \n");
        if (realJobs.size() > 0) {
            reportMessage.append("---> Standalone Jobs:\n");
            for (Job job : realJobs) {
                reportMessage.append(this.getJobMessage(job)).append("\n");
            }
        }
        if (jobInStepMode.size() > 0) {
            reportMessage.append("---> Jobs in Stepping mode:\n");
            for (Job job : jobInStepMode) {
                reportMessage.append(this.getJobMessage(job)).append("\n");
            }
        }
        if (jobsInUI.size() > 0) {
            reportMessage.append("---> Jobs doing UI:\n");
            for (Job job : jobsInUI) {
                reportMessage.append(this.getJobMessage(job)).append("\n");
            }
        }
        if (otherJobs.size() > 0) {
            reportMessage.append("---> Other jobs:\n");
            for (Job job : otherJobs) {
                reportMessage.append(this.getJobMessage(job)).append("\n");
            }
        }
        this.report(reportMessage.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty(ContextManagement.Context context, Q7WaitInfoRoot info) {
        Job job;
        ArrayList<Job> realJobs = new ArrayList<Job>();
        ArrayList<Job> jobsInUI = new ArrayList<Job>();
        final Display display = Display.getCurrent();
        if (!this.removeCanceledJobs()) {
            return false;
        }
        Map<Job, JobInfo> map = this.jobs;
        synchronized (map) {
            if (this.jobs.isEmpty()) {
                this.debug("Nothing left");
                return this.logReturnResult(true, realJobs, jobsInUI, info);
            }
            for (JobInfo jobInfo : this.jobs.values()) {
                Job job2 = jobInfo.job;
                if (!jobInfo.isActive()) {
                    String name;
                    if (!DEBUG || IGNORED_BY_DEFAULT.contains(name = job2.getClass().getName())) continue;
                    this.debug("Not active: " + jobInfo);
                    continue;
                }
                this.debug(String.format("Checking: %s", jobInfo.toString()));
                if (job2.getClass().getName().contains("org.eclipse.debug.internal.ui.DebugUIPlugin$")) {
                    ContextManagement.Context ctx;
                    Thread thread = job2.getThread();
                    if (thread == null) {
                        this.report("Active job " + job2.getName() + " has no thread");
                        jobInfo.done(false);
                    }
                    if (((ctx = ContextManagement.makeContext((StackTraceElement[])thread.getStackTrace())).contains("java.util.concurrent.locks.LockSupport", "park") || ctx.contains("java.util.concurrent.locks.LockSupport", "parkNanos") || ctx.contains("java.lang.Object", "wait")) && (context.contains("org.eclipse.jface.dialogs.MessageDialogWithToggle", "open") || context.contains("org.eclipse.jface.dialogs.MessageDialog", "open"))) {
                        this.report("Active job " + job2.getName() + " has skipped since it in lock state and Message dialog are active");
                        continue;
                    }
                }
                long timeout = this.parameters.timeout();
                if (job2.belongsTo(UIJobCollector.getFamilyAutoBuild())) {
                    timeout = TeslaLimits.getAutoBuildJobTimeout();
                }
                if (jobInfo.jobInStepMode) {
                    timeout = this.parameters.stepModeTimeout();
                }
                if (job2.getClass().getName().contains("org.eclipse.debug.internal.ui.DebugUIPlugin")) {
                    timeout = TeslaLimits.getDebugJobTimeout();
                }
                if (jobInfo.isActiveFor(Math.max(1L, timeout))) {
                    this.report(String.format("Job has timed out after %d, skipping: %s", timeout, jobInfo));
                    continue;
                }
                boolean isBlocked = this.isBlocked(job2);
                jobInfo.blocked(isBlocked);
                if (jobInfo.isBlockedFor(this.parameters.stepModeStartDelay()) && !jobInfo.jobInStepMode) {
                    jobInfo.jobInStepMode = true;
                    this.report("Job is blocked for " + this.parameters.stepModeStartDelay() + ", step mode: " + jobInfo);
                }
                if (jobInfo.jobInStepMode) {
                    if (jobInfo.isRunningFor(this.parameters.timeout())) {
                        this.report("Step timeout, skipping: " + jobInfo);
                        continue;
                    }
                    if (jobInfo.isBlockedFor(this.parameters.stepInterval()) && jobInfo.canStep(this.parameters.stepInterval())) {
                        this.report("Job is blocked for " + this.parameters.stepInterval() + ", stepping: " + jobInfo);
                        continue;
                    }
                }
                if (display != null && display.getThread() == job2.getThread()) {
                    jobsInUI.add(job2);
                    continue;
                }
                if (context != null) {
                    if (this.isAsyncSupported() && JobsManager.getInstance().isFinishedAsyncJob(job2) && context.containsClass(job2.getClass().getName())) {
                        jobsInUI.add(job2);
                        continue;
                    }
                    if (this.isSyncSupported() && context.contains(Display.class.getName(), "sleep") && TeslaEventManager.getManager().isJobInSyncExec(job2, context)) {
                        Map<Thread, StackTraceElement[]> traces = Thread.getAllStackTraces();
                        Set<String> names = this.getSuperClassNames(job2);
                        Thread jobThread = null;
                        ContextManagement.Context jobContext = null;
                        for (Map.Entry<Thread, StackTraceElement[]> thread : traces.entrySet()) {
                            ContextManagement.Context ctx = ContextManagement.makeContext((StackTraceElement[])thread.getValue());
                            for (String name : names) {
                                if (!ctx.contains("org.eclipse.core.internal.jobs.Worker", "run") || !ctx.contains(name, "run")) continue;
                                jobThread = thread.getKey();
                                jobContext = ctx;
                            }
                        }
                        if (jobThread != null && jobContext != null) {
                            if (jobContext.contains("org.eclipse.ui.internal.UISynchronizer", "syncExec") && (jobContext.contains("org.eclipse.ui.internal.Semaphore", "acquire") || jobContext.contains("org.eclipse.ui.internal.PendingSyncExec", "waitUntilExecuted")) && !SWTUIPlayer.hasRunnables(PlatformUI.getWorkbench().getDisplay())) {
                                List execs = TeslaEventManager.getManager().getSyncExecs();
                                boolean toContinue = true;
                                for (ContextManagement.Context context2 : execs) {
                                    StackTraceElement[] stackTrace = context2.getStackTrace();
                                    String className = null;
                                    int i = 0;
                                    while (i < stackTrace.length) {
                                        if (stackTrace[i].getClassName().equals("org.eclipse.swt.widgets.Display") && stackTrace[i].getMethodName().equals("syncExec")) {
                                            className = stackTrace[i + 1].getClassName();
                                            break;
                                        }
                                        ++i;
                                    }
                                    if (className.equals("org.eclipse.e4.ui.internal.workbench.swt.E4Application$1") || context.containsClass(className)) continue;
                                    if (DEBUG) {
                                        this.debug("Another thread is waiting for UI thread: " + className);
                                    }
                                    toContinue = false;
                                    break;
                                }
                                if (toContinue) {
                                    jobsInUI.add(job2);
                                    continue;
                                }
                            }
                        } else {
                            this.debug("Could not find job context");
                        }
                    }
                }
                if (!jobInfo.isActive()) continue;
                realJobs.add(job2);
            }
        }
        if (!jobsInUI.isEmpty() && realJobs.size() == 1 && ((Job)realJobs.get(0)).belongsTo(UIJobCollector.getFamilyAutoBuild())) {
            realJobs.clear();
        }
        if (realJobs.size() == 1 && (job = (Job)realJobs.iterator().next()).belongsTo(UIJobCollector.getFamilyAutoBuild())) {
            int flags = TeslaSWTAccess.getJobFlags(job);
            if ((flags & 0xFF) == 8) {
                return this.logReturnResult(true, realJobs, jobsInUI, info);
            }
            final boolean[] value = new boolean[1];
            if (display != null) {
                display.syncExec(new Runnable(){

                    @Override
                    public void run() {
                        Shell[] shells;
                        Shell[] shellArray = shells = display.getShells();
                        int n = shells.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Shell shell = shellArray[n2];
                            if (UIJobCollector.isModal(shell)) {
                                value[0] = true;
                            }
                            ++n2;
                        }
                    }
                });
            }
            if (value[0]) {
                return this.logReturnResult(true, realJobs, jobsInUI, info);
            }
            return this.logReturnResult(false, realJobs, jobsInUI, info);
        }
        return this.logReturnResult(realJobs.isEmpty(), realJobs, jobsInUI, info);
    }

    private boolean isBlocked(Job job) {
        if (job.getState() == 4) {
            Thread thread = job.getThread();
            if (thread == null) {
                return false;
            }
            ContextManagement.Context ctx = ContextManagement.makeContext((StackTraceElement[])thread.getStackTrace());
            return TeslaEventManager.getManager().isJobInSyncExec(job, ctx) || ctx.contains("java.lang.Thread", "sleep") || ctx.contains("java.lang.Object", "wait") || ctx.contains("java.util.concurrent.locks.LockSupport", "park");
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean removeCanceledJobs() {
        Map<Job, JobInfo> map = this.jobs;
        synchronized (map) {
            if (this.jobs.keySet().stream().allMatch(j -> j.getState() != 0)) {
                return true;
            }
        }
        this.removeCompletedJob.schedule();
        return false;
    }

    private Set<String> getSuperClassNames(Job job) {
        Class<?> cl = job.getClass();
        HashSet<String> names = new HashSet<String>();
        while (!cl.equals(Job.class)) {
            names.add(cl.getName());
            Class<?> superclass = cl.getSuperclass();
            if (superclass == null) break;
            cl = superclass;
        }
        return names;
    }

    protected boolean isSyncSupported() {
        return true;
    }

    protected boolean isAsyncSupported() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enable() {
        ArrayList<JobInfo> copy;
        this.debug("enable");
        Map<Job, JobInfo> map = this.jobs;
        synchronized (map) {
            this.state = true;
            this.needDisable = false;
            copy = new ArrayList<JobInfo>(this.jobs.values());
        }
        for (JobInfo jobInfo : copy) {
            if (!jobInfo.isActive()) continue;
            jobInfo.poke();
        }
    }

    private static Object getFamilyAutoBuild() {
        try {
            return ResourcesPlugin.FAMILY_AUTO_BUILD;
        }
        catch (Throwable throwable) {
            return UIJobCollector.class;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disable() {
        Map<Job, JobInfo> map = this.jobs;
        synchronized (map) {
            this.state = false;
            this.needDisable = false;
        }
        this.debug("disable");
    }

    public void setNeedDisable() {
        this.needDisable = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCount() {
        Map<Job, JobInfo> map = this.jobs;
        synchronized (map) {
            return this.jobs.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Job> getJobs() {
        Map<Job, JobInfo> map = this.jobs;
        synchronized (map) {
            ArrayList<Job> rv = new ArrayList<Job>();
            for (JobInfo info : this.jobs.values()) {
                if (!info.isActive()) continue;
                rv.add(info.job);
            }
            return rv;
        }
    }

    public void join(long timeout) throws InterruptedException {
        long delta;
        SWTTeslaActivator.debugLog("UIJobCollector is going to join");
        long startTime = System.currentTimeMillis();
        while ((delta = System.currentTimeMillis() - startTime) <= timeout) {
            if (this.removeCanceledJobs()) {
                if (this.isJoinEmpty()) break;
                List<Job> jobs2 = this.getJobs();
                for (Job job : jobs2) {
                    SWTTeslaActivator.debugLog("Waiting for job:" + job.getName() + " " + job.getState());
                }
                SWTTeslaActivator.debugLog("UIJobCollector is going to join");
            }
            Thread.sleep(50L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isJoinEmpty() {
        int flags;
        Job job;
        ArrayList<Job> realJobs = new ArrayList<Job>();
        Map<Job, JobInfo> map = this.jobs;
        synchronized (map) {
            block8: {
                if (!this.jobs.isEmpty()) break block8;
                return true;
            }
            for (JobInfo jobInfo : this.jobs.values()) {
                if (!jobInfo.isActive()) continue;
                Job job2 = jobInfo.job;
                Set<String> names = this.getSuperClassNames(job2);
                Map<Thread, StackTraceElement[]> traces = Thread.getAllStackTraces();
                boolean toContinue = false;
                block5: for (Map.Entry<Thread, StackTraceElement[]> thread : traces.entrySet()) {
                    ContextManagement.Context ctx = ContextManagement.makeContext((StackTraceElement[])thread.getValue());
                    for (String name : names) {
                        if (!ctx.contains(name, "run") && !ctx.contains(name, "runInUIThread") || !ctx.contains("org.eclipse.swt.widgets.Display", "sleep")) continue;
                        toContinue = true;
                        continue block5;
                    }
                }
                if (toContinue) continue;
                realJobs.add(job2);
            }
        }
        if (realJobs.size() == 1 && (job = (Job)realJobs.iterator().next()).belongsTo(UIJobCollector.getFamilyAutoBuild()) && (flags = TeslaSWTAccess.getJobFlags(job)) == 8) {
            return true;
        }
        return realJobs.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clean() {
        Map<Job, JobInfo> map = this.jobs;
        synchronized (map) {
            this.jobs.clear();
            this.debug("clean");
        }
    }

    private void debug(String message) {
        if (DEBUG) {
            DEBUG_WRITER.printf("%d: UIJobCollector(%d): %s\n", System.currentTimeMillis(), System.identityHashCode(this), message);
            DEBUG_WRITER.flush();
        }
    }

    private void report(String message) {
        SWTTeslaActivator.logToReport(message);
        if (DEBUG_REPORT_OUTPUT) {
            this.debug(message);
        }
    }

    private void event(String message, JobInfo job) {
        if (job == null) {
            return;
        }
        if (UIJobCollector.shouldDebug(job.job)) {
            this.debug(String.format("event: %11s: %s", message, job));
        }
    }

    private static boolean shouldDebug(Job job) {
        return DEBUG && !IGNORED_BY_DEFAULT.contains(job.getClass().getName());
    }

    public static interface IParameters {
        public int stepModeStartDelay();

        public int stepInterval();

        public int stepModeTimeout();

        public int timeout();

        public int delayToWaitFor();
    }

    private class JobInfo {
        private final Job job;
        private IJobCollector.JobStatus status;
        private long startingTime = System.currentTimeMillis() - 1L;
        private long blockedTime = 0L;
        private long rescheduleCounter = 0L;
        private long lastStep = 0L;
        private boolean jobInStepMode = false;
        private boolean blocked = false;
        private long runningTime = System.currentTimeMillis();

        JobInfo(Job job) {
            this.job = job;
            this.status = UIJobCollector.this.calcJobStatus(job);
        }

        synchronized void awake() {
            this.startingTime = System.currentTimeMillis();
            this.runningTime = System.currentTimeMillis();
            this.status = UIJobCollector.this.calcJobStatus(this.job);
            UIJobCollector.this.debug(this + " is awake with " + (Object)((Object)this.status));
        }

        synchronized void sleeping() {
        }

        synchronized void done(boolean reschedule) {
            if (reschedule) {
                ++this.rescheduleCounter;
            }
        }

        synchronized boolean isActive() {
            long delay = this.startingTime - System.currentTimeMillis();
            switch (this.status) {
                case IGNORED: {
                    return false;
                }
                case UNKNOWN: {
                    if (1 == this.job.getState()) {
                        return delay >= 0L && delay <= (long)UIJobCollector.this.parameters.delayToWaitFor();
                    }
                    return true;
                }
                case REQUIRED: {
                    return true;
                }
            }
            return false;
        }

        synchronized void scheduled(long delay) {
            this.status = UIJobCollector.this.calcJobStatus(this.job);
            this.startingTime = System.currentTimeMillis() + delay;
        }

        public String toString() {
            String state = "NONE";
            switch (this.job.getState()) {
                case 4: {
                    state = "RUNNING";
                    break;
                }
                case 1: {
                    state = "SLEEPING";
                    break;
                }
                case 2: {
                    state = "WAITING";
                    break;
                }
                default: {
                    state = "NONE";
                }
            }
            return String.format("%s (%s), %s, status: %8s, is active: %b, delay: %d, blocked for %d, running for %d", new Object[]{this.job.getClass().getName(), this.job.getName(), state, this.status, this.isActive(), this.startingTime - System.currentTimeMillis(), this.blocked ? System.currentTimeMillis() - this.blockedTime : 0L, this.blocked ? 0L : System.currentTimeMillis() - this.runningTime});
        }

        public void blocked(boolean isBlocked) {
            if (this.blocked == isBlocked) {
                return;
            }
            this.blocked = isBlocked;
            UIJobCollector.this.debug(String.valueOf(this.job.getName()) + " is " + (isBlocked ? "blocked" : "unblocked"));
            if (!isBlocked) {
                this.runningTime = System.currentTimeMillis();
            } else {
                this.blockedTime = System.currentTimeMillis();
            }
        }

        public boolean isRunningFor(long time) {
            return !this.blocked && this.runningTime + time < System.currentTimeMillis();
        }

        public boolean isActiveFor(long time) {
            return this.startingTime + time < System.currentTimeMillis();
        }

        public boolean isBlockedFor(long time) {
            return this.blocked && this.blockedTime + time < System.currentTimeMillis();
        }

        public boolean canStep(long timeSinceLastStep) {
            if (System.currentTimeMillis() > this.lastStep + timeSinceLastStep) {
                this.lastStep = System.currentTimeMillis();
                return true;
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void poke() {
            JobInfo jobInfo = this;
            synchronized (jobInfo) {
                if (!this.isActive()) {
                    return;
                }
                if (this.rescheduleCounter >= (long)TeslaLimits.getJobNullifyRescheduleMaxValue()) {
                    return;
                }
            }
            UIJobCollector.this.debug("Nullified: " + this);
            JobsManager.getInstance().nulifyTime(this.job);
        }
    }

    private final class NormalizedParameters
    implements IParameters {
        private final IParameters master;

        public NormalizedParameters(IParameters master) {
            if (master == null) {
                throw new NullPointerException();
            }
            this.master = master;
        }

        @Override
        public int stepModeStartDelay() {
            return Math.max(Math.max(this.master.stepInterval(), this.master.stepModeStartDelay()), 1);
        }

        @Override
        public int stepInterval() {
            return Math.min(this.master.stepInterval(), this.stepModeStartDelay());
        }

        @Override
        public int stepModeTimeout() {
            return Math.max(this.master.stepModeTimeout(), this.master.timeout());
        }

        @Override
        public int timeout() {
            return Math.max(Math.min(this.master.timeout(), this.master.stepModeTimeout()), 1);
        }

        @Override
        public int delayToWaitFor() {
            return Math.min(this.master.delayToWaitFor(), this.timeout());
        }
    }
}

