/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.cds;

import com.ibm.oti.shared.SharedClassURLHelper;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.osgi.internal.cds.CDSBundleEntry;
import org.eclipse.osgi.storage.bundlefile.BundleEntry;
import org.eclipse.osgi.storage.bundlefile.BundleFile;
import org.eclipse.osgi.storage.bundlefile.BundleFileWrapper;

public class CDSBundleFile
extends BundleFileWrapper {
    private static final String classFileExt = ".class";
    private final URL url;
    private SharedClassURLHelper urlHelper;
    private boolean primed = false;

    public CDSBundleFile(BundleFile wrapped) {
        super(wrapped);
        URL content = null;
        try {
            content = new URL("file", "", wrapped.getBaseFile().getAbsolutePath());
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        this.url = content;
    }

    public CDSBundleFile(BundleFile bundleFile, SharedClassURLHelper urlHelper) {
        this(bundleFile);
        this.urlHelper = urlHelper;
    }

    @Override
    public BundleEntry getEntry(String path) {
        if (!this.primed || !path.endsWith(classFileExt)) {
            return super.getEntry(path);
        }
        byte[] classbytes = this.getClassBytes(path.substring(0, path.length() - classFileExt.length()));
        if (classbytes == null) {
            return super.getEntry(path);
        }
        CDSBundleEntry be = new CDSBundleEntry(path, classbytes, this);
        return be;
    }

    BundleEntry getWrappedEntry(String path) {
        return super.getEntry(path);
    }

    URL getURL() {
        return this.url;
    }

    SharedClassURLHelper getURLHelper() {
        return this.urlHelper;
    }

    void setURLHelper(SharedClassURLHelper urlHelper) {
        this.urlHelper = urlHelper;
        this.primed = false;
    }

    void setPrimed(boolean primed) {
        this.primed = primed;
    }

    private byte[] getClassBytes(String name) {
        if (this.urlHelper == null || this.url == null) {
            return null;
        }
        return this.urlHelper.findSharedClass(null, this.url, name);
    }

    public boolean getPrimed() {
        return this.primed;
    }
}

