/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ecl.doc;

import java.io.IOException;
import java.util.List;
import org.eclipse.rcptt.ecl.core.util.DeclarationInfo;
import org.eclipse.rcptt.ecl.doc.EclDocWriter;
import org.eclipse.rcptt.ecl.doc.IEclDocProvider;

public class EclDocReference
implements IEclDocProvider {
    List<DeclarationInfo> listOfDeclarations;
    String refName;

    public EclDocReference(String refName, List<DeclarationInfo> listOfDeclarations) {
        this.listOfDeclarations = listOfDeclarations;
        this.refName = refName;
    }

    public List<DeclarationInfo> getListOfDeclarations() {
        return this.listOfDeclarations;
    }

    @Override
    public void writeEclDoc(EclDocWriter writer) throws IOException {
        if (this.listOfDeclarations == null || this.listOfDeclarations.size() == 0) {
            writer.text("");
            writer.b(this.refName);
            writer.text(" cannot be resolved as reference or procedure.");
        } else {
            writer.b(this.refName);
            if (this.listOfDeclarations.size() > 1) {
                writer.text(" Mutliple declarations have been found.");
            }
            for (DeclarationInfo declInfo : this.listOfDeclarations) {
                writer.dl();
                switch (declInfo.getType()) {
                    case Parameter: {
                        writer.dt("Defined in: ");
                        writer.dd("Parameters Context.");
                        break;
                    }
                    case File: {
                        writer.dt("Defined in: ");
                        if (declInfo.getQ7NamedElementID().isEmpty()) {
                            writer.dd(" current script </b> as \"<b>" + declInfo.getDeclarationString() + "</b>\"");
                            break;
                        }
                        writer.dd(" another file </b> as \"<b>" + declInfo.getDeclarationString() + "<b>\"");
                        break;
                    }
                    case NonExisting: {
                        writer.dd("Cannot be resolved as reference or procedure.");
                    }
                }
                writer.close();
            }
        }
    }
}

