/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.tesla.internal.ui;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import org.eclipse.rcptt.reporting.core.ReportHelper;
import org.eclipse.rcptt.reporting.core.ReportManager;
import org.eclipse.rcptt.sherlock.core.INodeBuilder;
import org.eclipse.rcptt.tesla.core.am.rap.AspectManager;
import org.eclipse.rcptt.tesla.core.context.ContextManagement;
import org.eclipse.rcptt.tesla.core.info.Q7WaitInfoRoot;
import org.eclipse.rcptt.tesla.core.protocol.raw.SetMode;
import org.eclipse.rcptt.tesla.core.protocol.raw.TeslaMode;
import org.eclipse.rcptt.tesla.internal.core.network.server.ITeslaNetworkClientProcessor;
import org.eclipse.rcptt.tesla.internal.core.network.server.NetworkTeslaClient;
import org.eclipse.rcptt.tesla.internal.core.network.server.TeslaNetworkClientConnection;
import org.eclipse.rcptt.tesla.swt.events.ITeslaEventListener;
import org.eclipse.rcptt.tesla.swt.events.TeslaEventManager;
import org.eclipse.rcptt.tesla.ui.RWTUtils;

public class TeslaReplayNetworkClientProcessor
implements ITeslaNetworkClientProcessor {
    private NetworkTeslaClient client;
    private ITeslaEventListener listener = new ITeslaEventListener(){

        public boolean doProcessing(ContextManagement.Context currentContext) {
            if (TeslaReplayNetworkClientProcessor.this.client != null) {
                Q7WaitInfoRoot info = ReportHelper.getWaitInfo((INodeBuilder)ReportManager.getCurrentReportNode());
                TeslaReplayNetworkClientProcessor.this.client.processNext(currentContext, info);
            }
            return false;
        }

        public void hasEvent(TeslaEventManager.HasEventKind kind, String name) {
            if (TeslaReplayNetworkClientProcessor.this.client != null) {
                TeslaReplayNetworkClientProcessor.this.client.hasEvent(kind.name(), name, null);
            }
        }
    };

    public void activateMode(SetMode command, TeslaMode oldMode) {
        AspectManager.printInfo();
        if (command.getMode().equals((Object)TeslaMode.REPLAY)) {
            RWTUtils.findDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    TeslaEventManager.getManager().addEventListener(TeslaReplayNetworkClientProcessor.this.listener);
                    RWTUtils.findDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                        }
                    });
                }
            });
        } else {
            TeslaEventManager.getManager().removeEventListener(this.listener);
        }
    }

    public void initialize(TeslaNetworkClientConnection teslaNetworkClientConnection, DataInputStream din, DataOutputStream dout, NetworkTeslaClient teslaClient) {
        this.client = teslaClient;
    }

    public void terminate(boolean last) {
        TeslaEventManager.getManager().removeEventListener(this.listener);
        if (last) {
            this.client.clean();
        }
        this.client.shutdown();
    }

    public void setFeature(String name, String value) {
    }

    public void resetAssertSelection() {
    }
}

