/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ui.preferences;

import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.rcptt.ecl.internal.core.CorePlugin;
import org.eclipse.rcptt.internal.ui.Messages;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class ECLPreferenceEditorPage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Text textMaxLineWidth;
    private Text textIndent;

    public boolean performOk() {
        CorePlugin.setECLEditorLineWidth((int)Integer.parseInt(this.textMaxLineWidth.getText()));
        CorePlugin.setECLEditorIndent((int)Integer.parseInt(this.textIndent.getText()));
        return super.performOk();
    }

    protected void performDefaults() {
        this.textMaxLineWidth.setText(Integer.toString(120));
        this.textIndent.setText(Integer.toString(4));
        super.performDefaults();
    }

    public void init(IWorkbench workbench) {
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setLayoutData((Object)new GridData(1808));
        this.textMaxLineWidth = this.createText(composite, Messages.ECLPreferenceEditorPage_MaximumLineWidth, Integer.toString(CorePlugin.getECLEditorLineWidth()));
        this.textIndent = this.createText(composite, Messages.ECLPreferenceEditorPage_Indent, Integer.toString(CorePlugin.getECLEditorIndent()));
        return null;
    }

    private Text createText(Composite parent, String labelText, String initialValue) {
        Label label = new Label(parent, 16384);
        label.setText(labelText);
        Text text = new Text(parent, 2048);
        text.setText(initialValue);
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ECLPreferenceEditorPage.this.validate();
            }
        });
        text.setLayoutData((Object)new GridData(768));
        return text;
    }

    private void validate() {
        String message = this.doValidate();
        this.setErrorMessage(message);
        this.setValid(message == null);
    }

    private String doValidate() {
        if (!this.isValidInteger(this.textMaxLineWidth.getText(), 0, 9999)) {
            return String.valueOf(Messages.ECLPreferenceEditorPage_MaximumLineWidth) + " should be positive number between 0 and 9999";
        }
        if (!this.isValidInteger(this.textIndent.getText(), 0, 32)) {
            return String.valueOf(Messages.ECLPreferenceEditorPage_Indent) + " should be positive number between 0 and 32";
        }
        return null;
    }

    private boolean isValidInteger(String value, int min, int max) {
        try {
            int parsedValue = Integer.parseInt(value);
            if (parsedValue >= min && parsedValue <= max) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }
}

