/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.testrail;

import com.google.gson.JsonArray;
import java.net.URL;
import java.text.MessageFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.rcptt.internal.core.model.Q7TestCase;
import org.eclipse.rcptt.internal.launching.Executable;
import org.eclipse.rcptt.internal.launching.ExecutionSession;
import org.eclipse.rcptt.internal.launching.GroupExecutable;
import org.eclipse.rcptt.internal.launching.PrepareExecutionWrapper;
import org.eclipse.rcptt.internal.launching.ecl.EclScenarioExecutable;
import org.eclipse.rcptt.internal.testrail.Messages;
import org.eclipse.rcptt.internal.testrail.TestRailAPIClient;
import org.eclipse.rcptt.internal.testrail.TestRailParser;
import org.eclipse.rcptt.internal.testrail.TestRailPlugin;
import org.eclipse.rcptt.launching.ITestEngine;
import org.eclipse.rcptt.reporting.util.ReportUtils;
import org.eclipse.rcptt.sherlock.core.model.sherlock.report.Node;
import org.eclipse.rcptt.sherlock.core.model.sherlock.report.Report;
import org.eclipse.rcptt.testrail.TestRailStep;
import org.eclipse.rcptt.testrail.domain.TestRailStepResult;
import org.eclipse.rcptt.testrail.domain.TestRailTestCase;
import org.eclipse.rcptt.testrail.domain.TestRailTestResult;
import org.eclipse.rcptt.testrail.domain.TestRailTestRun;

public class TestRailService
implements ITestEngine {
    public static final String TESTRAIL_ID_PARAM = "testrail-id";
    public static final String TESTRAIL_PROJECTID_PREFIX = "P";
    public static final String TESTRAIL_TESTRUNID_PREFIX = "R";
    public static final String TESTRAIL_TESTCASEID_PREFIX = "C";
    private static final String TESTRAILCONFIG_ADDRESS_PARAM = "host";
    private static final String TESTRAILCONFIG_USERNAME_PARAM = "username";
    private static final String TESTRAILCONFIG_PASSWORD_PARAM = "password";
    private static final String TESTRAILCONFIG_PROJECTID_PARAM = "projectId";
    private static final String TESTRAILCONFIG_TESTRUNID_PARAM = "testRunId";
    private static final String TESTRAILCONFIG_USEUNICODE_PARAM = "useUnicode";
    private static final String TESTRESULT_CONTEXT_PREFIX = "__Contexts:__ ";
    private static final String TESTRESULT_FAILMSG_PREFIX = "__Fail message:__\n";
    private static final String TESTRUN_DEFAULT_NAME = "Tests";
    private static final String TESTRAILSTEP_PROPERTYNAME = "test-rail-step:{0}";
    private TestRailAPIClient testRailAPI;
    private boolean testRailEnabled;
    private String testRunId;
    private Map<String, String> config;

    public void testRunStarted(Map<String, String> config, List<Q7TestCase> tests) {
        this.applyConfig(config);
        if (this.testRunId != null) {
            return;
        }
        TestRailTestRun testRunDraft = this.createTestRunDraft(tests);
        if (testRunDraft == null) {
            return;
        }
        TestRailTestRun testRun = this.testRailAPI.addRun(testRunDraft);
        if (testRun != null) {
            this.testRunId = testRun.getId();
        }
    }

    public void testRunCompleted() {
        this.cleanConfig();
    }

    public void sessionStarted(ExecutionSession session) {
        if (this.config != null && !this.config.isEmpty()) {
            return;
        }
        this.applyDefaultConfig();
        if (!this.testRailEnabled) {
            return;
        }
        if (this.testRailAPI == null) {
            return;
        }
        String runId = this.getLaunchTestRunId(session);
        if (runId != null && !runId.equals("")) {
            this.testRunId = runId;
            return;
        }
        TestRailTestRun testRunDraft = this.createTestRunDraft(session);
        if (testRunDraft == null) {
            return;
        }
        TestRailTestRun testRun = this.testRailAPI.addRun(testRunDraft);
        if (testRun != null) {
            this.testRunId = testRun.getId();
        }
    }

    public void sessionCompleted(ExecutionSession session) {
    }

    public void executionStarted(EclScenarioExecutable scenario, Map<String, String> config) {
    }

    public void executionCompleted(EclScenarioExecutable scenario, Report report) {
        if (!this.testRailEnabled) {
            return;
        }
        if (this.testRailAPI == null) {
            return;
        }
        if (this.testRunId == null) {
            return;
        }
        TestRailTestResult testResultDraft = this.createTestResultDraft(scenario, report);
        if (testResultDraft == null) {
            return;
        }
        this.testRailAPI.addResultForTestCase(testResultDraft);
    }

    public String validateParameter(String name, String value) {
        if (name.equals(TESTRAILCONFIG_ADDRESS_PARAM)) {
            return this.validateUrl(value);
        }
        if (name.equals(TESTRAILCONFIG_PROJECTID_PARAM)) {
            return this.validateTestRailId(TESTRAIL_PROJECTID_PREFIX, value);
        }
        if (name.equals(TESTRAILCONFIG_TESTRUNID_PARAM)) {
            return this.validateTestRailId(TESTRAIL_TESTRUNID_PREFIX, value);
        }
        if (name.equals(TESTRAILCONFIG_USEUNICODE_PARAM)) {
            return this.validateBoolean(value);
        }
        return null;
    }

    public List<TestRailTestCase> getTestCases(boolean fillDescription) {
        this.applyDefaultConfig();
        if (this.testRailAPI == null) {
            return Collections.emptyList();
        }
        String response = this.testRailAPI.getTestCasesString();
        if (response == null) {
            return Collections.emptyList();
        }
        List<TestRailTestCase> testCases = TestRailAPIClient.getTestCasesList(response);
        if (fillDescription) {
            JsonArray array = TestRailAPIClient.getTestCasesJsonArray(response);
            TestRailParser.parseTestCases(testCases, array);
        }
        return testCases;
    }

    private void applyDefaultConfig() {
        this.testRunId = null;
        this.testRailEnabled = TestRailPlugin.getTestRailState();
        if (!this.testRailEnabled) {
            TestRailPlugin.logInfo(Messages.TestRailService_TestRailIsNotEnabled);
            this.testRailAPI = null;
            return;
        }
        String address = TestRailPlugin.getTestRailAddress();
        String username = TestRailPlugin.getTestRailUsername();
        String password = TestRailPlugin.getTestRailPassword();
        if (password == null) {
            TestRailPlugin.log(Messages.TestRailService_FailedToSetUpConnection);
            this.testRailAPI = null;
            return;
        }
        String projectId = TestRailPlugin.getTestRailProjectId();
        boolean useUnicode = TestRailPlugin.getTestRailUseUnicode();
        this.testRailAPI = new TestRailAPIClient(address, username, password, projectId);
        this.testRailAPI.setUseUnicode(useUnicode);
        TestRailPlugin.logInfo(Messages.TestRailService_SuccessfullyCreatedClient);
    }

    private void applyConfig(Map<String, String> config) {
        String address = config.get(TESTRAILCONFIG_ADDRESS_PARAM);
        String username = config.get(TESTRAILCONFIG_USERNAME_PARAM);
        String password = config.get(TESTRAILCONFIG_PASSWORD_PARAM);
        String projectId = config.get(TESTRAILCONFIG_PROJECTID_PARAM);
        String runId = config.get(TESTRAILCONFIG_TESTRUNID_PARAM);
        String useUnicode = config.get(TESTRAILCONFIG_USEUNICODE_PARAM);
        this.testRunId = runId != null && !runId.equals("") ? runId.substring(1) : null;
        this.testRailEnabled = true;
        this.testRailAPI = new TestRailAPIClient(address, username, password, projectId);
        if (useUnicode != null && !useUnicode.equals("")) {
            this.testRailAPI.setUseUnicode("true".equalsIgnoreCase(useUnicode));
        }
        this.config = config;
        TestRailPlugin.logInfo(Messages.TestRailService_SuccessfullyCreatedClient);
    }

    private void cleanConfig() {
        this.testRunId = null;
        this.testRailEnabled = false;
        this.testRailAPI = null;
        this.config = Collections.emptyMap();
    }

    private String getLaunchTestRunId(ExecutionSession session) {
        ILaunchConfiguration configuration = session.getLaunch().getLaunchConfiguration();
        String runId = "";
        try {
            runId = configuration.getAttribute("org.eclipse.rcptt.testrail.ATTR_TESTRAIL_TESTRUNID", "");
            if (!runId.equals("")) {
                return runId.substring(1);
            }
        }
        catch (CoreException e) {
            TestRailPlugin.log(MessageFormat.format(Messages.TestRailService_ErrorWhileGettingLaunchProperty, "org.eclipse.rcptt.testrail.ATTR_TESTRAIL_TESTRUNID"), e);
        }
        return null;
    }

    private TestRailTestRun createTestRunDraft(ExecutionSession session) {
        String name = this.getTestRunName(session.getName());
        Set<String> caseIds = this.getTestRunCaseIds(session);
        if (caseIds.isEmpty()) {
            return null;
        }
        TestRailTestRun testRunDraft = new TestRailTestRun();
        testRunDraft.setName(name);
        testRunDraft.setIncludeAll(false);
        testRunDraft.setCaseIds(caseIds);
        return testRunDraft;
    }

    private TestRailTestRun createTestRunDraft(List<Q7TestCase> tests) {
        String name = this.getTestRunName(TESTRUN_DEFAULT_NAME);
        Set<String> caseIds = tests.stream().map(test -> this.getTestRailId((Q7TestCase)test)).filter(testRailId -> testRailId != null && !testRailId.equals("")).collect(Collectors.toSet());
        if (caseIds.isEmpty()) {
            return null;
        }
        TestRailTestRun testRunDraft = new TestRailTestRun();
        testRunDraft.setName(name);
        testRunDraft.setIncludeAll(false);
        testRunDraft.setCaseIds(caseIds);
        return testRunDraft;
    }

    private TestRailTestResult createTestResultDraft(EclScenarioExecutable scenario, Report report) {
        Q7TestCase testCase = (Q7TestCase)scenario.getActualElement();
        String testCaseId = this.getTestRailId(testCase);
        if (testCaseId == null) {
            return null;
        }
        String testCaseStatus = this.getTestRailStatus(scenario);
        if (testCaseStatus == null) {
            TestRailPlugin.logInfo(Messages.TestRailService_TestCaseCanceled);
            return null;
        }
        String testCaseDuration = this.getTestRailDuration(report);
        String testCaseComment = this.getTestRailComment(scenario, report);
        List<TestRailStepResult> stepResults = this.getTestRailStepResults(report);
        TestRailTestResult testResultDraft = new TestRailTestResult();
        testResultDraft.setRunId(this.testRunId);
        testResultDraft.setCaseId(testCaseId);
        testResultDraft.setStatus(testCaseStatus);
        testResultDraft.setElapsed(testCaseDuration);
        testResultDraft.setComment(testCaseComment);
        testResultDraft.setStepResults(stepResults);
        return testResultDraft;
    }

    private EclScenarioExecutable getScenario(Executable wrapper) {
        Executable scenario;
        Executable executable;
        if (wrapper instanceof PrepareExecutionWrapper && (executable = ((PrepareExecutionWrapper)wrapper).getExecutable()) instanceof GroupExecutable && (scenario = ((GroupExecutable)executable).getRoot()) instanceof EclScenarioExecutable) {
            return (EclScenarioExecutable)scenario;
        }
        return null;
    }

    private String getTestRailId(Q7TestCase testCase) {
        String testCaseId;
        block5: {
            block4: {
                try {
                    testCaseId = (String)testCase.getProperties().get(TESTRAIL_ID_PARAM);
                    if (testCaseId != null) break block4;
                    TestRailPlugin.logInfo(MessageFormat.format(Messages.TestRailService_TestCasePropertyIsNotSpecified, TESTRAIL_ID_PARAM));
                    return null;
                }
                catch (Exception e) {
                    TestRailPlugin.log(MessageFormat.format(Messages.TestRailService_ErrorWhileGettingTestCaseProperty, TESTRAIL_ID_PARAM), e);
                    return null;
                }
            }
            String message = this.validateTestRailId(TESTRAIL_TESTCASEID_PREFIX, testCaseId);
            if (message == null) break block5;
            TestRailPlugin.log(MessageFormat.format(Messages.TestRailService_InvalidParameterValue, TESTRAIL_ID_PARAM, message));
            return null;
        }
        return testCaseId.substring(1);
    }

    private String getTestRunName(String name) {
        DateTimeFormatter dateFormatter = DateTimeFormatter.ofPattern("MM/dd/yyyy HH:mm");
        LocalDateTime localDate = LocalDateTime.now();
        return MessageFormat.format("{0} {1}", name, dateFormatter.format(localDate));
    }

    private Set<String> getTestRunCaseIds(ExecutionSession session) {
        Executable[] executables = session.getExecutables();
        List testCases = Arrays.stream(executables).map(wrapper -> (Q7TestCase)this.getScenario((Executable)wrapper).getActualElement()).filter(testCase -> testCase != null).collect(Collectors.toList());
        Set<String> caseIds = testCases.stream().map(scenario -> this.getTestRailId((Q7TestCase)scenario)).filter(testRailId -> testRailId != null && !testRailId.equals("")).collect(Collectors.toSet());
        return caseIds;
    }

    private String getTestRailDuration(Report report) {
        Node reportRoot = report.getRoot();
        long duration = reportRoot.getDuration() / 1000L;
        if (duration != 0L) {
            return MessageFormat.format("{0}s", String.format("%d", duration));
        }
        return null;
    }

    private String getTestRailStatus(EclScenarioExecutable scenario) {
        int severity = scenario.getResultStatus().getSeverity();
        switch (severity) {
            case 0: 
            case 1: {
                return "1";
            }
            case 2: 
            case 4: {
                return "5";
            }
            case 8: {
                return null;
            }
        }
        return null;
    }

    private String getTestRailComment(EclScenarioExecutable scenario, Report report) {
        int testCaseSeveriry;
        String testCaseComment = "";
        List variantName = scenario.getVariantName();
        if (variantName != null && !variantName.isEmpty()) {
            String contextNames = variantName.stream().collect(Collectors.joining(", ")).toString();
            testCaseComment = TESTRESULT_CONTEXT_PREFIX + contextNames;
        }
        if ((testCaseSeveriry = scenario.getResultStatus().getSeverity()) == 4) {
            if (!testCaseComment.equals("")) {
                testCaseComment = String.valueOf(testCaseComment) + "\n\n";
            }
            Node reportRoot = report.getRoot();
            testCaseComment = String.valueOf(testCaseComment) + TESTRESULT_FAILMSG_PREFIX + ReportUtils.getFailMessage((Node)reportRoot);
        }
        return testCaseComment;
    }

    private List<TestRailStepResult> getTestRailStepResults(Report report) {
        Node reportRoot = report.getRoot();
        ArrayList<TestRailStepResult> results = new ArrayList<TestRailStepResult>();
        EMap props = reportRoot.getProperties();
        int id = 1;
        String prop = this.generateStepName(id);
        while (props.get((Object)prop) != null) {
            EObject obj = (EObject)props.get((Object)prop);
            if (obj instanceof TestRailStep) {
                TestRailStep step = (TestRailStep)obj;
                TestRailStepResult result = new TestRailStepResult();
                result.setContent(step.getContent());
                result.setExpected(step.getExpected());
                result.setActual(step.getActual());
                int status = step.getStatus().getValue();
                if (status != 3) {
                    result.setStatus(String.valueOf(status));
                }
                results.add(result);
            }
            prop = this.generateStepName(++id);
        }
        return results;
    }

    private String generateStepName(int id) {
        return MessageFormat.format(TESTRAILSTEP_PROPERTYNAME, String.valueOf(id));
    }

    private String validateTestRailId(String prefix, String value) {
        String message = MessageFormat.format(Messages.TestRailService_InvalidTestRailId, prefix);
        if (!value.startsWith(prefix)) {
            return message;
        }
        try {
            String idString = value.substring(1);
            int parsedValue = Integer.parseInt(idString);
            if (parsedValue <= 0) {
                return message;
            }
        }
        catch (Exception exception) {
            return message;
        }
        return null;
    }

    private String validateUrl(String value) {
        try {
            URL url = new URL(value);
            if (url.getHost().equals("")) {
                return Messages.TestRailService_InvalidURL;
            }
        }
        catch (Exception exception) {
            return Messages.TestRailService_InvalidURL;
        }
        if (!value.endsWith("/")) {
            return Messages.TestRailService_URLShouldEndsWithSlash;
        }
        return null;
    }

    private String validateBoolean(String value) {
        if (!"true".equalsIgnoreCase(value) && !"false".equalsIgnoreCase(value)) {
            return Messages.TestRailService_InvalidBoolean;
        }
        return null;
    }

    public void setConfiguration(Map<String, String> config) {
    }

    public Map<String, String> getConfiguration() {
        return new HashMap<String, String>();
    }
}

