/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jetty.http.ComplianceViolation;

public class MultiPartCompliance
implements ComplianceViolation.Mode {
    public static final MultiPartCompliance RFC7578 = new MultiPartCompliance("RFC7578", EnumSet.of(Violation.CONTENT_TRANSFER_ENCODING));
    private static final List<MultiPartCompliance> KNOWN_MODES = Arrays.asList(RFC7578);
    private final String name;
    private final Set<Violation> violations;

    public static MultiPartCompliance valueOf(String name) {
        for (MultiPartCompliance compliance : KNOWN_MODES) {
            if (!compliance.getName().equals(name)) continue;
            return compliance;
        }
        return null;
    }

    public MultiPartCompliance(String name, Set<Violation> violations) {
        this.name = name;
        this.violations = violations;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean allows(ComplianceViolation violation) {
        return this.violations.contains(violation);
    }

    @Override
    public Set<? extends ComplianceViolation> getKnown() {
        return EnumSet.allOf(Violation.class);
    }

    @Override
    public Set<? extends ComplianceViolation> getAllowed() {
        return this.violations;
    }

    public String toString() {
        return String.format("%s@%x%s", this.name, this.hashCode(), this.violations);
    }

    public static enum Violation implements ComplianceViolation
    {
        CONTENT_TRANSFER_ENCODING("https://tools.ietf.org/html/rfc7578#section-4.7", "Content-Transfer-Encoding is deprecated");

        private final String url;
        private final String description;

        private Violation(String url, String description) {
            this.url = url;
            this.description = description;
        }

        @Override
        public String getName() {
            return this.name();
        }

        @Override
        public String getURL() {
            return this.url;
        }

        @Override
        public String getDescription() {
            return this.description;
        }
    }
}

