/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.shared.target;

import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.operations.RepositoryTracker;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepositoryManager;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;
import org.eclipse.equinox.p2.ui.ProvisioningUI;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.pde.core.target.ITargetDefinition;
import org.eclipse.pde.core.target.ITargetHandle;
import org.eclipse.pde.core.target.ITargetLocation;
import org.eclipse.pde.internal.core.target.IUBundleContainer;
import org.eclipse.pde.internal.core.target.P2TargetUtils;
import org.eclipse.pde.internal.ui.shared.target.EditBundleContainerWizard;
import org.eclipse.pde.internal.ui.shared.target.IUContentProvider;
import org.eclipse.pde.internal.ui.shared.target.Messages;
import org.eclipse.pde.internal.ui.shared.target.StyledBundleLabelProvider;
import org.eclipse.pde.ui.target.ITargetLocationHandler;

public class IUFactory
implements IAdapterFactory,
ITargetLocationHandler {
    private static final Status STATUS_NO_CHANGE = new Status(0, "org.eclipse.pde.core", 101, "", null);
    private static final Status STATUS_FORCE_RELOAD = new Status(0, "org.eclipse.pde.core", 102, "", null);
    private ILabelProvider fLabelProvider;
    private ITreeContentProvider fContentProvider;

    public Class<?>[] getAdapterList() {
        return new Class[]{ILabelProvider.class, ITreeContentProvider.class, ITargetLocationHandler.class};
    }

    public <T> T getAdapter(Object adaptableObject, Class<T> adapterType) {
        if (adaptableObject instanceof IUBundleContainer) {
            if (adapterType == ILabelProvider.class) {
                return (T)this.getLabelProvider();
            }
            if (adapterType == ITreeContentProvider.class) {
                return (T)this.getContentProvider();
            }
            if (adapterType == ITargetLocationHandler.class) {
                return (T)this;
            }
        } else if (adaptableObject instanceof IUContentProvider.IUWrapper) {
            if (adapterType == ILabelProvider.class) {
                return (T)this.getLabelProvider();
            }
            if (adapterType == ITargetLocationHandler.class) {
                return (T)this;
            }
        }
        return null;
    }

    @Override
    public boolean canEdit(ITargetDefinition target, TreePath path) {
        Object segment = path.getLastSegment();
        return segment instanceof IUBundleContainer || segment instanceof IUContentProvider.IUWrapper;
    }

    @Override
    public IWizard getEditWizard(ITargetDefinition target, TreePath path) {
        Object segment = path.getFirstSegment();
        if (segment instanceof IUBundleContainer) {
            return new EditBundleContainerWizard(target, (ITargetLocation)segment);
        }
        return null;
    }

    @Override
    public IStatus update(ITargetDefinition target, TreePath[] treePaths, IProgressMonitor monitor) {
        HashSet<IUBundleContainer> containers = new HashSet<IUBundleContainer>();
        HashMap<IUBundleContainer, Set> wrappersMap = new HashMap<IUBundleContainer, Set>();
        TreePath[] treePathArray = treePaths;
        int n = treePaths.length;
        int n2 = 0;
        while (n2 < n) {
            TreePath path = treePathArray[n2];
            Object lastSegment = path.getLastSegment();
            if (lastSegment instanceof IUBundleContainer) {
                containers.add((IUBundleContainer)lastSegment);
            } else if (lastSegment instanceof IUContentProvider.IUWrapper) {
                IUContentProvider.IUWrapper wrapper = (IUContentProvider.IUWrapper)lastSegment;
                wrappersMap.computeIfAbsent(wrapper.getParent(), k -> new HashSet()).add(wrapper.getIU().getId());
            }
            ++n2;
        }
        HashMap<IUBundleContainer, IUBundleContainer> updatedContainer = new HashMap<IUBundleContainer, IUBundleContainer>();
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)((containers.size() + wrappersMap.size()) * 100));
        for (IUBundleContainer iUBundleContainer : containers) {
            try {
                IUBundleContainer update = iUBundleContainer.update(Collections.emptySet(), (IProgressMonitor)subMonitor.split(100));
                updatedContainer.put(iUBundleContainer, update);
            }
            catch (CoreException e) {
                return e.getStatus();
            }
        }
        for (Map.Entry entry : wrappersMap.entrySet()) {
            IUBundleContainer container = (IUBundleContainer)entry.getKey();
            if (containers.contains(container)) continue;
            try {
                IUBundleContainer update = container.update((Set)entry.getValue(), (IProgressMonitor)subMonitor.split(100));
                updatedContainer.put(container, update);
            }
            catch (CoreException e) {
                return e.getStatus();
            }
        }
        if (updatedContainer.isEmpty()) {
            return Status.OK_STATUS;
        }
        ITargetLocation[] iTargetLocationArray = target.getTargetLocations();
        int i = 0;
        while (i < iTargetLocationArray.length) {
            IUBundleContainer updated = (IUBundleContainer)updatedContainer.remove(iTargetLocationArray[i]);
            if (updated != null) {
                iTargetLocationArray[i] = updated;
            }
            ++i;
        }
        target.setTargetLocations(iTargetLocationArray);
        return STATUS_NO_CHANGE;
    }

    @Override
    public boolean canRemove(ITargetDefinition target, TreePath treePath) {
        boolean isValidRoot = treePath.getFirstSegment() instanceof IUBundleContainer;
        if (treePath.getSegmentCount() == 1) {
            return isValidRoot;
        }
        return isValidRoot && treePath.getLastSegment() instanceof IUContentProvider.IUWrapper;
    }

    @Override
    public boolean canUpdate(ITargetDefinition target, TreePath treePath) {
        Object lastSegment = treePath.getLastSegment();
        return lastSegment instanceof IUBundleContainer || lastSegment instanceof IUContentProvider.IUWrapper;
    }

    @Override
    public IStatus remove(ITargetDefinition target, TreePath[] treePaths) {
        boolean forceReload = false;
        TreePath[] treePathArray = treePaths;
        int n = treePaths.length;
        int n2 = 0;
        while (n2 < n) {
            TreePath treePath = treePathArray[n2];
            Object segment = treePath.getLastSegment();
            if (segment instanceof IUBundleContainer) {
                forceReload = true;
            } else if (segment instanceof IUContentProvider.IUWrapper) {
                IUContentProvider.IUWrapper wrapper = (IUContentProvider.IUWrapper)segment;
                wrapper.getParent().removeInstallableUnit(wrapper.getIU());
            }
            ++n2;
        }
        return forceReload ? STATUS_FORCE_RELOAD : Status.OK_STATUS;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public IStatus reload(ITargetDefinition target, ITargetLocation[] targetLocations, IProgressMonitor monitor) {
        try {
            SubMonitor convert = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
            convert.setTaskName(Messages.IUFactory_taskDeleteProfile);
            P2TargetUtils.forceCheckTarget((ITargetDefinition)target);
            P2TargetUtils.deleteProfile((ITargetHandle)target.getHandle());
            convert.worked(25);
            IProvisioningAgent agent = P2TargetUtils.getAgent();
            IArtifactRepositoryManager artifactRepositoryManager = (IArtifactRepositoryManager)agent.getService(IArtifactRepositoryManager.class);
            IMetadataRepositoryManager metadataRepositoryManager = (IMetadataRepositoryManager)agent.getService(IMetadataRepositoryManager.class);
            ProvisioningUI ui = ProvisioningUI.getDefaultUI();
            ui.signalRepositoryOperationStart();
            try {
                RepositoryTracker repositoryTracker = ui.getRepositoryTracker();
                convert.setTaskName(Messages.IUFactory_taskRefreshRepositories);
                MultiStatus reloadStatus = new MultiStatus(IUFactory.class, 0, Messages.IUFactory_errorRefreshRepositories);
                ITargetLocation[] iTargetLocationArray = targetLocations;
                int n = targetLocations.length;
                int n2 = 0;
                while (n2 < n) {
                    IUBundleContainer iu;
                    URI[] repositories;
                    ITargetLocation targetLocation = iTargetLocationArray[n2];
                    if (targetLocation instanceof IUBundleContainer && (repositories = (iu = (IUBundleContainer)targetLocation).getRepositories()) != null) {
                        convert.setWorkRemaining(repositories.length * 2);
                        URI[] uRIArray = repositories;
                        int n3 = repositories.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            block26: {
                                URI repositoryUri = uRIArray[n4];
                                repositoryTracker.clearRepositoryNotFound(repositoryUri);
                                try {
                                    if (artifactRepositoryManager != null) {
                                        boolean contains = artifactRepositoryManager.contains(repositoryUri);
                                        if (!contains) {
                                            artifactRepositoryManager.addRepository(repositoryUri);
                                        }
                                        try {
                                            artifactRepositoryManager.refreshRepository(repositoryUri, (IProgressMonitor)convert.split(1));
                                        }
                                        finally {
                                            if (!contains) {
                                                artifactRepositoryManager.removeRepository(repositoryUri);
                                            }
                                        }
                                    }
                                    if (metadataRepositoryManager == null) break block26;
                                    boolean contains = metadataRepositoryManager.contains(repositoryUri);
                                    if (!contains) {
                                        metadataRepositoryManager.addRepository(repositoryUri);
                                    }
                                    try {
                                        metadataRepositoryManager.refreshRepository(repositoryUri, (IProgressMonitor)convert.split(1));
                                    }
                                    finally {
                                        metadataRepositoryManager.removeRepository(repositoryUri);
                                    }
                                }
                                catch (CoreException e) {
                                    IStatus error = e.getStatus();
                                    if (error.getCode() == 1000) {
                                        repositoryTracker.addNotFound(repositoryUri);
                                    }
                                    reloadStatus.add(error);
                                }
                            }
                            ++n4;
                        }
                    }
                    ++n2;
                }
                if (reloadStatus.isOK()) {
                    IStatus iStatus = Status.OK_STATUS;
                    return iStatus;
                }
                IStatus[] children = reloadStatus.getChildren();
                if (children.length == 1) {
                    IStatus iStatus = children[0];
                    return iStatus;
                }
                MultiStatus multiStatus = reloadStatus;
                return multiStatus;
            }
            finally {
                ui.signalRepositoryOperationComplete(null, false);
            }
        }
        catch (CoreException e) {
            return e.getStatus();
        }
    }

    private ILabelProvider getLabelProvider() {
        if (this.fLabelProvider == null) {
            this.fLabelProvider = new StyledBundleLabelProvider(true, false);
        }
        return this.fLabelProvider;
    }

    private ITreeContentProvider getContentProvider() {
        if (this.fContentProvider == null) {
            this.fContentProvider = new IUContentProvider();
        }
        return this.fContentProvider;
    }
}

