/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.lucene.index.IndexReaderContext;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermState;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.TaskExecutor;

public final class TermStates {
    private static final TermState EMPTY_TERMSTATE = new TermState(){

        @Override
        public void copyFrom(TermState other) {
        }
    };
    private final Object topReaderContextIdentity;
    private final TermState[] states;
    private final Term term;
    private int docFreq;
    private long totalTermFreq;

    private TermStates(Term term, IndexReaderContext context) {
        assert (context != null && context.isTopLevel);
        this.topReaderContextIdentity = context.identity;
        this.docFreq = 0;
        this.totalTermFreq = 0L;
        this.states = new TermState[context.leaves().size()];
        this.term = term;
    }

    public TermStates(IndexReaderContext context) {
        this(null, context);
    }

    public boolean wasBuiltFor(IndexReaderContext context) {
        return this.topReaderContextIdentity == context.identity;
    }

    public TermStates(IndexReaderContext context, TermState state, int ord, int docFreq, long totalTermFreq) {
        this(null, context);
        this.register(state, ord, docFreq, totalTermFreq);
    }

    public static TermStates build(IndexSearcher indexSearcher, Term term, boolean needsStats) throws IOException {
        IndexReaderContext context = indexSearcher.getTopReaderContext();
        assert (context != null);
        TermStates perReaderTermState = new TermStates(needsStats ? null : term, context);
        if (needsStats) {
            TaskExecutor taskExecutor = indexSearcher.getTaskExecutor();
            ArrayList tasks = new ArrayList(context.leaves().size());
            for (LeafReaderContext ctx : context.leaves()) {
                tasks.add(() -> {
                    TermsEnum termsEnum = TermStates.loadTermsEnum(ctx, term);
                    return termsEnum == null ? null : new TermStateInfo(termsEnum.termState(), ctx.ord, termsEnum.docFreq(), termsEnum.totalTermFreq());
                });
            }
            List resultInfos = taskExecutor.invokeAll(tasks);
            for (TermStateInfo info : resultInfos) {
                if (info == null) continue;
                perReaderTermState.register(info.getState(), info.getOrdinal(), info.getDocFreq(), info.getTotalTermFreq());
            }
        }
        return perReaderTermState;
    }

    private static TermsEnum loadTermsEnum(LeafReaderContext ctx, Term term) throws IOException {
        Terms terms = Terms.getTerms(ctx.reader(), term.field());
        TermsEnum termsEnum = terms.iterator();
        if (termsEnum.seekExact(term.bytes())) {
            return termsEnum;
        }
        return null;
    }

    public void clear() {
        this.docFreq = 0;
        this.totalTermFreq = 0L;
        Arrays.fill(this.states, null);
    }

    public void register(TermState state, int ord, int docFreq, long totalTermFreq) {
        this.register(state, ord);
        this.accumulateStatistics(docFreq, totalTermFreq);
    }

    public void register(TermState state, int ord) {
        assert (state != null) : "state must not be null";
        assert (ord >= 0 && ord < this.states.length);
        assert (this.states[ord] == null) : "state for ord: " + ord + " already registered";
        this.states[ord] = state;
    }

    public void accumulateStatistics(int docFreq, long totalTermFreq) {
        assert (docFreq >= 0);
        assert (totalTermFreq >= 0L);
        assert ((long)docFreq <= totalTermFreq);
        this.docFreq += docFreq;
        this.totalTermFreq += totalTermFreq;
    }

    public TermState get(LeafReaderContext ctx) throws IOException {
        assert (ctx.ord >= 0 && ctx.ord < this.states.length);
        if (this.term == null) {
            return this.states[ctx.ord];
        }
        if (this.states[ctx.ord] == null) {
            TermsEnum te = TermStates.loadTermsEnum(ctx, this.term);
            TermState termState = this.states[ctx.ord] = te == null ? EMPTY_TERMSTATE : te.termState();
        }
        if (this.states[ctx.ord] == EMPTY_TERMSTATE) {
            return null;
        }
        return this.states[ctx.ord];
    }

    public int docFreq() {
        if (this.term != null) {
            throw new IllegalStateException("Cannot call docFreq() when needsStats=false");
        }
        return this.docFreq;
    }

    public long totalTermFreq() {
        if (this.term != null) {
            throw new IllegalStateException("Cannot call totalTermFreq() when needsStats=false");
        }
        return this.totalTermFreq;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("TermStates\n");
        for (TermState termState : this.states) {
            sb.append("  state=");
            sb.append(termState);
            sb.append('\n');
        }
        return sb.toString();
    }

    private static final class TermStateInfo {
        private final TermState state;
        private final int ordinal;
        private final int docFreq;
        private final long totalTermFreq;

        public TermStateInfo(TermState state, int ordinal, int docFreq, long totalTermFreq) {
            this.state = state;
            this.ordinal = ordinal;
            this.docFreq = docFreq;
            this.totalTermFreq = totalTermFreq;
        }

        public TermState getState() {
            return this.state;
        }

        public int getOrdinal() {
            return this.ordinal;
        }

        public int getDocFreq() {
            return this.docFreq;
        }

        public long getTotalTermFreq() {
            return this.totalTermFreq;
        }
    }
}

