/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.util;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.pde.internal.core.util.PDEHTMLHelper;

public class PDETextHelper {
    public static final String F_DOTS = "...";

    public static String truncateAndTrailOffText(String text, int limit) {
        String trimmed = text.trim();
        int dotsLength = F_DOTS.length();
        int trimmedLength = trimmed.length();
        int limitWithDots = limit - dotsLength;
        if (limit >= trimmedLength) {
            return trimmed;
        }
        if (limit <= dotsLength) {
            return "";
        }
        return trimmed.substring(0, limitWithDots) + F_DOTS;
    }

    public static boolean isDefined(String text) {
        return text != null && !text.isEmpty();
    }

    public static boolean isDefinedAfterTrim(String text) {
        if (text == null) {
            return false;
        }
        String trimmedText = text.trim();
        return !trimmedText.isEmpty();
    }

    public static String translateReadText(String text) {
        if (text == null) {
            return "";
        }
        String inputText = text.trim();
        int length = inputText.length();
        int previousChar = 32;
        StringBuilder buffer = new StringBuilder(length);
        int i = 0;
        while (i < length) {
            int currentChar = inputText.charAt(i);
            if (currentChar == 13 || currentChar == 10 || currentChar == 9) {
                currentChar = 32;
            }
            if (currentChar == 32) {
                if (previousChar != 32) {
                    buffer.append((char)currentChar);
                    previousChar = currentChar;
                }
            } else {
                buffer.append((char)currentChar);
                previousChar = currentChar;
            }
            ++i;
        }
        String result = buffer.toString();
        if (PDEHTMLHelper.isAllWhitespace(result)) {
            return "";
        }
        return result;
    }

    public static String translateWriteText(String text, HashMap<Character, String> substituteChars) {
        return PDETextHelper.translateWriteText(text, null, substituteChars);
    }

    public static String translateWriteText(String text, HashSet<String> tagExceptions, HashMap<Character, String> substituteChars) {
        if (text == null) {
            return "";
        }
        boolean processTagExceptions = false;
        if (tagExceptions != null && !tagExceptions.isEmpty()) {
            processTagExceptions = true;
        }
        boolean processSubstituteChars = false;
        if (substituteChars != null && !substituteChars.isEmpty()) {
            processSubstituteChars = true;
        }
        StringBuilder buffer = new StringBuilder(text.length());
        IntegerPointer index = new IntegerPointer(0);
        while (index.getInteger() < text.length()) {
            char currentChar = text.charAt(index.getInteger());
            boolean processed = false;
            if (!processed && processTagExceptions) {
                processed = PDETextHelper.processTagExceptions(currentChar, substituteChars, tagExceptions, buffer, text, index);
            }
            if (!processed && processSubstituteChars) {
                processed = PDETextHelper.processSubstituteChars(currentChar, substituteChars, buffer);
            }
            if (!processed) {
                buffer.append(currentChar);
            }
            index.increment();
        }
        return buffer.toString();
    }

    private static boolean processSubstituteChars(char currentChar, Map<Character, String> substituteChars, StringBuilder buffer) {
        Character character = Character.valueOf(currentChar);
        if (substituteChars.containsKey(character)) {
            String value = substituteChars.get(character);
            if (PDETextHelper.isDefined(value)) {
                buffer.append(value);
            }
            return true;
        }
        return false;
    }

    private static boolean processTagExceptions(char currentChar, Map<Character, String> substituteChars, Set<String> tagExceptions, StringBuilder buffer, String text, IntegerPointer index) {
        if (currentChar == '<') {
            int limit = text.length();
            StringBuilder parsedText = new StringBuilder();
            int j = index.getInteger() + 1;
            while (j < limit) {
                char futureChar = text.charAt(j);
                if (futureChar == '>') {
                    String futureBuffer = parsedText.toString();
                    if (PDETextHelper.isValidTagException(tagExceptions, futureBuffer)) {
                        PDETextHelper.processTagExceptionCharacters(substituteChars, buffer, futureBuffer);
                        index.setInteger(j);
                        return true;
                    }
                    return false;
                }
                parsedText.append(futureChar);
                ++j;
            }
        }
        return false;
    }

    private static void processTagExceptionCharacters(Map<Character, String> substituteChars, StringBuilder buffer, String text) {
        String tagName = PDETextHelper.getTagName(text);
        boolean trailingSlash = text.endsWith("/");
        String attributeList = text.substring(tagName.length());
        if (!PDETextHelper.isValidTagAttributeList(attributeList)) {
            buffer.append('<');
            buffer.append(tagName);
            if (trailingSlash) {
                buffer.append('/');
            }
            buffer.append('>');
            return;
        }
        if (attributeList.isEmpty()) {
            buffer.append('<');
            buffer.append(tagName);
            buffer.append('>');
            return;
        }
        boolean inQuote = false;
        buffer.append('<');
        int i = 0;
        while (i < text.length()) {
            boolean onQuote;
            boolean processed = false;
            char currentChar = text.charAt(i);
            boolean bl = onQuote = currentChar == '\"';
            if (onQuote) {
                inQuote = !inQuote;
            }
            if (inQuote && !onQuote) {
                processed = PDETextHelper.processSubstituteChars(currentChar, substituteChars, buffer);
            }
            if (!processed) {
                buffer.append(currentChar);
            }
            ++i;
        }
        buffer.append('>');
    }

    private static boolean isValidTagException(Set<String> tagExceptions, String buffer) {
        String tagName = PDETextHelper.getTagName(buffer);
        return tagExceptions.contains(tagName);
    }

    private static boolean isValidTagAttributeList(String text) {
        String patternString = "^([\\s]+[A-Za-z0-9_:\\-\\.]+[\\s]?=[\\s]?\".+?\")*[\\s]*[/]?$";
        Pattern pattern = Pattern.compile(patternString);
        Matcher matcher = pattern.matcher(text);
        return matcher.find();
    }

    private static String getTagName(String buffer) {
        StringBuilder tagName = new StringBuilder();
        int i = 0;
        while (i < buffer.length()) {
            char character = buffer.charAt(i);
            if (Character.isWhitespace(character)) break;
            tagName.append(character);
            ++i;
        }
        return tagName.toString();
    }

    private static class IntegerPointer {
        private int fInteger;

        public IntegerPointer(int integer) {
            this.fInteger = integer;
        }

        public int getInteger() {
            return this.fInteger;
        }

        public void setInteger(int integer) {
            this.fInteger = integer;
        }

        public void increment() {
            ++this.fInteger;
        }
    }
}

