/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.tesla.gef;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.EventDispatcher;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LightweightSystem;
import org.eclipse.gef.EditDomain;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.palette.PaletteContainer;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.palette.ToolEntry;
import org.eclipse.gef.ui.palette.PaletteViewer;
import org.eclipse.gef.ui.parts.GraphicalViewerImpl;
import org.eclipse.rcptt.tesla.core.protocol.ElementKind;
import org.eclipse.rcptt.tesla.core.protocol.GenericElementKind;
import org.eclipse.rcptt.tesla.internal.ui.player.SWTUIElement;
import org.eclipse.rcptt.tesla.internal.ui.player.SWTUIPlayer;
import org.eclipse.rcptt.tesla.internal.ui.player.TeslaSWTAccess;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Widget;

public class DiagramViewerUIElement
extends SWTUIElement {
    private GraphicalViewer viewer;
    private Canvas canvas;
    private EventDispatcher dispatcher;
    private EditPartFactory factory;
    private EditDomain domain;

    public DiagramViewerUIElement(SWTUIPlayer p, GraphicalViewer viewer) {
        super((Widget)viewer.getControl(), p);
        this.viewer = viewer;
        this.canvas = (Canvas)viewer.getControl();
        if (this.canvas instanceof FigureCanvas) {
            this.dispatcher = ((FigureCanvas)this.canvas).getLightweightSystem().getRootFigure().internalGetEventDispatcher();
        } else if (viewer instanceof GraphicalViewerImpl) {
            LightweightSystem lws;
            this.dispatcher = (EventDispatcher)TeslaSWTAccess.getField(EventDispatcher.class, (Object)viewer, (String)"eventDispatcher");
            if (this.dispatcher == null && (lws = (LightweightSystem)TeslaSWTAccess.getField(LightweightSystem.class, (Object)viewer, (String)"lws")) != null) {
                this.dispatcher = lws.getRootFigure().internalGetEventDispatcher();
            }
        }
        this.factory = viewer.getEditPartFactory();
        this.domain = viewer.getEditDomain();
    }

    public GenericElementKind getKind() {
        return new GenericElementKind(ElementKind.DiagramViewer);
    }

    public EventDispatcher getDispatcher() {
        return this.dispatcher;
    }

    public EditDomain getDomain() {
        return this.domain;
    }

    public EditPartFactory getFactory() {
        return this.factory;
    }

    public Canvas getCanvas() {
        return this.canvas;
    }

    public GraphicalViewer getViewer() {
        return this.viewer;
    }

    public List<ToolEntry> listToolbarEntries() {
        PaletteViewer paletteViewer = this.domain.getPaletteViewer();
        ArrayList<ToolEntry> entries = new ArrayList<ToolEntry>();
        if (paletteViewer != null) {
            PaletteRoot root = paletteViewer.getPaletteRoot();
            this.fillPaletteFrom((PaletteContainer)root, entries);
        }
        return entries;
    }

    private void fillPaletteFrom(PaletteContainer root, List<ToolEntry> entries) {
        List children = root.getChildren();
        for (Object object : children) {
            if (object instanceof PaletteContainer) {
                PaletteContainer con = (PaletteContainer)object;
                this.fillPaletteFrom(con, entries);
                continue;
            }
            if (!(object instanceof ToolEntry)) continue;
            entries.add((ToolEntry)object);
        }
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.canvas == null ? 0 : this.canvas.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        DiagramViewerUIElement other = (DiagramViewerUIElement)((Object)obj);
        return !(this.canvas == null ? other.canvas != null : !this.canvas.equals(other.canvas));
    }

    public IFigure getFigureContents() {
        LightweightSystem lws;
        if (this.canvas instanceof FigureCanvas) {
            return ((FigureCanvas)this.canvas).getContents();
        }
        if (this.viewer instanceof GraphicalViewerImpl && (lws = (LightweightSystem)TeslaSWTAccess.getField(LightweightSystem.class, (Object)this.viewer, (String)"lws")) != null) {
            return lws.getRootFigure();
        }
        return null;
    }
}

