/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.base.remote;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.SecureRandom;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;

public class HttpsUtility {
    private static final String PATH_TOC = "/toc";
    private static final String PARAM_LANG = "lang";
    private static final int SOCKET_TIMEOUT = 5000;

    public static HttpsURLConnection getConnection(URL httpsURL) {
        try {
            SSLContext sc = SSLContext.getInstance("TLS");
            sc.init(null, null, new SecureRandom());
            HttpsURLConnection con = (HttpsURLConnection)httpsURL.openConnection();
            con.setSSLSocketFactory(sc.getSocketFactory());
            return con;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static InputStream getHttpsStream(URL httpsURL) {
        try {
            HttpsURLConnection con = HttpsUtility.getConnection(httpsURL);
            return con == null ? null : con.getInputStream();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static InputStream getHttpsInputStream(String thisProtocol, String thisHost, String thisPort, String thisPath, String locale) {
        try {
            URL url = new URL(thisProtocol, thisHost, Integer.parseInt(thisPort), String.valueOf(thisPath) + PATH_TOC + '?' + PARAM_LANG + '=' + locale);
            return HttpsUtility.getHttpsStream(url);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static URL getHttpsURL(String thisProtocol, String thisHost, int thisPort, String thisPath) {
        try {
            return new URL(thisProtocol, thisHost, thisPort, String.valueOf(thisPath) + PATH_TOC);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static URL getHttpsURL(String urlPath) {
        try {
            return new URL(urlPath);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static URL getHttpsURL(String thisProtocol, String thisHost, String thisPort, String thisPath) {
        return HttpsUtility.getHttpsURL(thisProtocol, thisHost, Integer.parseInt(thisPort), thisPath);
    }

    public static boolean canConnectToHttpsURL(String urlConnection) {
        try {
            HttpsURLConnection testConnection = HttpsUtility.getConnection(new URL(urlConnection));
            testConnection.setConnectTimeout(5000);
            testConnection.connect();
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }
}

