/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.codemining;

import java.util.function.Consumer;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.views.variables.VariablesView;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.codemining.ICodeMiningProvider;
import org.eclipse.jface.text.codemining.LineEndCodeMining;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class DebugValueCodeMining
extends LineEndCodeMining {
    private IVariable variable;

    protected DebugValueCodeMining(IDocument document, int line, IVariable variable, ICodeMiningProvider provider) throws BadLocationException {
        super(document, line, provider);
        this.variable = variable;
        this.setLabel(DebugUIPlugin.getModelPresentation().getText(variable));
    }

    public Consumer<MouseEvent> getAction() {
        return e -> DebugValueCodeMining.openVariableInVariablesView(this.variable);
    }

    private static void openVariableInVariablesView(IVariable variable) {
        try {
            VariablesView view = (VariablesView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.eclipse.debug.ui.VariableView");
            view.getViewer().setSelection((ISelection)new StructuredSelection((Object)variable));
        }
        catch (PartInitException e) {
            DebugUIPlugin.log(e);
        }
    }

    public boolean isResolved() {
        return true;
    }
}

