/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.shared.target;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardNode;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardSelectionPage;
import org.eclipse.pde.core.target.ITargetDefinition;
import org.eclipse.pde.core.target.ITargetLocation;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.SWTFactory;
import org.eclipse.pde.internal.ui.shared.target.AddFeatureContainersPage;
import org.eclipse.pde.internal.ui.shared.target.EditDirectoryContainerPage;
import org.eclipse.pde.internal.ui.shared.target.EditProfileContainerPage;
import org.eclipse.pde.internal.ui.shared.target.Messages;
import org.eclipse.pde.internal.ui.shared.target.PreviewContainerPage;
import org.eclipse.pde.internal.ui.wizards.WizardElement;
import org.eclipse.pde.ui.target.ITargetLocationWizard;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IPluginContribution;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.activities.WorkbenchActivityHelper;

public class AddBundleContainerSelectionPage
extends WizardSelectionPage {
    private static final String TARGET_LOCATION_PROVISIONER_POINT = "targetLocationProvisioners";
    static final String SETTINGS_SECTION = "editBundleContainerWizard";
    private Text fDescription;
    private ITargetDefinition fTarget;

    protected AddBundleContainerSelectionPage(ITargetDefinition target) {
        super("SelectionPage");
        this.setTitle(Messages.AddBundleContainerSelectionPage_1);
        this.setMessage(Messages.AddBundleContainerSelectionPage_2);
        PDEPlugin.getDefault().getLabelProvider().connect((Object)this);
        this.fTarget = target;
    }

    public void dispose() {
        PDEPlugin.getDefault().getLabelProvider().disconnect((Object)this);
        super.dispose();
    }

    public void createControl(Composite parent) {
        Composite comp = SWTFactory.createComposite(parent, 1, 1, 1808, 0, 0);
        SashForm sashForm = new SashForm(comp, 512);
        GridData gd = new GridData(1808);
        gd.widthHint = 300;
        sashForm.setLayoutData((Object)gd);
        sashForm.setFont(comp.getFont());
        TableViewer wizardSelectionViewer = new TableViewer((Composite)sashForm, 2048);
        wizardSelectionViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        wizardSelectionViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof AbstractBundleContainerNode) {
                    return ((AbstractBundleContainerNode)element).getName();
                }
                return super.getText(element);
            }

            public Image getImage(Object element) {
                if (element instanceof AbstractBundleContainerNode) {
                    return ((AbstractBundleContainerNode)element).getImage();
                }
                return super.getImage(element);
            }
        });
        wizardSelectionViewer.addDoubleClickListener(event -> {
            IStructuredSelection selection = (IStructuredSelection)event.getSelection();
            if (!selection.isEmpty()) {
                this.setSelectedNode((IWizardNode)selection.getFirstElement());
                this.getContainer().showPage(this.getNextPage());
            }
        });
        wizardSelectionViewer.addSelectionChangedListener(event -> {
            IStructuredSelection selection = event.getStructuredSelection();
            if (!selection.isEmpty()) {
                Object element = selection.getFirstElement();
                if (element instanceof AbstractBundleContainerNode) {
                    this.fDescription.setText(((AbstractBundleContainerNode)element).getDescription());
                }
                this.setSelectedNode((IWizardNode)selection.getFirstElement());
            }
        });
        wizardSelectionViewer.getTable().setLayoutData((Object)new GridData(1808));
        wizardSelectionViewer.getTable().setFont(sashForm.getFont());
        this.fDescription = SWTFactory.createText((Composite)sashForm, 2122, 1);
        sashForm.setWeights(new int[]{70, 30});
        this.initViewerContents(wizardSelectionViewer);
        this.setControl((Control)comp);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.pde.doc.user.add_location_wizard");
    }

    private void initViewerContents(TableViewer wizardSelectionViewer) {
        ArrayList<AbstractBundleContainerNode> choices = new ArrayList<AbstractBundleContainerNode>();
        choices.addAll(this.getStandardChoices());
        choices.addAll(this.getTargetLocationProvisionerChoices());
        choices.sort(Comparator.comparing(element -> element.isPreferredOption() ? 0 : 1));
        wizardSelectionViewer.setInput((Object)choices.toArray(new IWizardNode[choices.size()]));
    }

    private List<AbstractBundleContainerNode> getStandardChoices() {
        ArrayList<AbstractBundleContainerNode> standardChoices = new ArrayList<AbstractBundleContainerNode>(4);
        standardChoices.add(new AbstractBundleContainerNode(Messages.AddBundleContainerSelectionPage_3, Messages.AddBundleContainerSelectionPage_4, PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER")){

            @Override
            public IWizard createWizard() {
                Wizard wizard = new Wizard(){
                    private EditDirectoryContainerPage fPage1;

                    public void addPages() {
                        IDialogSettings settings = PDEPlugin.getDefault().getDialogSettings().getSection(AddBundleContainerSelectionPage.SETTINGS_SECTION);
                        if (settings == null) {
                            settings = PDEPlugin.getDefault().getDialogSettings().addNewSection(AddBundleContainerSelectionPage.SETTINGS_SECTION);
                        }
                        this.setDialogSettings(settings);
                        this.fPage1 = new EditDirectoryContainerPage();
                        this.addPage(this.fPage1);
                        this.addPage((IWizardPage)new PreviewContainerPage((this).AddBundleContainerSelectionPage.this.fTarget, this.fPage1));
                        this.setNeedsProgressMonitor(true);
                    }

                    public boolean performFinish() {
                        ITargetLocation container = this.fPage1.getBundleContainer();
                        if (container != null) {
                            this.fPage1.storeSettings();
                            ITargetLocation[] oldContainers = (this).AddBundleContainerSelectionPage.this.fTarget.getTargetLocations();
                            if (oldContainers == null) {
                                (this).AddBundleContainerSelectionPage.this.fTarget.setTargetLocations(new ITargetLocation[]{container});
                            } else {
                                ITargetLocation[] newContainers = new ITargetLocation[oldContainers.length + 1];
                                System.arraycopy(oldContainers, 0, newContainers, 0, oldContainers.length);
                                newContainers[newContainers.length - 1] = container;
                                (this).AddBundleContainerSelectionPage.this.fTarget.setTargetLocations(newContainers);
                            }
                        }
                        return true;
                    }
                };
                wizard.setWindowTitle(Messages.AddBundleContainerSelectionPage_1);
                return wizard;
            }
        });
        standardChoices.add(new AbstractBundleContainerNode(Messages.AddBundleContainerSelectionPage_6, Messages.AddBundleContainerSelectionPage_7, PDEPlugin.getDefault().getLabelProvider().get(PDEPluginImages.DESC_PRODUCT_DEFINITION)){

            @Override
            public IWizard createWizard() {
                Wizard wizard = new Wizard(){
                    private EditProfileContainerPage fPage1;

                    public void addPages() {
                        IDialogSettings settings = PDEPlugin.getDefault().getDialogSettings().getSection(AddBundleContainerSelectionPage.SETTINGS_SECTION);
                        if (settings == null) {
                            settings = PDEPlugin.getDefault().getDialogSettings().addNewSection(AddBundleContainerSelectionPage.SETTINGS_SECTION);
                        }
                        this.setDialogSettings(settings);
                        this.setDialogSettings(settings);
                        this.fPage1 = new EditProfileContainerPage();
                        this.addPage(this.fPage1);
                        this.addPage((IWizardPage)new PreviewContainerPage((this).AddBundleContainerSelectionPage.this.fTarget, this.fPage1));
                        this.setNeedsProgressMonitor(true);
                    }

                    public boolean performFinish() {
                        ITargetLocation container = this.fPage1.getBundleContainer();
                        if (container != null) {
                            this.fPage1.storeSettings();
                            ITargetLocation[] oldContainers = (this).AddBundleContainerSelectionPage.this.fTarget.getTargetLocations();
                            if (oldContainers == null) {
                                (this).AddBundleContainerSelectionPage.this.fTarget.setTargetLocations(new ITargetLocation[]{container});
                            } else {
                                ITargetLocation[] newContainers = new ITargetLocation[oldContainers.length + 1];
                                System.arraycopy(oldContainers, 0, newContainers, 0, oldContainers.length);
                                newContainers[newContainers.length - 1] = container;
                                (this).AddBundleContainerSelectionPage.this.fTarget.setTargetLocations(newContainers);
                            }
                        }
                        return true;
                    }
                };
                wizard.setWindowTitle(Messages.AddBundleContainerSelectionPage_1);
                return wizard;
            }
        });
        standardChoices.add(new AbstractBundleContainerNode(Messages.AddBundleContainerSelectionPage_9, Messages.AddBundleContainerSelectionPage_10, PDEPlugin.getDefault().getLabelProvider().get(PDEPluginImages.DESC_FEATURE_OBJ)){

            @Override
            public IWizard createWizard() {
                Wizard wizard = new Wizard(){

                    public void addPages() {
                        IDialogSettings settings = PDEPlugin.getDefault().getDialogSettings().getSection(AddBundleContainerSelectionPage.SETTINGS_SECTION);
                        if (settings == null) {
                            settings = PDEPlugin.getDefault().getDialogSettings().addNewSection(AddBundleContainerSelectionPage.SETTINGS_SECTION);
                        }
                        this.setDialogSettings(settings);
                        this.addPage(new AddFeatureContainersPage());
                    }

                    public boolean performFinish() {
                        try {
                            ITargetLocation[] containers = ((AddFeatureContainersPage)this.getPages()[0]).getBundleContainers();
                            if (containers != null) {
                                ((AddFeatureContainersPage)this.getPages()[0]).storeSettings();
                                ITargetLocation[] oldContainers = (this).AddBundleContainerSelectionPage.this.fTarget.getTargetLocations();
                                if (oldContainers == null) {
                                    (this).AddBundleContainerSelectionPage.this.fTarget.setTargetLocations(containers);
                                } else {
                                    ITargetLocation[] newContainers = new ITargetLocation[oldContainers.length + containers.length];
                                    System.arraycopy(oldContainers, 0, newContainers, 0, oldContainers.length);
                                    System.arraycopy(containers, 0, newContainers, oldContainers.length, containers.length);
                                    (this).AddBundleContainerSelectionPage.this.fTarget.setTargetLocations(newContainers);
                                }
                            }
                            return true;
                        }
                        catch (CoreException e) {
                            AddBundleContainerSelectionPage.this.setErrorMessage(e.getMessage());
                            return false;
                        }
                    }
                };
                wizard.setWindowTitle(Messages.AddBundleContainerSelectionPage_1);
                return wizard;
            }
        });
        return standardChoices;
    }

    private List<AbstractBundleContainerNode> getTargetLocationProvisionerChoices() {
        IExtension[] extensions;
        ArrayList<AbstractBundleContainerNode> list = new ArrayList<AbstractBundleContainerNode>();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint point = registry.getExtensionPoint(PDEPlugin.getPluginId(), TARGET_LOCATION_PROVISIONER_POINT);
        if (point == null) {
            return list;
        }
        IExtension[] iExtensionArray = extensions = point.getExtensions();
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] elements;
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = elements = extension.getConfigurationElements();
            int n3 = elements.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement element2 = iConfigurationElementArray[n4];
                WizardElement element = this.createWizardElement(element2);
                if (element != null) {
                    final String pluginId = element.getPluginId();
                    final String contributionId = element.getID();
                    IPluginContribution pc = new IPluginContribution(){

                        public String getLocalId() {
                            return contributionId;
                        }

                        public String getPluginId() {
                            return pluginId;
                        }
                    };
                    if (!WorkbenchActivityHelper.filterItem((Object)pc)) {
                        AbstractBundleContainerNode wizardNode = this.createTargetLocationProvisionerNode(element);
                        wizardNode.setPreferredOption("org.eclipse.pde.ui.InstallableUnitProvisioner".equals(contributionId));
                        list.add(wizardNode);
                    }
                }
                ++n4;
            }
            ++n2;
        }
        return list;
    }

    protected WizardElement createWizardElement(IConfigurationElement config) {
        String name = config.getAttribute("name");
        String id = config.getAttribute("id");
        if (name == null || id == null) {
            return null;
        }
        WizardElement element = new WizardElement(config);
        String imageName = config.getAttribute("icon");
        Image image = null;
        if (imageName != null) {
            String pluginID = config.getNamespaceIdentifier();
            image = PDEPlugin.getDefault().getLabelProvider().getImageFromPlugin(pluginID, imageName);
        }
        element.setImage(image);
        return element;
    }

    private AbstractBundleContainerNode createTargetLocationProvisionerNode(final WizardElement element) {
        return new AbstractBundleContainerNode(element.getLabel(), element.getDescription(), element.getImage()){

            @Override
            public IWizard createWizard() {
                Wizard wizard = new Wizard(){
                    private ITargetLocationWizard fWizard;

                    public void addPages() {
                        IWizardPage[] pages;
                        try {
                            this.fWizard = (ITargetLocationWizard)element.createExecutableExtension();
                        }
                        catch (CoreException e) {
                            PDEPlugin.log(e);
                            MessageDialog.openError((Shell)this.getContainer().getShell(), (String)Messages.Errors_CreationError, (String)Messages.Errors_CreationError_NoWizard);
                        }
                        this.fWizard.setTarget((this).AddBundleContainerSelectionPage.this.fTarget);
                        this.fWizard.setContainer(this.getContainer());
                        this.fWizard.addPages();
                        IWizardPage[] iWizardPageArray = pages = this.fWizard.getPages();
                        int n = pages.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IWizardPage page = iWizardPageArray[n2];
                            this.addPage(page);
                            ++n2;
                        }
                    }

                    public boolean performFinish() {
                        if (this.fWizard != null) {
                            if (!this.fWizard.performFinish()) {
                                return false;
                            }
                            ITargetLocation[] locations = this.fWizard.getLocations();
                            if (locations != null) {
                                ITargetLocation[] oldContainers = (this).AddBundleContainerSelectionPage.this.fTarget.getTargetLocations();
                                if (oldContainers == null) {
                                    (this).AddBundleContainerSelectionPage.this.fTarget.setTargetLocations(locations);
                                } else {
                                    ITargetLocation[] newContainers = new ITargetLocation[oldContainers.length + locations.length];
                                    System.arraycopy(oldContainers, 0, newContainers, 0, oldContainers.length);
                                    System.arraycopy(locations, 0, newContainers, oldContainers.length, locations.length);
                                    (this).AddBundleContainerSelectionPage.this.fTarget.setTargetLocations(newContainers);
                                }
                            }
                        }
                        return true;
                    }

                    public boolean canFinish() {
                        if (this.fWizard != null) {
                            return this.fWizard.canFinish();
                        }
                        return true;
                    }

                    public IWizardPage getNextPage(IWizardPage page) {
                        if (this.fWizard != null) {
                            return this.fWizard.getNextPage(page);
                        }
                        return super.getNextPage(page);
                    }

                    public IWizardPage getPreviousPage(IWizardPage page) {
                        if (this.fWizard != null) {
                            return this.fWizard.getPreviousPage(page);
                        }
                        return super.getPreviousPage(page);
                    }
                };
                wizard.setContainer(AddBundleContainerSelectionPage.this.getContainer());
                wizard.setWindowTitle(Messages.AddBundleContainerSelectionPage_1);
                return wizard;
            }
        };
    }

    static abstract class AbstractBundleContainerNode
    implements IWizardNode {
        private String fTypeName;
        private String fTypeDescription;
        private Image fTypeImage;
        private IWizard fWizard;
        private boolean fPreferredOption;

        public AbstractBundleContainerNode(String name, String description, Image image) {
            this.fTypeName = name;
            this.fTypeDescription = description;
            this.fTypeImage = image;
        }

        public abstract IWizard createWizard();

        void setPreferredOption(boolean preferredOption) {
            this.fPreferredOption = preferredOption;
        }

        boolean isPreferredOption() {
            return this.fPreferredOption;
        }

        public void dispose() {
            if (this.fWizard != null) {
                this.fWizard.dispose();
                this.fWizard = null;
            }
        }

        public Point getExtent() {
            return new Point(-1, -1);
        }

        public IWizard getWizard() {
            if (this.fWizard == null) {
                this.fWizard = this.createWizard();
            }
            return this.fWizard;
        }

        public boolean isContentCreated() {
            return this.fWizard != null;
        }

        public String getName() {
            return this.fTypeName;
        }

        public String getDescription() {
            return this.fTypeDescription;
        }

        public Image getImage() {
            return this.fTypeImage;
        }
    }
}

