/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ctx.capability.ui.views;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.rcptt.core.ContextType;
import org.eclipse.rcptt.core.ContextTypeManager;
import org.eclipse.rcptt.core.model.IContext;
import org.eclipse.rcptt.core.model.IQ7Element;
import org.eclipse.rcptt.core.model.IQ7NamedElement;
import org.eclipse.rcptt.core.model.IQ7Project;
import org.eclipse.rcptt.core.model.IQ7ProjectMetadata;
import org.eclipse.rcptt.core.model.ModelException;
import org.eclipse.rcptt.core.model.search.Q7SearchCore;
import org.eclipse.rcptt.core.scenario.Context;
import org.eclipse.rcptt.core.scenario.GroupContext;
import org.eclipse.rcptt.internal.ui.Q7UIPlugin;

class ContextFilter {
    private static Set<String> CONTEXTS_ID = new HashSet<String>();

    static {
        CONTEXTS_ID.add("org.eclipse.rcptt.ctx.super");
        CONTEXTS_ID.add("org.eclipse.rcptt.ctx.capability");
        CONTEXTS_ID.add("org.eclipse.rcptt.ctx.group");
    }

    ContextFilter() {
    }

    public boolean isValidToAdd(IQ7NamedElement element, IQ7NamedElement basicElement) {
        block7: {
            block6: {
                String[] ctx;
                IQ7ProjectMetadata metadata;
                IQ7Project q7Project = basicElement.getQ7Project();
                if (q7Project == null || (metadata = q7Project.getMetadata()) == null || !metadata.exists() || (ctx = metadata.getContexts()) == null || !Arrays.asList(ctx).contains(element.getID())) break block6;
                return false;
            }
            if (!(basicElement.getNamedElement() instanceof GroupContext)) break block7;
            String id = Q7SearchCore.findIDByDocument((IQ7Element)element);
            if (id == null) {
                id = element.getID();
            }
            if (!basicElement.getID().equals(id)) break block7;
            return false;
        }
        try {
            if (element != null && element instanceof IContext) {
                Context context = (Context)element.getNamedElement();
                ContextType type = ContextTypeManager.getInstance().getTypeByContext(context);
                return type != null && !CONTEXTS_ID.contains(type.getId());
            }
        }
        catch (ModelException e) {
            Q7UIPlugin.log((Throwable)e);
        }
        return false;
    }
}

